/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.eclipse.buildship.ui.PluginImage;
import org.eclipse.buildship.ui.PluginImageWithState;
import org.eclipse.buildship.ui.UiPlugin;
import org.eclipse.buildship.ui.util.image.ImageUtils;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;

public enum PluginImages implements PluginImage
{
    TASK((ImmutableMap<PluginImage.ImageState, String>)ImmutableMap.of((Object)((Object)PluginImage.ImageState.ENABLED), (Object)"icons/full/obj16/task.png", (Object)((Object)PluginImage.ImageState.DISABLED), (Object)"icons/full/obj16/task_disabled.png")),
    PRIVATE_TASK((ImmutableMap<PluginImage.ImageState, String>)ImmutableMap.of((Object)((Object)PluginImage.ImageState.ENABLED), (Object)"icons/full/obj16/task_private.png", (Object)((Object)PluginImage.ImageState.DISABLED), (Object)"icons/full/obj16/task_disabled.png")),
    PROJECT_TASK((ImmutableMap<PluginImage.ImageState, String>)ImmutableMap.of((Object)((Object)PluginImage.ImageState.ENABLED), (Object)"icons/full/obj16/task_project.png", (Object)((Object)PluginImage.ImageState.DISABLED), (Object)"icons/full/obj16/task_disabled.png")),
    PRIVATE_PROJECT_TASK((ImmutableMap<PluginImage.ImageState, String>)ImmutableMap.of((Object)((Object)PluginImage.ImageState.ENABLED), (Object)"icons/full/obj16/task_project_private.png", (Object)((Object)PluginImage.ImageState.DISABLED), (Object)"icons/full/obj16/task_disabled.png")),
    PROJECT_GROUP((ImmutableMap<PluginImage.ImageState, String>)ImmutableMap.of((Object)((Object)PluginImage.ImageState.ENABLED), (Object)"icons/full/obj16/project_hierarchy.png")),
    TASK_GROUP((ImmutableMap<PluginImage.ImageState, String>)ImmutableMap.of((Object)((Object)PluginImage.ImageState.ENABLED), (Object)"icons/full/obj16/task-group.png")),
    SORT_BY_TYPE((ImmutableMap<PluginImage.ImageState, String>)ImmutableMap.of((Object)((Object)PluginImage.ImageState.ENABLED), (Object)"icons/full/elcl16/sort_by_type.png")),
    SORT_BY_VISIBILITY((ImmutableMap<PluginImage.ImageState, String>)ImmutableMap.of((Object)((Object)PluginImage.ImageState.ENABLED), (Object)"icons/full/elcl16/sort_by_visibility.png")),
    RUN_TASKS((ImmutableMap<PluginImage.ImageState, String>)ImmutableMap.of((Object)((Object)PluginImage.ImageState.ENABLED), (Object)"icons/full/elcl16/run_tasks.png", (Object)((Object)PluginImage.ImageState.DISABLED), (Object)"icons/full/obj16/task_disabled.png")),
    REFRESH((ImmutableMap<PluginImage.ImageState, String>)ImmutableMap.of((Object)((Object)PluginImage.ImageState.ENABLED), (Object)"icons/full/elcl16/refresh.png", (Object)((Object)PluginImage.ImageState.DISABLED), (Object)"icons/full/dlcl16/refresh.png")),
    LINK_TO_SELECTION((ImmutableMap<PluginImage.ImageState, String>)ImmutableMap.of((Object)((Object)PluginImage.ImageState.ENABLED), (Object)"icons/full/elcl16/link_to_selection.png")),
    REMOVE_CONSOLE((ImmutableMap<PluginImage.ImageState, String>)ImmutableMap.of((Object)((Object)PluginImage.ImageState.ENABLED), (Object)"icons/full/elcl16/remove_page.png", (Object)((Object)PluginImage.ImageState.DISABLED), (Object)"icons/full/dlcl16/remove_page.png")),
    REMOVE_ALL_CONSOLES((ImmutableMap<PluginImage.ImageState, String>)ImmutableMap.of((Object)((Object)PluginImage.ImageState.ENABLED), (Object)"icons/full/elcl16/remove_all_pages.png", (Object)((Object)PluginImage.ImageState.DISABLED), (Object)"icons/full/dlcl16/remove_all_pages.png")),
    CANCEL_BUILD_EXECUTION((ImmutableMap<PluginImage.ImageState, String>)ImmutableMap.of((Object)((Object)PluginImage.ImageState.ENABLED), (Object)"icons/full/elcl16/cancel_build_execution.png", (Object)((Object)PluginImage.ImageState.DISABLED), (Object)"icons/full/dlcl16/cancel_build_execution.png")),
    RERUN_BUILD((ImmutableMap<PluginImage.ImageState, String>)ImmutableMap.of((Object)((Object)PluginImage.ImageState.ENABLED), (Object)"icons/full/elcl16/rerun.png", (Object)((Object)PluginImage.ImageState.DISABLED), (Object)"icons/full/dlcl16/rerun.png")),
    RERUN_FAILED_TESTS((ImmutableMap<PluginImage.ImageState, String>)ImmutableMap.of((Object)((Object)PluginImage.ImageState.ENABLED), (Object)"icons/full/elcl16/rerun_failed_tests.png", (Object)((Object)PluginImage.ImageState.DISABLED), (Object)"icons/full/dlcl16/rerun_failed_tests.png")),
    EXPAND_ALL((ImmutableMap<PluginImage.ImageState, String>)ImmutableMap.of((Object)((Object)PluginImage.ImageState.ENABLED), (Object)"icons/full/elcl16/expand_all.png")),
    RUN_CONFIG_TASKS((ImmutableMap<PluginImage.ImageState, String>)ImmutableMap.of((Object)((Object)PluginImage.ImageState.ENABLED), (Object)"icons/full/eview16/run_config_tasks.png")),
    RUN_CONFIG_GRADLE_DISTRIBUTION((ImmutableMap<PluginImage.ImageState, String>)ImmutableMap.of((Object)((Object)PluginImage.ImageState.ENABLED), (Object)"icons/full/eview16/run_config_gradle_distribution.png")),
    RUN_CONFIG_ARGUMENTS((ImmutableMap<PluginImage.ImageState, String>)ImmutableMap.of((Object)((Object)PluginImage.ImageState.ENABLED), (Object)"icons/full/eview16/run_config_arguments.png")),
    SWITCH_TO_CONSOLE((ImmutableMap<PluginImage.ImageState, String>)ImmutableMap.of((Object)((Object)PluginImage.ImageState.ENABLED), (Object)"icons/full/eview16/consoles_view.png")),
    SWITCH_PAGE((ImmutableMap<PluginImage.ImageState, String>)ImmutableMap.of((Object)((Object)PluginImage.ImageState.ENABLED), (Object)"icons/full/elcl16/switch_page.png")),
    REMOVE_PAGE((ImmutableMap<PluginImage.ImageState, String>)ImmutableMap.of((Object)((Object)PluginImage.ImageState.ENABLED), (Object)"icons/full/elcl16/remove_page.png", (Object)((Object)PluginImage.ImageState.DISABLED), (Object)"icons/full/dlcl16/remove_page.png")),
    REMOVE_ALL_PAGES((ImmutableMap<PluginImage.ImageState, String>)ImmutableMap.of((Object)((Object)PluginImage.ImageState.ENABLED), (Object)"icons/full/elcl16/remove_all_pages.png", (Object)((Object)PluginImage.ImageState.DISABLED), (Object)"icons/full/dlcl16/remove_all_pages.png")),
    FILTER_EXECUTION((ImmutableMap<PluginImage.ImageState, String>)ImmutableMap.of((Object)((Object)PluginImage.ImageState.ENABLED), (Object)"icons/full/elcl16/filter.png")),
    OPERATION_IN_PROGRESS((ImmutableMap<PluginImage.ImageState, String>)ImmutableMap.of((Object)((Object)PluginImage.ImageState.ENABLED), (Object)"icons/full/obj16/operation_inprogress.png")),
    OPERATION_SUCCESS((ImmutableMap<PluginImage.ImageState, String>)ImmutableMap.of((Object)((Object)PluginImage.ImageState.ENABLED), (Object)"icons/full/obj16/operation_success.png")),
    OPERATION_SKIPPED((ImmutableMap<PluginImage.ImageState, String>)ImmutableMap.of((Object)((Object)PluginImage.ImageState.ENABLED), (Object)"icons/full/obj16/operation_skipped.png")),
    OPERATION_FAILURE((ImmutableMap<PluginImage.ImageState, String>)ImmutableMap.of((Object)((Object)PluginImage.ImageState.ENABLED), (Object)"icons/full/obj16/operation_failure.png")),
    PROJECT((ImmutableMap<PluginImage.ImageState, String>)ImmutableMap.of((Object)((Object)PluginImage.ImageState.ENABLED), (Object)"icons/full/obj16/project.png")),
    JAVA_PROJECT((ImmutableMap<PluginImage.ImageState, String>)ImmutableMap.of((Object)((Object)PluginImage.ImageState.ENABLED), (Object)"icons/full/obj16/java_project.png")),
    FAULTY_PROJECT((ImmutableMap<PluginImage.ImageState, String>)ImmutableMap.of((Object)((Object)PluginImage.ImageState.ENABLED), (Object)"icons/full/obj16/faulty_project.png")),
    BUILD_SCAN((ImmutableMap<PluginImage.ImageState, String>)ImmutableMap.of((Object)((Object)PluginImage.ImageState.ENABLED), (Object)"icons/full/obj16/build_scan.png", (Object)((Object)PluginImage.ImageState.DISABLED), (Object)"icons/full/obj16/build_scan_disabled.png"));

    private final ImmutableMap<PluginImage.ImageState, String> images;

    private PluginImages(ImmutableMap<PluginImage.ImageState, String> images) {
        this.images = images;
    }

    public void register() {
        for (Map.Entry entry : this.images.entrySet()) {
            PluginImage.ImageState state = (PluginImage.ImageState)((Object)entry.getKey());
            PluginImageWithState imageWithState = this.withState(state);
            ImageDescriptor imageDescriptor = ImageUtils.findImageDescriptor(UiPlugin.getInstance().getBundle(), (String)entry.getValue());
            this.getImageRegistry().put(imageWithState.getKey(), imageDescriptor);
        }
    }

    @Override
    public PluginImageWithState withState(final PluginImage.ImageState state) {
        return new PluginImageWithState(){

            @Override
            public String getKey() {
                return String.format("%s.%s", new Object[]{PluginImages.this.name(), state});
            }

            @Override
            public Image getImage() {
                Image image = PluginImages.this.getImageRegistry().get(this.getKey());
                if (image == null) {
                    throw new IllegalArgumentException(String.format("Image %s in state %s not available in UiPlugin image registry.", new Object[]{PluginImages.this.name(), state}));
                }
                return image;
            }

            @Override
            public ImageDescriptor getImageDescriptor() {
                ImageDescriptor image = PluginImages.this.getImageRegistry().getDescriptor(this.getKey());
                if (image == null) {
                    throw new IllegalArgumentException(String.format("Image descriptor %s in state %s not available in UiPlugin image registry.", new Object[]{PluginImages.this.name(), state}));
                }
                return image;
            }

            @Override
            public Image getOverlayImage(List<PluginImageWithState> overlayImages) {
                ImmutableList<String> imageKeys = this.getImageKeys(overlayImages);
                return ImageUtils.getOverlayImage(this.getKey(), imageKeys, PluginImages.this.getImageRegistry());
            }

            @Override
            public ImageDescriptor getOverlayImageDescriptor(List<PluginImageWithState> overlayImages) {
                ImmutableList<String> imageKeys = this.getImageKeys(overlayImages);
                return ImageUtils.getOverlayImageDescriptor(this.getKey(), imageKeys, PluginImages.this.getImageRegistry());
            }

            private ImmutableList<String> getImageKeys(List<PluginImageWithState> overlayImages) {
                return FluentIterable.from(overlayImages).transform((Function)new Function<PluginImageWithState, String>(){

                    public String apply(PluginImageWithState imageWithState) {
                        return imageWithState.getKey();
                    }
                }).toList();
            }
        };
    }

    private ImageRegistry getImageRegistry() {
        return UiPlugin.getInstance().getImageRegistry();
    }
}

