/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.transition.system2subsystem.rules.fa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.common.data.activity.AbstractAction;
import org.polarsys.capella.common.data.activity.ActivityNode;
import org.polarsys.capella.common.data.activity.InputPin;
import org.polarsys.capella.common.data.activity.OutputPin;
import org.polarsys.capella.core.data.capellacore.InvolvedElement;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.FaFactory;
import org.polarsys.capella.core.data.fa.FunctionInputPort;
import org.polarsys.capella.core.data.fa.FunctionOutputPort;
import org.polarsys.capella.core.data.fa.FunctionPort;
import org.polarsys.capella.core.data.fa.FunctionalChain;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvement;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvementFunction;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvementLink;
import org.polarsys.capella.core.data.fa.FunctionalChainReference;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.transition.common.constants.Messages;
import org.polarsys.capella.core.transition.common.handlers.log.LogHelper;
import org.polarsys.capella.core.transition.common.handlers.transformation.TransformationHandlerHelper;
import org.polarsys.capella.transition.system2subsystem.handlers.attachment.FunctionalChainAttachmentHelper;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IPremise;

public class FunctionalChainInvolvementRule
extends org.polarsys.capella.core.transition.system.rules.fa.FunctionalChainInvolvementRule {
    public IStatus transformRequired(EObject element_p, IContext context_p) {
        FunctionalChainInvolvement element = (FunctionalChainInvolvement)element_p;
        NamedElement involved = (NamedElement)element.getInvolved();
        IStatus result = TransformationHandlerHelper.getInstance((IContext)context_p).isOrWillBeTransformed((EObject)element.getInvolver(), context_p);
        if (!result.isOK()) {
            return result;
        }
        result = TransformationHandlerHelper.getInstance((IContext)context_p).isOrWillBeTransformed((EObject)involved, context_p);
        FunctionalChainAttachmentHelper helper = FunctionalChainAttachmentHelper.getInstance(context_p);
        if (result.isOK()) {
            if (helper.isValidElement((EObject)element, context_p) != Boolean.TRUE) {
                result = new Status(2, Messages.Activity_Transformation, NLS.bind((String)"Functional Chain Involvement ''{0}'' is not valid.", (Object)LogHelper.getInstance().getText((Object)element_p)));
            }
        } else if (helper.isValidElement((EObject)element, context_p) == Boolean.TRUE) {
            result = Status.OK_STATUS;
        }
        if (result.isOK() && involved instanceof FunctionalExchange) {
            boolean res = true;
            Collection<FunctionalChainInvolvement> nextsValid = helper.getNextValid(element, context_p);
            if (nextsValid.isEmpty()) {
                res = false;
            } else if (!this.FCIsCollectionMatching((Collection<FunctionalChainInvolvement>)element.getNextFunctionalChainInvolvements(), nextsValid)) {
                res = false;
            }
            Collection<FunctionalChainInvolvement> prevsValid = helper.getPreviousValid(element, context_p);
            if (prevsValid.isEmpty()) {
                res = false;
            } else if (!this.FCIsCollectionMatching((Collection<FunctionalChainInvolvement>)element.getPreviousFunctionalChainInvolvements(), prevsValid)) {
                res = false;
            }
            if (!res) {
                result = new Status(2, Messages.Activity_Transformation, NLS.bind((String)"Functional Chain Involvement ''{0}'' is not valid.", (Object)LogHelper.getInstance().getText((Object)element_p)));
            }
        }
        return result;
    }

    private boolean FCIsCollectionMatching(Collection<FunctionalChainInvolvement> fci1, Collection<FunctionalChainInvolvement> fci2) {
        boolean containOne = false;
        for (FunctionalChainInvolvement fci : fci1) {
            for (FunctionalChainInvolvement nextValid : fci2) {
                if (nextValid.getInvolved() == null || !nextValid.getInvolved().equals(fci.getInvolved())) continue;
                containOne = true;
                break;
            }
            if (containOne) break;
        }
        return containOne;
    }

    protected EObject transformDirectElement(EObject src, IContext context_p) {
        EObject trg = super.transformDirectElement(src, context_p);
        return trg;
    }

    protected void attachRelated(EObject src, EObject trg, IContext context) {
        super.attachRelated(src, trg, context);
        FunctionalChainAttachmentHelper helper = FunctionalChainAttachmentHelper.getInstance(context);
        FunctionalChainInvolvement fSrc = (FunctionalChainInvolvement)src;
        FunctionalChainInvolvement fTrg = (FunctionalChainInvolvement)trg;
        if (!fSrc.getNextFunctionalChainInvolvements().isEmpty()) {
            for (FunctionalChainInvolvement nextSrcValid : helper.getNextValid(fSrc, context)) {
                Collection nextTrgs;
                if (nextSrcValid instanceof FunctionalChainInvolvementLink) {
                    boolean isDirectJump = false;
                    for (FunctionalChainInvolvement fci : nextSrcValid.getPreviousFunctionalChainInvolvements()) {
                        if (!fSrc.getInvolved().equals(fci.getInvolved())) continue;
                        isDirectJump = true;
                        break;
                    }
                    if (!isDirectJump && !fSrc.getNextFunctionalChainInvolvements().contains((Object)nextSrcValid)) {
                        nextSrcValid = (FunctionalChainInvolvement)nextSrcValid.getNextFunctionalChainInvolvements().get(0);
                    }
                }
                if ((nextTrgs = this.retrieveTracedElements((EObject)nextSrcValid, context)) == null || nextTrgs.isEmpty()) continue;
                FunctionalChainInvolvement nextTrgValid = (FunctionalChainInvolvement)nextTrgs.iterator().next();
                if (fSrc.getNextFunctionalChainInvolvements().contains((Object)nextSrcValid)) {
                    if (fSrc instanceof FunctionalChainInvolvementFunction && nextSrcValid instanceof FunctionalChainInvolvementLink) {
                        ((FunctionalChainInvolvementLink)nextTrgValid).setSource((FunctionalChainInvolvementFunction)fTrg);
                        continue;
                    }
                    if (!(fSrc instanceof FunctionalChainInvolvementLink) || !(nextSrcValid instanceof FunctionalChainInvolvementFunction)) continue;
                    ((FunctionalChainInvolvementLink)fTrg).setTarget((FunctionalChainInvolvementFunction)nextTrgValid);
                    continue;
                }
                if (nextSrcValid instanceof FunctionalChainInvolvementLink && fSrc instanceof FunctionalChainInvolvementFunction) {
                    ((FunctionalChainInvolvementLink)nextTrgValid).setSource((FunctionalChainInvolvementFunction)fTrg);
                    continue;
                }
                Collection<InvolvedElement> involvedElements = this.listInvolvedElements(fSrc, nextSrcValid);
                String description = this.buildDescription(involvedElements);
                Iterator it = this.retrieveTracedElements((EObject)nextSrcValid.getInvolved(), context).iterator();
                EObject next = (EObject)it.next();
                AbstractFunction nextTrgFct = (AbstractFunction)next;
                String idDiff = nextTrgFct.getClass().getSimpleName().replaceAll("Function", "");
                Collection<FunctionalExchange> fakeFEs = this.createFakeFE(fTrg, nextTrgValid, nextTrgFct, context, description, idDiff = idDiff.replaceAll("Impl", ""));
                if (fakeFEs.isEmpty() || !(fTrg instanceof FunctionalChainInvolvementFunction) || !(nextTrgValid instanceof FunctionalChainInvolvementFunction)) continue;
                FunctionalChainInvolvementLink fakeFCIL = this.createFakeFunctionalChainInvolvementLink(fTrg, nextTrgValid, fakeFEs.iterator().next(), context, idDiff);
                fakeFCIL.setSource((FunctionalChainInvolvementFunction)fTrg);
                fakeFCIL.setTarget((FunctionalChainInvolvementFunction)nextTrgValid);
            }
        }
    }

    private Collection<InvolvedElement> listInvolvedElements(FunctionalChainInvolvement startFci, FunctionalChainInvolvement endFci) {
        ArrayList<InvolvedElement> res = new ArrayList<InvolvedElement>();
        FunctionalChainInvolvement current = startFci;
        while (!current.getNextFunctionalChainInvolvements().isEmpty()) {
            FunctionalChainInvolvement next = (FunctionalChainInvolvement)current.getNextFunctionalChainInvolvements().get(0);
            if (next.equals(endFci)) break;
            current = next;
            res.add(current.getInvolved());
        }
        return res;
    }

    private String buildDescription(Collection<InvolvedElement> involvedElements) {
        StringBuilder descriptionBuilder = new StringBuilder();
        for (InvolvedElement current : involvedElements) {
            NamedElement iv = (NamedElement)current;
            descriptionBuilder.append(String.format("%s(%s);<br/>", iv.getName(), iv.getId()));
        }
        return descriptionBuilder.toString();
    }

    protected void premicesRelated(EObject element_p, ArrayList<IPremise> needed_p) {
        super.premicesRelated(element_p, needed_p);
        if (element_p instanceof FunctionalChainInvolvement) {
            FunctionalChainInvolvement src = (FunctionalChainInvolvement)element_p;
            ArrayList<FunctionalChainInvolvement> nexts = new ArrayList<FunctionalChainInvolvement>();
            while (src.getNextFunctionalChainInvolvements() != null && !src.getNextFunctionalChainInvolvements().isEmpty()) {
                src = (FunctionalChainInvolvement)src.getNextFunctionalChainInvolvements().get(0);
                nexts.add(src);
            }
            needed_p.addAll(this.createDefaultPrecedencePremices(nexts, "nextsInvolvements"));
        }
        if (element_p instanceof FunctionalChainReference) {
            ArrayList fcis = new ArrayList();
            FunctionalChain fc = ((FunctionalChainReference)element_p).getReferencedFunctionalChain();
            fcis.addAll(fc.getOwnedFunctionalChainInvolvements());
            needed_p.addAll(this.createDefaultCriticalPremices(fcis, "referencedInvolvements"));
        }
    }

    private FunctionalChainInvolvementLink createFakeFunctionalChainInvolvementLink(FunctionalChainInvolvement src, FunctionalChainInvolvement trg, FunctionalExchange fe, IContext context_p, String idPrefix) {
        String id = String.format("ID_FakeFunctionalChainInvolvement_%s_%s_%s", idPrefix, src.getSid(), trg.getSid());
        FunctionalChain parent = (FunctionalChain)src.eContainer();
        FunctionalChainInvolvementLink res = null;
        for (FunctionalChainInvolvement fci : src.getNextFunctionalChainInvolvements()) {
            if (!(fci instanceof FunctionalChainInvolvementLink) || !fci.getSid().equals(id)) continue;
            res = (FunctionalChainInvolvementLink)fci;
            break;
        }
        for (FunctionalChainInvolvement fci : trg.getPreviousFunctionalChainInvolvements()) {
            if (!(fci instanceof FunctionalChainInvolvementLink) || !fci.getSid().equals(id)) continue;
            res = (FunctionalChainInvolvementLink)fci;
            break;
        }
        if (res == null) {
            res = FaFactory.eINSTANCE.createFunctionalChainInvolvementLink();
            res.setSid(id);
        }
        res.setInvolved((InvolvedElement)fe);
        parent.getOwnedFunctionalChainInvolvements().add((Object)res);
        return res;
    }

    private Collection<FunctionalExchange> createFakeFE(FunctionalChainInvolvement srcFci, FunctionalChainInvolvement trgFci, AbstractFunction targetFunction, IContext context_p, String description, String idPrefix) {
        ArrayList<FunctionalExchange> res = new ArrayList<FunctionalExchange>();
        ArrayList<Object> srcs = new ArrayList<Object>();
        if (srcFci.getInvolved() instanceof AbstractFunction) {
            srcs.add((AbstractFunction)srcFci.getInvolved());
        } else if (srcFci.getInvolved() instanceof FunctionalChain) {
            srcs.addAll(this.retrieveEndFunctionsOfFC((FunctionalChain)srcFci.getInvolved(), context_p));
        }
        for (AbstractFunction abstractFunction : srcs) {
            AbstractFunction trg = targetFunction;
            String id = String.format("ID_FakeFunctionalExchange_%s_%s_%s", idPrefix, abstractFunction.getSid(), trg.getSid());
            String srcPortId = String.format("ID_FakeFunctionPortOut_%s_%s", abstractFunction.getSid(), id);
            String trgPortId = String.format("ID_FakeFunctionPortIn_%s_%s", trg.getSid(), id);
            EObject container = abstractFunction.eContainer();
            FunctionalExchange fe = null;
            for (FunctionalExchange existingFE : ((AbstractFunction)container).getOwnedFunctionalExchanges()) {
                if (!existingFE.getSid().equals(id)) continue;
                fe = existingFE;
                break;
            }
            if (fe == null) {
                String feName = String.format("FakeFE_%s_%s", abstractFunction.getName(), trg.getName());
                String outPortName = "out_" + feName;
                String inPortName = "in_" + feName;
                FunctionOutputPort srcPort = (FunctionOutputPort)this.getOrCreateFakePort(srcPortId, outPortName, (AbstractAction)abstractFunction, false, context_p);
                FunctionInputPort trgPort = (FunctionInputPort)this.getOrCreateFakePort(trgPortId, inPortName, (AbstractAction)trg, true, context_p);
                fe = FaFactory.eINSTANCE.createFunctionalExchange();
                fe.setSid(id);
                fe.setId(id);
                fe.setDescription(description);
                fe.setName(feName);
                fe.setSource((ActivityNode)srcPort);
                fe.setTarget((ActivityNode)trgPort);
                if (container instanceof AbstractFunction) {
                    ((AbstractFunction)container).getOwnedFunctionalExchanges().add((Object)fe);
                }
            }
            res.add(fe);
        }
        return res;
    }

    private Collection<? extends AbstractFunction> retrieveEndFunctionsOfFC(FunctionalChain fc, IContext context_p) {
        ArrayList<AbstractFunction> res = new ArrayList<AbstractFunction>();
        LinkedList course = new LinkedList();
        course.addAll(fc.getFirstFunctionalChainInvolvements());
        while (!course.isEmpty()) {
            FunctionalChainInvolvement fci = (FunctionalChainInvolvement)course.poll();
            if (fci.getNextFunctionalChainInvolvements().isEmpty()) {
                if (!(fci.getInvolved() instanceof AbstractFunction)) continue;
                res.add((AbstractFunction)fci.getInvolved());
                continue;
            }
            course.addAll(fci.getNextFunctionalChainInvolvements());
        }
        return res;
    }

    private FunctionPort getOrCreateFakePort(String id, String name, AbstractAction fct, boolean input, IContext context_p) {
        FunctionInputPort res = null;
        if (res == null) {
            if (input) {
                for (InputPin port : fct.getInputs()) {
                    if (!port.getId().equals(id)) continue;
                    res = (FunctionPort)port;
                    break;
                }
                if (res == null) {
                    res = FaFactory.eINSTANCE.createFunctionInputPort();
                    fct.getInputs().add((Object)res);
                }
            } else {
                for (OutputPin port : fct.getOutputs()) {
                    if (!port.getId().equals(id)) continue;
                    res = (FunctionPort)port;
                    break;
                }
                if (res == null) {
                    res = FaFactory.eINSTANCE.createFunctionOutputPort();
                    fct.getOutputs().add((Object)((FunctionOutputPort)res));
                }
            }
            res.setSid(id);
            res.setId(id);
            res.setName(name);
        }
        return res;
    }
}

