/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.transition.system2subsystem.handlers.session;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.core.transition.common.capellaHelpers.HashMapSet;
import org.polarsys.capella.core.transition.common.handlers.session.DefaultSessionHandler;
import org.polarsys.capella.transition.system2subsystem.context.SubSystemContext;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class SubSystemSessionHandler
extends DefaultSessionHandler {
    private static final String DEFAULT_EOBJECT = "DEFAULT_EOBJECT";
    private static final String SID_MAP = "SID_MAP";

    public IStatus dispose(IContext context) {
        return Status.OK_STATUS;
    }

    public EObject getEObjectFromId(String id, IContext context) {
        EObject element = null;
        if (id != null) {
            Collection resources = this.getRelatedResources(context);
            Iterator it = resources.iterator();
            while (it.hasNext() && element == null) {
                Resource resource = (Resource)it.next();
                element = resource.getEObject(id);
            }
            if (element == null) {
                HashMapSet map;
                Collection elements;
                if (!context.exists((Object)SID_MAP)) {
                    context.put((Object)SID_MAP, this.createSidMap(resources));
                }
                if (!(elements = (map = (HashMapSet)context.get((Object)SID_MAP)).get((Object)id)).isEmpty()) {
                    element = (EObject)elements.iterator().next();
                }
            }
        }
        if (element != null) {
            return element;
        }
        if (context instanceof SubSystemContext) {
            return this.getDefaultEObject(context);
        }
        return element;
    }

    protected HashMapSet<String, EObject> createSidMap(Collection<Resource> resources) {
        HashMapSet map = new HashMapSet();
        for (Resource resource : resources) {
            TreeIterator childs = resource.getAllContents();
            while (childs.hasNext()) {
                String sid;
                EObject child = (EObject)childs.next();
                if (!(child instanceof ModelElement) || (sid = ((ModelElement)child).getSid()) == null) continue;
                map.put((Object)sid, (Object)child);
            }
        }
        return map;
    }

    protected EObject getDefaultEObject(IContext context_p) {
        if (!context_p.exists((Object)DEFAULT_EOBJECT)) {
            context_p.put((Object)DEFAULT_EOBJECT, (Object)EcorePackage.Literals.ECLASS);
        }
        return (EObject)context_p.get((Object)DEFAULT_EOBJECT);
    }
}

