/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.generator.trace;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.generator.trace.AbsoluteURI;
import org.eclipse.xtext.generator.trace.SourceRelativeURI;
import org.eclipse.xtext.ui.generator.trace.AbstractEclipseTrace;
import org.eclipse.xtext.ui.generator.trace.IStorageAwareTraceContribution;
import org.eclipse.xtext.ui.generator.trace.WrappedCoreException;
import org.eclipse.xtext.ui.shared.contribution.ISharedStateContributionRegistry;
import org.eclipse.xtext.util.Pair;

public class StorageAwareTrace
extends AbstractEclipseTrace {
    private IStorage localStorage;
    private String projectName;
    private ImmutableList<? extends IStorageAwareTraceContribution> contributions = ImmutableList.of();

    @Inject
    private void initializeContributions(ISharedStateContributionRegistry registry) {
        this.contributions = registry.getContributedInstances(IStorageAwareTraceContribution.class);
    }

    public IStorage getLocalStorage() {
        return this.localStorage;
    }

    public AbsoluteURI getLocalURI() {
        IStorage localStorage = this.getLocalStorage();
        return this.getURIForStorage(localStorage);
    }

    @Override
    public IProject getLocalProject() {
        return this.findProject(this.projectName);
    }

    protected AbsoluteURI resolvePath(SourceRelativeURI path) {
        AbsoluteURI result;
        IProject project;
        int i = 0;
        int size = this.contributions.size();
        while (i < size) {
            AbsoluteURI result2 = ((IStorageAwareTraceContribution)this.contributions.get(i)).tryResolvePath(this.localStorage, path);
            if (result2 != null) {
                return result2;
            }
            ++i;
        }
        if (this.localStorage instanceof IFile && (project = ((IFile)this.localStorage).getProject()) != null && (result = this.resolvePath(project, path)) != null) {
            return result;
        }
        return super.resolvePath(path);
    }

    protected AbsoluteURI resolvePath(IProject project, SourceRelativeURI path) {
        String decodedPath = URI.decode((String)path.getURI().toString());
        IResource candidate = project.findMember(decodedPath);
        if (candidate != null && candidate.exists()) {
            return new AbsoluteURI(URI.createPlatformResourceURI((String)(project.getFullPath() + "/" + decodedPath), (boolean)true));
        }
        return null;
    }

    public void setLocalStorage(IStorage derivedResource) {
        this.localStorage = derivedResource;
        if (derivedResource instanceof IResource) {
            this.projectName = ((IResource)derivedResource).getProject().getName();
        }
    }

    @Override
    protected IStorage findStorage(SourceRelativeURI uri, IProject project) {
        AbsoluteURI resolvePath = this.resolvePath(uri);
        Iterable<Pair<IStorage, IProject>> allStorages = this.getStorage2uriMapper().getStorages(resolvePath.getURI());
        for (Pair<IStorage, IProject> storage : allStorages) {
            if (!project.equals(storage.getSecond())) continue;
            return (IStorage)storage.getFirst();
        }
        return null;
    }

    @Override
    protected InputStream getContents(SourceRelativeURI uri, IProject project) throws IOException {
        IStorage storage;
        block3: {
            try {
                storage = this.findStorage(uri, project);
                if (storage != null) break block3;
                return null;
            }
            catch (CoreException e) {
                throw new WrappedCoreException(e);
            }
        }
        return storage.getContents();
    }

    @Override
    protected Reader getContentsAsText(SourceRelativeURI uri, IProject project) throws IOException {
        IStorage storage = this.findStorage(uri, project);
        return this.getContentsAsText(storage);
    }

    @Override
    protected Reader getLocalContentsAsText(IProject project) throws IOException {
        return this.getContentsAsText(this.localStorage);
    }

    protected Reader getContentsAsText(IStorage storage) throws WrappedCoreException {
        if (storage instanceof IEncodedStorage) {
            try {
                IEncodedStorage enc = (IEncodedStorage)storage;
                Charset charset = Charset.forName(enc.getCharset());
                InputStream contents = storage.getContents();
                return new InputStreamReader(contents, charset);
            }
            catch (CoreException e) {
                throw new WrappedCoreException(e);
            }
        }
        return null;
    }
}

