/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.ui.notification;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.capra.core.adapters.Connection;
import org.eclipse.capra.core.adapters.ConnectionQuery;
import org.eclipse.capra.core.adapters.IArtifactMetaModelAdapter;
import org.eclipse.capra.core.adapters.IPersistenceAdapter;
import org.eclipse.capra.core.adapters.ITraceabilityInformationModelAdapter;
import org.eclipse.capra.core.helpers.ArtifactHelper;
import org.eclipse.capra.core.helpers.EditingDomainHelper;
import org.eclipse.capra.core.helpers.ExtensionPointHelper;
import org.eclipse.capra.core.helpers.TraceHelper;
import org.eclipse.capra.ui.operations.CreateTraceOperation;
import org.eclipse.capra.ui.operations.DeleteTraceOperation;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteQuickFix
implements IMarkerResolution {
    private static final Logger LOG = LoggerFactory.getLogger(DeleteQuickFix.class);
    private static final String TRACE_DELETION_TITLE = "Delete trace links";
    IArtifactMetaModelAdapter artifactAdapter = (IArtifactMetaModelAdapter)ExtensionPointHelper.getArtifactMetaModelAdapter().orElseThrow();
    private String label;

    public DeleteQuickFix(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public void run(IMarker marker) {
        try {
            if (!"org.eclipse.capra.ui.notification.capraProblemMarker".equals(marker.getType())) {
                return;
            }
        }
        catch (CoreException e1) {
            LOG.warn("Exception when running DeleteQuickFix", (Throwable)e1);
            return;
        }
        ResourceSet resourceSet = EditingDomainHelper.getResourceSet();
        ArrayList<Connection> toDelete = new ArrayList<Connection>();
        ArrayList<Connection> toUpdate = new ArrayList<Connection>();
        EObject artifactToDelete = null;
        IPersistenceAdapter tracePersistenceAdapter = (IPersistenceAdapter)ExtensionPointHelper.getPersistenceAdapter().orElseThrow();
        EObject traceModel = tracePersistenceAdapter.getTraceModel(resourceSet);
        TraceHelper traceHelper = new TraceHelper(traceModel);
        ITraceabilityInformationModelAdapter traceMetamodelAdapter = (ITraceabilityInformationModelAdapter)ExtensionPointHelper.getTraceabilityInformationModelAdapter().orElseThrow();
        EObject artifactModel = tracePersistenceAdapter.getArtifactWrappers(resourceSet);
        EObject metadataModel = tracePersistenceAdapter.getMetadataContainer(resourceSet);
        String artifactContainerFileName = artifactModel.eResource().getURI().lastSegment();
        String markerContainerFileName = new File(marker.getResource().toString()).getName();
        List artifacts = this.artifactAdapter.getAllArtifacts(artifactModel);
        String markerUri = marker.getAttribute("oldArtifactUri", null);
        if (markerContainerFileName.equals(artifactContainerFileName)) {
            for (EObject aw : artifacts) {
                if (!this.artifactAdapter.getArtifactUri(aw).equals(markerUri)) continue;
                artifactToDelete = aw;
            }
            if (artifactToDelete == null) {
                LOG.warn("Could not find artifact with URI {}", (Object)markerUri);
                return;
            }
            ConnectionQuery query = ConnectionQuery.of((EObject)traceModel, artifactToDelete).build();
            List traceLinks = traceMetamodelAdapter.getConnections(query);
            query = ConnectionQuery.of((EObject)traceModel, (EObject)artifactToDelete).setReverseDirection(true).build();
            traceLinks.addAll(traceMetamodelAdapter.getConnections(query));
            for (Connection con : traceLinks) {
                if (traceHelper.getTracedElements(con).size() <= 2 || con.getOrigins().size() == 1 && con.getOrigins().contains(artifactToDelete) || con.getTargets().size() == 1 && con.getTargets().contains(artifactToDelete)) {
                    toDelete.add(con);
                    continue;
                }
                toDelete.add(con);
                toUpdate.add(con);
            }
        } else {
            List traceLinks = traceMetamodelAdapter.getAllTraceLinks(traceModel);
            for (Connection con : traceLinks) {
                if (con.getOrigins().size() == 1 && Objects.equals(EcoreUtil.getURI((EObject)((EObject)con.getOrigins().get(0))).toString(), markerUri)) {
                    toDelete.add(con);
                }
                if (con.getTargets().size() != 1 || !Objects.equals(EcoreUtil.getURI((EObject)((EObject)con.getTargets().get(0))).toString(), markerUri)) continue;
                toDelete.add(con);
            }
        }
        this.deleteTraces(toDelete);
        this.recreateTraces(toUpdate, artifactToDelete);
        if (artifactToDelete != null) {
            ArtifactHelper helper = new ArtifactHelper(artifactModel);
            try {
                helper.deleteArtifact(artifactToDelete);
            }
            catch (IllegalStateException ex) {
                LOG.warn("Error deleting artifact.", (Throwable)ex);
                return;
            }
        }
        tracePersistenceAdapter.saveModels(traceModel, artifactModel, metadataModel);
        try {
            marker.delete();
        }
        catch (CoreException e) {
            LOG.warn("Could not delete marker.", (Throwable)e);
        }
    }

    private void deleteTraces(List<Connection> toDelete) {
        if (toDelete.isEmpty()) {
            return;
        }
        IWorkbenchPartSite adapter = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart().getSite();
        DeleteTraceOperation deleteTraceOperation = new DeleteTraceOperation(TRACE_DELETION_TITLE, toDelete);
        deleteTraceOperation.addContext(IOperationHistory.GLOBAL_UNDO_CONTEXT);
        IOperationHistory operationHistory = OperationHistoryFactory.getOperationHistory();
        try {
            operationHistory.execute((IUndoableOperation)deleteTraceOperation, null, (IAdaptable)adapter);
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    private void recreateTraces(List<Connection> toUpdate, EObject artifactToDelete) {
        if (toUpdate.isEmpty()) {
            return;
        }
        IWorkbenchPartSite adapter = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart().getSite();
        IOperationHistory operationHistory = OperationHistoryFactory.getOperationHistory();
        for (Connection c : toUpdate) {
            ArrayList newOrigins = new ArrayList(c.getOrigins());
            newOrigins.remove(artifactToDelete);
            ArrayList newTargets = new ArrayList(c.getTargets());
            newTargets.remove(artifactToDelete);
            newOrigins.remove(artifactToDelete);
            CreateTraceOperation createTraceOperation = new CreateTraceOperation("Create trace link", newOrigins, newTargets);
            createTraceOperation.setChooseTraceType((traceTypes, selection) -> Optional.of(c.getTlink().eClass()));
            createTraceOperation.addContext(IOperationHistory.GLOBAL_UNDO_CONTEXT);
            try {
                operationHistory.execute((IUndoableOperation)createTraceOperation, null, (IAdaptable)adapter);
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
    }
}

