/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.client;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.jackson.map.ObjectMapper;
import org.eclipse.cft.server.core.internal.CloudErrorUtil;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.Messages;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.prefs.BackingStoreException;

public class SelfSignedStore {
    public static final String SELF_SIGNED_PREF = "org.eclipse.cft.server.core.selfsigned.certificate";
    private final String serverURL;
    private static final ObjectMapper mapper = new ObjectMapper();
    public static final String VALUE_SEPARATOR = " ";

    public SelfSignedStore(String serverURL) {
        Assert.isNotNull((Object)serverURL);
        this.serverURL = serverURL;
    }

    public boolean isSelfSignedCert() throws CoreException {
        SelfSignedServers servers = this.getStoredServers();
        return servers != null && servers.getServers().get(this.serverURL) != null && servers.getServers().get(this.serverURL) != false;
    }

    public void setSelfSignedCert(boolean selfSigned) throws CoreException {
        SelfSignedServers servers = this.getStoredServers();
        if (servers == null) {
            servers = new SelfSignedServers();
        }
        if (selfSigned) {
            servers.getServers().put(this.serverURL, selfSigned);
        } else {
            servers.getServers().remove(this.serverURL);
        }
        String asString = null;
        if (mapper.canSerialize(servers.getClass())) {
            try {
                asString = mapper.writeValueAsString((Object)servers);
            }
            catch (IOException e) {
                throw CloudErrorUtil.toCoreException(NLS.bind((String)Messages.ERROR_FAILED_STORE_SELF_SIGNED_PREFS, (Object)this.serverURL), e);
            }
        } else {
            throw CloudErrorUtil.toCoreException(NLS.bind((String)Messages.ERROR_FAILED_STORE_SELF_SIGNED_PREFS, (Object)this.serverURL));
        }
        if (asString != null) {
            IEclipsePreferences prefs = CloudFoundryPlugin.getDefault().getPreferences();
            prefs.put(SELF_SIGNED_PREF, asString);
            try {
                prefs.flush();
            }
            catch (BackingStoreException e) {
                throw CloudErrorUtil.toCoreException(NLS.bind((String)Messages.ERROR_FAILED_STORE_SELF_SIGNED_PREFS, (Object)this.serverURL), e);
            }
        }
    }

    protected SelfSignedServers getStoredServers() throws CoreException {
        String storedValue = CloudFoundryPlugin.getDefault().getPreferences().get(SELF_SIGNED_PREF, null);
        SelfSignedServers servers = null;
        if (storedValue != null) {
            try {
                servers = (SelfSignedServers)mapper.readValue(storedValue, SelfSignedServers.class);
            }
            catch (IOException e) {
                String message = NLS.bind((String)Messages.ERROR_FAILED_READ_SELF_SIGNED_PREFS, (Object)this.serverURL);
                throw CloudErrorUtil.toCoreException(message, e);
            }
        }
        return servers;
    }

    public static class SelfSignedServers {
        private Map<String, Boolean> servers = new HashMap<String, Boolean>();

        public Map<String, Boolean> getServers() {
            return this.servers;
        }

        public void setServers(Map<String, Boolean> servers) {
            this.servers.clear();
            if (servers != null) {
                this.servers.putAll(servers);
            }
        }
    }
}

