/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.client;

import org.cloudfoundry.client.lib.CloudFoundryOperations;
import org.eclipse.cft.server.core.internal.CloudErrorUtil;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.Messages;
import org.eclipse.cft.server.core.internal.client.ClientRequest;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.internal.Server;

public abstract class LocalServerRequest<T>
extends ClientRequest<T> {
    private String accessTokenErrorLabel;

    public LocalServerRequest(String label) {
        super(label);
    }

    @Override
    protected String getTokenAccessErrorLabel() {
        if (this.accessTokenErrorLabel == null) {
            String label = super.getRequestLabel();
            String serverName = null;
            try {
                CloudFoundryServer cloudServer = this.getCloudServer();
                if (cloudServer != null && cloudServer.getServer() != null) {
                    serverName = NLS.bind((String)Messages.LocalServerRequest_SERVER_LABEL, (Object)cloudServer.getServer().getId());
                }
            }
            catch (Throwable throwable) {}
            this.accessTokenErrorLabel = serverName != null ? String.valueOf(label) + " - " + serverName : label;
        }
        return this.accessTokenErrorLabel;
    }

    @Override
    public T runAndWait(CloudFoundryOperations client, SubMonitor monitor) throws CoreException {
        Server server;
        CloudFoundryServer cloudServer = this.getCloudServer();
        if (!cloudServer.isSso()) {
            if (cloudServer.getUsername() == null || cloudServer.getUsername().length() == 0 || cloudServer.getPassword() == null || cloudServer.getPassword().length() == 0) {
                CloudFoundryPlugin.getCallback().getCredentials(cloudServer);
            }
        } else if (cloudServer.getToken() == null) {
            CloudFoundryPlugin.getCallback().ssoLoginUserPrompt(cloudServer);
        }
        if ((server = (Server)cloudServer.getServer()).getServerState() == 4 || server.getServerState() == 3) {
            server.setServerState(1);
        }
        try {
            Object result = super.runAndWait(client, monitor);
            if (server.getServerState() != 2) {
                server.setServerState(2);
            }
            return result;
        }
        catch (CoreException ce) {
            if (CloudErrorUtil.isConnectionError(ce) && server.getServerState() == 1) {
                server.setServerState(4);
            }
            throw ce;
        }
    }

    @Override
    protected CloudFoundryOperations getClient(IProgressMonitor monitor) throws CoreException {
        return this.getCloudServer().getBehaviour().getClient(monitor);
    }

    protected abstract CloudFoundryServer getCloudServer() throws CoreException;
}

