/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.wizards;

import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.ui.internal.CloudSpacesDelegate;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.cft.server.ui.internal.ServerWizardValidator;
import org.eclipse.cft.server.ui.internal.ValidationStatus;
import org.eclipse.core.runtime.IStatus;

public class CloneServerWizardValidator
extends ServerWizardValidator {
    public CloneServerWizardValidator(CloudFoundryServer cloudServer, CloudSpacesDelegate cloudServerSpaceDelegate) {
        super(cloudServer, cloudServerSpaceDelegate);
    }

    @Override
    protected ValidationStatus validateLocally() {
        String userName = this.getCloudFoundryServer().getUsername();
        String password = this.getCloudFoundryServer().getPassword();
        String url = this.getCloudFoundryServer().getUrl();
        String message = null;
        boolean valuesFilled = false;
        int validationEventType = 1003;
        if (userName == null || userName.trim().length() == 0) {
            message = Messages.ERROR_NO_USERNAME_SPACES;
        } else if (password == null || password.trim().length() == 0) {
            message = Messages.ERROR_NO_PASSWORD_SPACES;
        } else if (url == null || url.trim().length() == 0) {
            message = Messages.ERROR_NO_URL_SPACES;
        } else {
            valuesFilled = true;
            message = Messages.CLONE_SERVER_WIZARD_OK_MESSAGE;
        }
        int statusType = valuesFilled ? 0 : 4;
        IStatus status = CloudFoundryPlugin.getStatus((String)message, (int)statusType);
        return new ValidationStatus(status, validationEventType);
    }
}

