/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.client;

import java.io.IOException;
import java.util.Set;
import org.cloudfoundry.client.lib.CloudFoundryOperations;
import org.cloudfoundry.client.lib.UploadStatusCallback;
import org.cloudfoundry.client.lib.archive.ApplicationArchive;
import org.eclipse.cft.server.core.CFApplicationArchive;
import org.eclipse.cft.server.core.internal.ApplicationAction;
import org.eclipse.cft.server.core.internal.CloudErrorUtil;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.Messages;
import org.eclipse.cft.server.core.internal.application.ApplicationUtil;
import org.eclipse.cft.server.core.internal.application.CachingApplicationArchive;
import org.eclipse.cft.server.core.internal.client.BehaviourRequest;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.cft.server.core.internal.client.CloudFoundryServerBehaviour;
import org.eclipse.cft.server.core.internal.client.DeploymentConfiguration;
import org.eclipse.cft.server.core.internal.client.RestartOperation;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.internal.Server;

public class StartOperation
extends RestartOperation {
    protected final boolean incrementalPublish;

    public StartOperation(CloudFoundryServerBehaviour behaviour, boolean incrementalPublish, IModule[] modules, boolean clearConsole) {
        super(behaviour, modules, clearConsole);
        this.incrementalPublish = incrementalPublish;
    }

    @Override
    public String getOperationName() {
        return this.incrementalPublish ? Messages.PushApplicationOperation_UPDATE_APP_MESSAGE : Messages.PushApplicationOperation_PUSH_MESSAGE;
    }

    @Override
    protected DeploymentConfiguration getDefaultDeploymentConfiguration() {
        return new DeploymentConfiguration(ApplicationAction.START);
    }

    @Override
    protected void performDeployment(CloudFoundryApplicationModule appModule, IProgressMonitor monitor) throws CoreException {
        IModule actualModule;
        Server server = (Server)this.getBehaviour().getServer();
        final CloudFoundryServer cloudServer = this.getBehaviour().getCloudFoundryServer();
        appModule.setStatus(null);
        final String deploymentName = appModule.getDeploymentInfo().getDeploymentName();
        IModule iModule = actualModule = this.getModules() != null && this.getModules().length > 0 ? this.getModules()[0] : null;
        if (actualModule != null && !actualModule.isExternal()) {
            String generatingArchiveLabel = NLS.bind((String)Messages.CONSOLE_GENERATING_ARCHIVE, (Object)appModule.getDeployedApplicationName());
            this.getBehaviour().printlnToConsole(appModule, generatingArchiveLabel);
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            subMonitor.subTask(generatingArchiveLabel);
            CFApplicationArchive applicationArchive = this.getBehaviour().generateApplicationArchiveFile(appModule.getDeploymentInfo(), appModule, this.getModules(), server, this.incrementalPublish, (IProgressMonitor)subMonitor.newChild(20));
            if (applicationArchive == null) {
                String message = NLS.bind((String)Messages.ERROR_StartOperation_UNSUPPORTED_MODULE_TYPE, (Object[])new String[]{deploymentName, actualModule.getModuleType().getId(), cloudServer.getServer().getId()});
                throw new CoreException((IStatus)new Status(4, "org.eclipse.cft.server.core", message));
            }
            this.getBehaviour().resetPublishState(this.getModules());
            IModule[] serverModules = server.getModules();
            boolean allSynched = true;
            IModule[] iModuleArray = serverModules;
            int n = serverModules.length;
            int n2 = 0;
            while (n2 < n) {
                IModule serverModule = iModuleArray[n2];
                int modulePublishState = server.getModulePublishState(new IModule[]{serverModule});
                if (modulePublishState == 2 || modulePublishState == 3) {
                    allSynched = false;
                }
                ++n2;
            }
            if (allSynched) {
                server.setServerPublishState(1);
            }
            subMonitor.worked(10);
            final CFApplicationArchive applicationArchiveFin = applicationArchive;
            final CloudFoundryApplicationModule appModuleFin = appModule;
            new BehaviourRequest<Void>(String.valueOf(this.getOperationName()) + " - " + deploymentName, this.getBehaviour()){

                @Override
                protected Void doRun(CloudFoundryOperations client, SubMonitor progress) throws CoreException, OperationCanceledException {
                    StartOperation.this.getBehaviour().printlnToConsole(appModuleFin, this.getRequestLabel());
                    if (progress.isCanceled()) {
                        throw new OperationCanceledException(Messages.bind((String)Messages.OPERATION_CANCELED, (Object)this.getRequestLabel()));
                    }
                    StartOperation.this.pushApplication(client, appModuleFin, applicationArchiveFin, (IProgressMonitor)progress);
                    CloudFoundryPlugin.trace("Application " + deploymentName + " pushed to Cloud Foundry server.");
                    cloudServer.moduleAdditionCompleted(StartOperation.this.getModule());
                    return null;
                }
            }.run((IProgressMonitor)subMonitor.newChild(70));
            this.getBehaviour().printlnToConsole(appModule, Messages.CONSOLE_APP_PUSHED_MESSAGE);
        }
        super.performDeployment(appModule, monitor);
    }

    protected void pushApplication(CloudFoundryOperations client, CloudFoundryApplicationModule appModule, CFApplicationArchive applicationArchive, IProgressMonitor monitor) throws CoreException {
        block16: {
            String appName = appModule.getDeploymentInfo().getDeploymentName();
            try {
                this.getBehaviour().getCloudApplication(appName, monitor);
            }
            catch (CoreException e) {
                if (CloudErrorUtil.isNotFoundException(e)) {
                    throw CloudErrorUtil.toCoreException(NLS.bind((String)Messages.ERROR_FAILED_TO_PUSH_APP_DOES_NOT_EXIST, (Object)appName), e);
                }
                throw e;
            }
            try {
                if (applicationArchive != null) {
                    try {
                        if (applicationArchive instanceof CachingApplicationArchive) {
                            final CachingApplicationArchive cachingArchive = (CachingApplicationArchive)applicationArchive;
                            ApplicationArchive v1ArchiveWrapper = ApplicationUtil.asV1ApplicationArchive(cachingArchive);
                            client.uploadApplication(appName, v1ArchiveWrapper, new UploadStatusCallback(){

                                public void onProcessMatchedResources(int length) {
                                }

                                public void onMatchedFileNames(Set<String> matchedFileNames) {
                                    cachingArchive.generatePartialWarFile(matchedFileNames);
                                }

                                public void onCheckResources() {
                                }

                                public boolean onProgress(String status) {
                                    return false;
                                }
                            });
                        } else {
                            ApplicationArchive v1ArchiveWrapper = ApplicationUtil.asV1ApplicationArchive(applicationArchive);
                            client.uploadApplication(appName, v1ArchiveWrapper, new UploadStatusCallback(){

                                public void onProcessMatchedResources(int length) {
                                }

                                public void onMatchedFileNames(Set<String> matchedFileNames) {
                                }

                                public void onCheckResources() {
                                }

                                public boolean onProgress(String status) {
                                    return false;
                                }
                            });
                        }
                        if (monitor.isCanceled()) {
                            throw new OperationCanceledException(Messages.bind((String)Messages.OPERATION_CANCELED, (Object)this.getOperationName()));
                        }
                        break block16;
                    }
                    finally {
                        try {
                            applicationArchive.close();
                        }
                        catch (CoreException e) {
                            CloudFoundryPlugin.logError(e);
                        }
                    }
                }
                throw CloudErrorUtil.toCoreException("Failed to deploy application " + appModule.getDeploymentInfo().getDeploymentName() + " since no deployable war or application archive file was generated.");
            }
            catch (IOException e) {
                throw new CoreException(CloudFoundryPlugin.getErrorStatus("Failed to deploy application " + appModule.getDeploymentInfo().getDeploymentName() + " due to " + e.getMessage(), e));
            }
        }
    }
}

