/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.actions;

import org.eclipse.cft.server.core.internal.client.CloudFoundryServerBehaviour;
import org.eclipse.cft.server.ui.internal.CloudFoundryImages;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.cft.server.ui.internal.actions.EditorAction;
import org.eclipse.cft.server.ui.internal.actions.RefreshModuleEditorAction;
import org.eclipse.cft.server.ui.internal.editor.CloudFoundryApplicationsEditorPage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;

public class RefreshEditorAction
extends Action {
    private final CloudFoundryApplicationsEditorPage editorPage;

    public RefreshEditorAction(CloudFoundryApplicationsEditorPage editorPage) {
        this.setImageDescriptor(CloudFoundryImages.REFRESH);
        this.setText(Messages.RefreshApplicationEditorAction_TEXT_REFRESH);
        this.editorPage = editorPage;
    }

    public static Action getRefreshAction(CloudFoundryApplicationsEditorPage editorPage, EditorAction.RefreshArea area) {
        if (area == EditorAction.RefreshArea.DETAIL && editorPage.getMasterDetailsBlock().getCurrentModule() != null) {
            return new RefreshModuleEditorAction(editorPage);
        }
        return new RefreshEditorAction(editorPage);
    }

    public void run() {
        Job j = new Job(Messages.RefreshApplicationEditorAction_TEXT_JOB){

            protected IStatus run(IProgressMonitor arg0) {
                CloudFoundryServerBehaviour behaviour = RefreshEditorAction.this.editorPage.getCloudServer().getBehaviour();
                behaviour.asyncUpdateAll();
                return Status.OK_STATUS;
            }
        };
        j.setPriority(20);
        j.schedule();
    }
}

