/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.ui.editors;

import java.util.List;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.model.IPeakIdentificationBatchJob;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.model.IPeakInputEntry;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.model.PeakInputEntry;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.ui.editors.BatchProcessEditor;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.ui.editors.IMultiEditorPage;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.ui.internal.wizards.BatchProcessWizardDialog;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.ui.internal.wizards.PeakInputFilesWizard;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class PeakInputFilesPage
implements IMultiEditorPage {
    private FormToolkit toolkit;
    private int pageIndex;
    private IPeakIdentificationBatchJob peakIdentificationBatchJob;
    private Table inputFilesTable;
    private Label countFiles;
    private static final String FILES = "Input Files: ";

    public PeakInputFilesPage(BatchProcessEditor editorPart, Composite container) {
        this.createPage(editorPart, container);
    }

    @Override
    public void setFocus() {
    }

    @Override
    public int getPageIndex() {
        return this.pageIndex;
    }

    @Override
    public void dispose() {
        if (this.toolkit != null) {
            this.toolkit.dispose();
        }
    }

    @Override
    public void setPeakIdentificationBatchJob(IPeakIdentificationBatchJob peakIdentificationBatchJob) {
        if (peakIdentificationBatchJob != null) {
            this.peakIdentificationBatchJob = peakIdentificationBatchJob;
            this.reloadTable();
        }
    }

    private void createPage(BatchProcessEditor editorPart, Composite container) {
        Composite parent = new Composite(container, 0);
        parent.setLayout((Layout)new FillLayout());
        parent.setBackground(Display.getCurrent().getSystemColor(1));
        this.toolkit = new FormToolkit(parent.getDisplay());
        ScrolledForm scrolledForm = this.toolkit.createScrolledForm(parent);
        Composite scrolledFormComposite = scrolledForm.getBody();
        scrolledFormComposite.setLayout((Layout)new TableWrapLayout());
        scrolledForm.setText("Input File Editor");
        this.createInputFilesSection(scrolledFormComposite, editorPart);
        this.pageIndex = editorPart.addPage((Control)parent);
    }

    private void createInputFilesSection(Composite parent, BatchProcessEditor editorPart) {
        Section section = this.toolkit.createSection(parent, 384);
        section.setText("Input files");
        section.setDescription("Select the files to process. Use the add and remove buttons.");
        section.marginWidth = 5;
        section.marginHeight = 5;
        section.setLayoutData((Object)new TableWrapData(256));
        Composite client = this.toolkit.createComposite((Composite)section, 64);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        client.setLayout((Layout)layout);
        this.createTable(client);
        this.createButtons(client, editorPart);
        this.createLabels(client);
        section.setClient((Control)client);
        this.toolkit.paintBordersFor(client);
    }

    private void createTable(Composite client) {
        this.inputFilesTable = this.toolkit.createTable(client, 2);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 300;
        gridData.widthHint = 100;
        gridData.verticalSpan = 2;
        this.inputFilesTable.setLayoutData((Object)gridData);
        this.inputFilesTable.setHeaderVisible(true);
        this.inputFilesTable.setLinesVisible(true);
    }

    private void createButtons(Composite client, BatchProcessEditor editorPart) {
        this.createAddButton(client, editorPart);
        this.createRemoveButton(client, editorPart);
    }

    private void createAddButton(Composite client, final BatchProcessEditor editorPart) {
        Button add = this.toolkit.createButton(client, "Add", 8);
        add.setLayoutData((Object)new GridData(258));
        add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List<String> selectedPeakFiles;
                super.widgetSelected(e);
                PeakInputFilesWizard inputWizard = new PeakInputFilesWizard();
                BatchProcessWizardDialog wizardDialog = new BatchProcessWizardDialog(Display.getCurrent().getActiveShell(), (IWizard)inputWizard);
                wizardDialog.create();
                int returnCode = wizardDialog.open();
                if (returnCode == 0 && (selectedPeakFiles = inputWizard.getSelectedPeakFiles()).size() > 0) {
                    PeakInputFilesPage.this.addEntries(selectedPeakFiles);
                    PeakInputFilesPage.this.reloadTable();
                    editorPart.setDirty();
                }
            }
        });
    }

    private void createRemoveButton(Composite client, final BatchProcessEditor editorPart) {
        Button remove = this.toolkit.createButton(client, "Remove", 8);
        remove.setLayoutData((Object)new GridData(258));
        remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                PeakInputFilesPage.this.removeEntries(PeakInputFilesPage.this.inputFilesTable.getSelectionIndices());
                editorPart.setDirty();
            }
        });
    }

    private void createLabels(Composite client) {
        this.countFiles = this.toolkit.createLabel(client, "Input Files: 0", 0);
        this.countFiles.setLayoutData((Object)new GridData(256));
    }

    private void addEntries(List<String> selectedChromatograms) {
        List inputEntries = this.peakIdentificationBatchJob.getPeakInputEntries();
        for (String inputFile : selectedChromatograms) {
            PeakInputEntry inputEntry = new PeakInputEntry(inputFile);
            inputEntries.add(inputEntry);
        }
    }

    private void removeEntries(int[] indices) {
        if (indices == null || indices.length == 0) {
            return;
        }
        this.inputFilesTable.remove(indices);
        List inputEntries = this.peakIdentificationBatchJob.getPeakInputEntries();
        int counter = 0;
        int[] nArray = indices;
        int n = indices.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            inputEntries.remove(index -= counter);
            ++counter;
            ++n2;
        }
        this.redrawCountFiles(inputEntries);
    }

    private void reloadTable() {
        if (this.peakIdentificationBatchJob != null && this.inputFilesTable != null) {
            this.inputFilesTable.removeAll();
            String[] titles = new String[]{"Filename", "Path"};
            int i = 0;
            while (i < titles.length) {
                TableColumn column = new TableColumn(this.inputFilesTable, 0);
                column.setText(titles[i]);
                ++i;
            }
            List inputEntries = this.peakIdentificationBatchJob.getPeakInputEntries();
            for (IPeakInputEntry entry : inputEntries) {
                TableItem item = new TableItem(this.inputFilesTable, 0);
                item.setText(0, entry.getName());
                item.setText(1, entry.getInputFile());
            }
            int i2 = 0;
            while (i2 < titles.length) {
                this.inputFilesTable.getColumn(i2).pack();
                ++i2;
            }
            this.redrawCountFiles(inputEntries);
        }
    }

    private void redrawCountFiles(List<IPeakInputEntry> inputEntries) {
        this.countFiles.setText(FILES + Integer.toString(inputEntries.size()));
    }
}

