/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.support;

public class SegmentValidator {
    public boolean acceptSegment(float[] values, double mean) {
        double[] doubles = new double[values.length];
        int i = 0;
        while (i < doubles.length) {
            doubles[i] = values[i];
            ++i;
        }
        return this.acceptSegment(doubles, mean);
    }

    public boolean acceptSegment(double[] values, double mean) {
        boolean isAbove = false;
        if (values[0] >= mean) {
            isAbove = true;
        }
        int crossings = 0;
        int length = values.length - 1;
        int i = 0;
        while (i < length) {
            if (isAbove) {
                if (values[i + 1] < mean) {
                    ++crossings;
                    isAbove = false;
                }
            } else if (values[i + 1] > mean) {
                ++crossings;
                isAbove = true;
            }
            ++i;
        }
        boolean accept = false;
        accept = crossings > (length + 1) / 2;
        return accept;
    }
}

