/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.classifier.supplier.molpeak.ui.runnables;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.msd.identifier.peak.PeakIdentifierMSD;
import org.eclipse.chemclipse.model.support.IRetentionTimeRange;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IChromatogramPeakMSD;
import org.eclipse.chemclipse.msd.model.core.selection.ChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.MessageProvider;
import org.eclipse.chemclipse.processing.ui.support.ProcessingInfoViewSupport;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class PeakListIdentifierRunnable
implements IRunnableWithProgress {
    private static final String DESCRIPTION = "MolPeak List Identifier";
    private static final String IDENTIFIER_ID = "org.eclipse.chemclipse.msd.identifier.supplier.basepeak.peak";
    private IChromatogramSelectionMSD chromatogramSelection;

    public PeakListIdentifierRunnable(IChromatogramSelectionMSD chromatogramSelection) {
        this.chromatogramSelection = chromatogramSelection;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            monitor.beginTask(DESCRIPTION, -1);
            if (this.chromatogramSelection != null && this.chromatogramSelection.getChromatogramMSD() != null) {
                IChromatogramMSD chromatogram = this.chromatogramSelection.getChromatogramMSD();
                List peaks = chromatogram.getPeaks((IRetentionTimeRange)this.chromatogramSelection);
                ArrayList<IChromatogramPeakMSD> peakList = new ArrayList<IChromatogramPeakMSD>();
                for (IChromatogramPeakMSD chromatogramPeak : peaks) {
                    peakList.add(chromatogramPeak);
                }
                IProcessingInfo processingInfo = PeakIdentifierMSD.identify(peakList, (String)IDENTIFIER_ID, (IProgressMonitor)monitor);
                ProcessingInfoViewSupport.updateProcessingInfo((MessageProvider)processingInfo, (boolean)false);
                if (this.chromatogramSelection instanceof ChromatogramSelectionMSD) {
                    ((ChromatogramSelectionMSD)this.chromatogramSelection).update(false);
                }
            }
        }
        finally {
            monitor.done();
        }
    }
}

