/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.classifier.supplier.molpeak.classifier;

import java.util.Map;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.msd.classifier.supplier.molpeak.model.ILigninRatios;
import org.eclipse.chemclipse.msd.classifier.supplier.molpeak.model.LigninRatios;

public class BasePeakClassifier {
    public static ILigninRatios calculateLigninRatios(IChromatogramSelection<?, ?> chromatogramSelection) {
        LigninRatios ligninRatios = new LigninRatios();
        double counterS = 0.0;
        double counterG = 0.0;
        double counterL = 0.0;
        double counterC = 0.0;
        IChromatogram chromatogramMSD = chromatogramSelection.getChromatogram();
        for (IPeak peak : chromatogramMSD.getPeaks()) {
            for (IIdentificationTarget peakTarget : peak.getTargets()) {
                String name = peakTarget.getLibraryInformation().getName();
                if (name.equals("Syringyl")) {
                    counterS += peak.getIntegratedArea();
                    continue;
                }
                if (name.equals("Guaiacyl")) {
                    counterG += peak.getIntegratedArea();
                    continue;
                }
                if (name.equals("p-Hydroxyphenyl")) {
                    counterL += peak.getIntegratedArea();
                    continue;
                }
                if (!name.equals("Carbohydrate")) continue;
                counterC += peak.getIntegratedArea();
            }
        }
        double size = counterS + counterG + counterL + counterC;
        if (size > 0.0) {
            Map<String, Double> resultMap = ligninRatios.getResults();
            resultMap.put("Syringyl", counterS / size * 100.0);
            resultMap.put("Guaiacyl", counterG / size * 100.0);
            resultMap.put("p-Hydroxyphenyl", counterL / size * 100.0);
            resultMap.put("Carbohydrate", counterC / size * 100.0);
        }
        return ligninRatios;
    }
}

