/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.classifier.supplier.molpeak.core;

import org.eclipse.chemclipse.chromatogram.msd.identifier.library.AbstractLibraryService;
import org.eclipse.chemclipse.chromatogram.msd.identifier.library.ILibraryService;
import org.eclipse.chemclipse.model.exceptions.ValueMustNotBeNullException;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.msd.classifier.supplier.molpeak.identifier.BasePeakIdentifier;
import org.eclipse.chemclipse.msd.model.core.IMassSpectra;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.ProcessingInfo;
import org.eclipse.core.runtime.IProgressMonitor;

public class LibraryService
extends AbstractLibraryService
implements ILibraryService {
    private final BasePeakIdentifier basePeakIdentifier = new BasePeakIdentifier();

    public IProcessingInfo<IMassSpectra> identify(IIdentificationTarget identificationTarget, IProgressMonitor monitor) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        try {
            monitor.subTask("Base Peak Identifier - get reference mass spectrum");
            this.validateIdentificationTarget(identificationTarget);
            IMassSpectra massSpectra = this.basePeakIdentifier.getMassSpectra(identificationTarget, monitor);
            processingInfo.setProcessingResult((Object)massSpectra);
        }
        catch (ValueMustNotBeNullException e) {
            processingInfo.addErrorMessage("Base Peak Identifier", "The identification target is not available.");
        }
        return processingInfo;
    }

    public boolean accepts(IIdentificationTarget identificationTarget) {
        return this.basePeakIdentifier.isValid(identificationTarget);
    }

    public boolean requireProgressMonitor() {
        return false;
    }
}

