/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.classifier.supplier.molpeak.identifier;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.chemclipse.chromatogram.msd.identifier.settings.IIdentifierSettingsMSD;
import org.eclipse.chemclipse.chromatogram.msd.identifier.settings.IMassSpectrumIdentifierSettings;
import org.eclipse.chemclipse.chromatogram.msd.identifier.settings.IPeakIdentifierSettingsMSD;
import org.eclipse.chemclipse.chromatogram.msd.identifier.supplier.file.core.MassSpectrumIdentifierFile;
import org.eclipse.chemclipse.chromatogram.msd.identifier.supplier.file.core.PeakIdentifierFile;
import org.eclipse.chemclipse.chromatogram.msd.identifier.supplier.file.settings.IFileIdentifierSettings;
import org.eclipse.chemclipse.chromatogram.msd.identifier.supplier.file.settings.MassSpectrumIdentifierSettings;
import org.eclipse.chemclipse.chromatogram.msd.identifier.supplier.file.settings.PeakIdentifierSettings;
import org.eclipse.chemclipse.chromatogram.msd.identifier.support.TargetBuilder;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.exceptions.AbundanceLimitExceededException;
import org.eclipse.chemclipse.model.identifier.ComparisonResult;
import org.eclipse.chemclipse.model.identifier.IComparisonResult;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.msd.classifier.supplier.molpeak.PathResolver;
import org.eclipse.chemclipse.msd.classifier.supplier.molpeak.settings.IBasePeakSettings;
import org.eclipse.chemclipse.msd.converter.database.DatabaseConverter;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.ILibraryMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IMassSpectra;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IPeakMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.exceptions.IonLimitExceededException;
import org.eclipse.chemclipse.msd.model.implementation.Ion;
import org.eclipse.chemclipse.msd.model.implementation.MassSpectra;
import org.eclipse.chemclipse.msd.model.implementation.ScanMSD;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class BasePeakIdentifier {
    private static final Logger logger;
    public static final String SYRINGYL = "Syringyl";
    public static final String GUAIACYL = "Guaiacyl";
    public static final String PHYDROXYPHENYL = "p-Hydroxyphenyl";
    public static final String CARBOHYDRATE = "Carbohydrate";
    private static final String IDENTIFIER = "BASEPEAK-IDENT";
    private static final String MASS_SPECTRUM_COMPARATOR_ID = "org.eclipse.chemclipse.chromatogram.msd.comparison.supplier.incos";
    private static final String NOTFOUND = "Not Found (BasePeak Identifier)";
    private static final ArrayList<Integer> syringylBaseMZs;
    private static final ArrayList<Integer> guaiacylBaseMZs;
    private static final ArrayList<Integer> pHydroxyPhenylBaseMZs;
    private static final ArrayList<Integer> carbohydrateBaseMZs;
    private final TargetBuilder targetBuilder = new TargetBuilder();
    private static final IMassSpectra references;
    private static final IScanMSD syringyl;
    private final String massSpectraFiles = PathResolver.getAbsolutePath("standards/gerberetal2012.msl");

    static {
        Integer currentMZ;
        logger = Logger.getLogger(BasePeakIdentifier.class);
        syringylBaseMZs = new ArrayList();
        guaiacylBaseMZs = new ArrayList();
        pHydroxyPhenylBaseMZs = new ArrayList();
        carbohydrateBaseMZs = new ArrayList();
        references = BasePeakIdentifier.getStandardsMassSpectra();
        syringyl = BasePeakIdentifier.getSyringyl();
        Integer[] syringyl = new Integer[]{149, 154, 167, 181, 182, 192, 194, 208, 210};
        Integer[] guaiacyl = new Integer[]{109, 123, 136, 137, 138, 140, 150, 151, 152, 162, 164, 168, 178};
        Integer[] pHydroxyPhenyl = new Integer[]{94, 107, 108, 120, 121, 124, 134};
        Integer[] carbohydrate = new Integer[]{29, 31, 39, 41, 42, 43, 44, 45, 46, 55, 56, 57, 58, 59, 60, 68, 69, 73, 81, 82, 84, 85, 87, 95, 96, 98, 114, 126, 142};
        Integer[] integerArray = syringyl;
        int n = syringyl.length;
        int n2 = 0;
        while (n2 < n) {
            currentMZ = integerArray[n2];
            syringylBaseMZs.add(currentMZ);
            ++n2;
        }
        integerArray = guaiacyl;
        n = guaiacyl.length;
        n2 = 0;
        while (n2 < n) {
            currentMZ = integerArray[n2];
            guaiacylBaseMZs.add(currentMZ);
            ++n2;
        }
        integerArray = pHydroxyPhenyl;
        n = pHydroxyPhenyl.length;
        n2 = 0;
        while (n2 < n) {
            currentMZ = integerArray[n2];
            pHydroxyPhenylBaseMZs.add(currentMZ);
            ++n2;
        }
        integerArray = carbohydrate;
        n = carbohydrate.length;
        n2 = 0;
        while (n2 < n) {
            currentMZ = integerArray[n2];
            carbohydrateBaseMZs.add(currentMZ);
            ++n2;
        }
    }

    public void identifyPeaks(List<? extends IPeakMSD> peaks, IBasePeakSettings settings, IProgressMonitor monitor) {
        ArrayList<IPeakMSD> peaksNotFound = new ArrayList<IPeakMSD>();
        int i = 0;
        while (i < peaks.size()) {
            IPeakMSD peak = peaks.get(i);
            IPeakMassSpectrum massSpectrum = peak.getExtractedMassSpectrum();
            String name = this.getIdentification((IScanMSD)massSpectrum, settings, i);
            IComparisonResult comparisonResult = this.getComparisonResult();
            IIdentificationTarget peakTarget = this.targetBuilder.getPeakTarget((IScanMSD)massSpectrum, comparisonResult, IDENTIFIER);
            this.setLibraryInformationFields(peakTarget.getLibraryInformation(), name);
            peak.getTargets().add(peakTarget);
            peak.addClassifier(name);
            if (peakTarget.getLibraryInformation().getName().equals(NOTFOUND)) {
                peaksNotFound.add(peak);
            }
            ++i;
        }
        PeakIdentifierSettings peakIdentifierSettings = new PeakIdentifierSettings();
        this.setIdentifierSettings((IIdentifierSettingsMSD)peakIdentifierSettings);
        this.setFileIdentifierSettings((IFileIdentifierSettings)peakIdentifierSettings);
        PeakIdentifierFile peakIdentifier = new PeakIdentifierFile();
        peakIdentifier.identify(peaksNotFound, (IPeakIdentifierSettingsMSD)peakIdentifierSettings, monitor);
        for (IPeakMSD peak : peaksNotFound) {
            Set peakTargets = peak.getTargets();
            if (!this.containsMoreThanOneBasePeakIdentification(peakTargets)) continue;
            IIdentificationTarget peakTargetToRemove = null;
            for (IIdentificationTarget peakTarget : peakTargets) {
                ILibraryInformation libraryInformation = peakTarget.getLibraryInformation();
                if (!libraryInformation.getName().equals(NOTFOUND)) continue;
                peakTargetToRemove = peakTarget;
                break;
            }
            if (peakTargetToRemove == null) continue;
            peak.getTargets().remove(peakTargetToRemove);
        }
    }

    public void identifyMassSpectra(List<IScanMSD> massSpectrumList, IBasePeakSettings settings, IProgressMonitor monitor) {
        ArrayList<IScanMSD> scansNotFound = new ArrayList<IScanMSD>();
        int i = 0;
        while (i < massSpectrumList.size()) {
            IScanMSD massSpectrum = massSpectrumList.get(i);
            String name = this.getIdentification(massSpectrum, settings, i);
            IComparisonResult comparisonResult = this.getComparisonResult();
            IIdentificationTarget massSpectrumTarget = this.targetBuilder.getMassSpectrumTarget(massSpectrum, comparisonResult, IDENTIFIER);
            this.setLibraryInformationFields(massSpectrumTarget.getLibraryInformation(), name);
            massSpectrum.getTargets().add(massSpectrumTarget);
            if (massSpectrumTarget.getLibraryInformation().getName().equals(NOTFOUND)) {
                scansNotFound.add(massSpectrum);
            }
            ++i;
        }
        MassSpectrumIdentifierSettings massSpectrumIdentifierSettings = new MassSpectrumIdentifierSettings();
        this.setIdentifierSettings((IIdentifierSettingsMSD)massSpectrumIdentifierSettings);
        this.setFileIdentifierSettings((IFileIdentifierSettings)massSpectrumIdentifierSettings);
        MassSpectrumIdentifierFile massSpectrumIdentifier = new MassSpectrumIdentifierFile();
        massSpectrumIdentifier.identify(scansNotFound, (IMassSpectrumIdentifierSettings)massSpectrumIdentifierSettings, monitor);
        for (IScanMSD scan : scansNotFound) {
            if (!this.containsMoreThanOneBasePeakIdentificationMassSpectrum(scan.getTargets())) continue;
            IIdentificationTarget targetToRemove = null;
            for (IIdentificationTarget target : scan.getTargets()) {
                ILibraryInformation libraryInformation = target.getLibraryInformation();
                if (!libraryInformation.getName().equals(NOTFOUND)) continue;
                targetToRemove = target;
                break;
            }
            if (targetToRemove == null) continue;
            scan.getTargets().remove(targetToRemove);
        }
    }

    public IMassSpectra getMassSpectra(IIdentificationTarget identificationTarget, IProgressMonitor monitor) {
        String identifier;
        MassSpectra massSpectra = new MassSpectra();
        if (identificationTarget != null && (identifier = identificationTarget.getIdentifier()).equals(IDENTIFIER)) {
            String nameTarget = identificationTarget.getLibraryInformation().getName();
            if (nameTarget.equals(SYRINGYL)) {
                if (syringyl != null) {
                    massSpectra.addMassSpectrum(syringyl);
                }
            } else if (nameTarget.equals(GUAIACYL) || nameTarget.equals(PHYDROXYPHENYL)) {
                ArrayList<IScanMSD> identifiedMassSpectra = new ArrayList<IScanMSD>();
                if (references != null) {
                    for (IScanMSD reference : references.getList()) {
                        ILibraryMassSpectrum libraryMassSpectrum;
                        String nameReference;
                        if (!(reference instanceof ILibraryMassSpectrum) || !(nameReference = (libraryMassSpectrum = (ILibraryMassSpectrum)reference).getLibraryInformation().getName()).equals(nameTarget)) continue;
                        identifiedMassSpectra.add(reference);
                    }
                }
                if (identifiedMassSpectra.size() > 0) {
                    massSpectra.addMassSpectra(identifiedMassSpectra);
                }
            }
        }
        return massSpectra;
    }

    public boolean isValid(IIdentificationTarget identificationTarget) {
        if (identificationTarget != null) {
            return identificationTarget.getIdentifier().equals(IDENTIFIER);
        }
        return false;
    }

    private static IScanMSD getSyringyl() {
        ScanMSD massSpectrum = null;
        try {
            massSpectrum = new ScanMSD();
            massSpectrum.addIon((IIon)new Ion(156.0, 1000.0f));
        }
        catch (AbundanceLimitExceededException e) {
            logger.warn((Object)e);
        }
        catch (IonLimitExceededException e) {
            logger.warn((Object)e);
        }
        return massSpectrum;
    }

    private static IMassSpectra getStandardsMassSpectra() {
        File file = new File(PathResolver.getAbsolutePath("standards/references.msl"));
        IProcessingInfo processingInfo = DatabaseConverter.convert((File)file, (IProgressMonitor)new NullProgressMonitor());
        IMassSpectra massSpectra = (IMassSpectra)processingInfo.getProcessingResult();
        return massSpectra;
    }

    private void setLibraryInformationFields(ILibraryInformation libraryInformation, String name) {
        libraryInformation.setName(name);
        libraryInformation.setMiscellaneous("");
        libraryInformation.setComments("");
        libraryInformation.setCasNumber("");
    }

    private String getIdentification(IScanMSD massSpectrum, IBasePeakSettings settings, int index) {
        int basePeak = (int)massSpectrum.getBasePeak();
        if (syringylBaseMZs.contains(basePeak)) {
            return SYRINGYL;
        }
        if (guaiacylBaseMZs.contains(basePeak)) {
            return GUAIACYL;
        }
        if (pHydroxyPhenylBaseMZs.contains(basePeak)) {
            return PHYDROXYPHENYL;
        }
        if (carbohydrateBaseMZs.contains(basePeak)) {
            return CARBOHYDRATE;
        }
        return NOTFOUND;
    }

    private IComparisonResult getComparisonResult() {
        return new ComparisonResult(100.0f, 100.0f, 100.0f, 100.0f);
    }

    private void setIdentifierSettings(IIdentifierSettingsMSD identifierSettings) {
        identifierSettings.setMassSpectrumComparatorId(MASS_SPECTRUM_COMPARATOR_ID);
        identifierSettings.setPenaltyCalculation("NONE");
        identifierSettings.setPenaltyCalculationLevelFactor(0.0f);
        identifierSettings.setMaxPenalty(0.0f);
        identifierSettings.setRetentionTimeWindow(0);
        identifierSettings.setRetentionIndexWindow(0.0f);
    }

    private void setFileIdentifierSettings(IFileIdentifierSettings fileIdentifierSettings) {
        fileIdentifierSettings.setMassSpectraFiles(this.massSpectraFiles);
        fileIdentifierSettings.setUsePreOptimization(false);
        fileIdentifierSettings.setThresholdPreOptimization(0.1);
        fileIdentifierSettings.setNumberOfTargets(10);
        fileIdentifierSettings.setMinMatchFactor(70.0f);
        fileIdentifierSettings.setMinReverseMatchFactor(70.0f);
        fileIdentifierSettings.setAlternateIdentifierId(IDENTIFIER);
    }

    private boolean containsMoreThanOneBasePeakIdentification(Set<IIdentificationTarget> peakTargets) {
        int counter = 0;
        for (IIdentificationTarget peakTarget : peakTargets) {
            if (!peakTarget.getIdentifier().equals(IDENTIFIER) || ++counter <= 1) continue;
            return true;
        }
        return false;
    }

    private boolean containsMoreThanOneBasePeakIdentificationMassSpectrum(Set<IIdentificationTarget> targets) {
        int counter = 0;
        for (IIdentificationTarget target : targets) {
            if (!target.getIdentifier().equals(IDENTIFIER) || ++counter <= 1) continue;
            return true;
        }
        return false;
    }
}

