/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.model.core;

import org.eclipse.chemclipse.msd.model.core.AbstractIon;
import org.eclipse.chemclipse.msd.model.core.IIonTransition;

public abstract class AbstractIonTransition
implements IIonTransition {
    private static final long serialVersionUID = 96311762449505536L;
    private String compoundName = "";
    private double q1StartIon;
    private double q1StopIon;
    private double q3StartIon;
    private double q3StopIon;
    private double collisionEnergy;
    private double q1Resolution;
    private double q3Resolution;
    private int transitionGroup;
    private int dwell;
    private int q1Ion;
    private double q3Ion;

    public AbstractIonTransition(double filter1FirstIon, double filter1LastIon, double filter3FirstIon, double filter3LastIon, double collisionEnergy, double filter1Resolution, double filter3Resolution, int transitionGroup) {
        this(filter1FirstIon, filter1LastIon, filter3FirstIon, filter3LastIon, collisionEnergy, filter1Resolution, filter3Resolution, transitionGroup, "");
    }

    public AbstractIonTransition(double filter1Ion, double filter3Ion, double collisionEnergy, double filter1Resolution, double filter3Resolution, int transitionGroup) {
        this(filter1Ion, filter1Ion, filter3Ion, filter3Ion, collisionEnergy, filter1Resolution, filter3Resolution, transitionGroup, "");
    }

    public AbstractIonTransition(double filter1Ion, double filter3Ion, double collisionEnergy, double filter1Resolution, double filter3Resolution, int transitionGroup, String compoundName) {
        this(filter1Ion, filter1Ion, filter3Ion, filter3Ion, collisionEnergy, filter1Resolution, filter3Resolution, transitionGroup, compoundName);
    }

    public AbstractIonTransition(IIonTransition ionTransition, String compoundName) {
        this(ionTransition.getQ1StartIon(), ionTransition.getQ1StopIon(), ionTransition.getQ3StartIon(), ionTransition.getQ3StopIon(), ionTransition.getCollisionEnergy(), ionTransition.getQ1Resolution(), ionTransition.getQ3Resolution(), ionTransition.getTransitionGroup(), compoundName);
    }

    public AbstractIonTransition(double filter1FirstIon, double filter1LastIon, double filter3FirstIon, double filter3LastIon, double collisionEnergy, double filter1Resolution, double filter3Resolution, int transitionGroup, String compoundName) {
        this.compoundName = compoundName;
        this.q1StartIon = filter1FirstIon;
        this.q1StopIon = filter1LastIon;
        this.q3StartIon = filter3FirstIon;
        this.q3StopIon = filter3LastIon;
        this.collisionEnergy = collisionEnergy;
        this.q1Resolution = filter1Resolution;
        this.q3Resolution = filter3Resolution;
        this.transitionGroup = transitionGroup;
        this.q1Ion = (int)Math.round((filter1FirstIon + filter1LastIon) / 2.0);
        this.q3Ion = AbstractIon.getIon((filter3FirstIon + filter3LastIon) / 2.0, 1);
        this.dwell = 100;
    }

    @Override
    public String getCompoundName() {
        return this.compoundName;
    }

    @Override
    public void setCompoundName(String compoundName) {
        if (compoundName != null) {
            this.compoundName = compoundName;
        }
    }

    @Override
    public double getQ1Resolution() {
        return this.q1Resolution;
    }

    @Override
    public double getQ3Resolution() {
        return this.q3Resolution;
    }

    @Override
    public double getQ1StartIon() {
        return this.q1StartIon;
    }

    @Override
    public double getQ1StopIon() {
        return this.q1StopIon;
    }

    @Override
    public int getQ1Ion() {
        return this.q1Ion;
    }

    @Override
    public double getDeltaQ1Ion() {
        return this.q1StopIon - this.q1StartIon;
    }

    @Override
    public double getQ3StartIon() {
        return this.q3StartIon;
    }

    @Override
    public double getQ3StopIon() {
        return this.q3StopIon;
    }

    @Override
    public double getQ3Ion() {
        return this.q3Ion;
    }

    @Override
    public double getDeltaQ3Ion() {
        return this.q3StopIon - this.q3StartIon;
    }

    @Override
    public double getCollisionEnergy() {
        return this.collisionEnergy;
    }

    @Override
    public int getTransitionGroup() {
        return this.transitionGroup;
    }

    @Override
    public int getDwell() {
        return this.dwell;
    }

    @Override
    public void setDwell(int dwell) {
        this.dwell = dwell;
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (this.getClass() != otherObject.getClass()) {
            return false;
        }
        AbstractIonTransition other = (AbstractIonTransition)otherObject;
        return this.compoundName.equals(other.getCompoundName()) && this.q1StartIon == other.getQ1StartIon() && this.q1StopIon == other.getQ1StopIon() && this.q3StartIon == other.getQ3StartIon() && this.q3StopIon == other.getQ3StopIon() && this.collisionEnergy == other.getCollisionEnergy() && this.transitionGroup == other.getTransitionGroup() && this.q1Resolution == other.getQ1Resolution() && this.q3Resolution == other.getQ3Resolution();
    }

    public int hashCode() {
        return this.compoundName.hashCode() + 7 * new Double(this.q1StartIon).hashCode() + 11 * new Double(this.q1StopIon).hashCode() + 13 * new Double(this.q3StartIon).hashCode() + 17 * new Double(this.q3StopIon).hashCode() + 13 * new Double(this.collisionEnergy).hashCode() + 11 * new Integer(this.transitionGroup).hashCode() + 7 * new Double(this.q1Resolution).hashCode() + 11 * new Double(this.q3Resolution).hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName());
        builder.append("[");
        builder.append("compoundName=" + this.compoundName);
        builder.append(",");
        builder.append("q1StartIon=" + this.q1StartIon);
        builder.append(",");
        builder.append("q1StopIon=" + this.q1StopIon);
        builder.append(",");
        builder.append("q1Resolution=" + this.q1Resolution);
        builder.append(",");
        builder.append("q3StartIon=" + this.q3StartIon);
        builder.append(",");
        builder.append("q3StopIon=" + this.q3StopIon);
        builder.append(",");
        builder.append("q3Resolution=" + this.q3Resolution);
        builder.append(",");
        builder.append("collisionEnergy=" + this.collisionEnergy);
        builder.append(",");
        builder.append("transitionGroup=" + this.transitionGroup);
        builder.append("]");
        return builder.toString();
    }
}

