/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.processing.supplier;

import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import org.eclipse.chemclipse.processing.DataCategory;
import org.eclipse.chemclipse.processing.supplier.ExecutionResultTransformer;
import org.eclipse.chemclipse.processing.supplier.IProcessTypeSupplier;
import org.eclipse.chemclipse.processing.supplier.ProcessExecutionConsumer;
import org.eclipse.chemclipse.processing.supplier.ProcessExecutionContext;
import org.eclipse.chemclipse.processing.supplier.ProcessExecutor;
import org.eclipse.chemclipse.processing.supplier.ProcessSupplierContext;
import org.eclipse.chemclipse.processing.supplier.ProcessorPreferences;
import org.eclipse.chemclipse.support.settings.parser.SettingsParser;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;

public interface IProcessSupplier<SettingType> {
    public String getId();

    public String getName();

    default public String getCategory() {
        return this.getTypeSupplier().getCategory();
    }

    public String getDescription();

    public Class<SettingType> getSettingsClass();

    public Set<DataCategory> getSupportedDataTypes();

    public SettingsParser<SettingType> getSettingsParser();

    public IProcessTypeSupplier getTypeSupplier();

    default public boolean matchesId(String id) {
        return this.getId().equals(id);
    }

    default public ProcessSupplierContext getContext() {
        if (this instanceof ProcessSupplierContext) {
            return (ProcessSupplierContext)((Object)this);
        }
        return this.getTypeSupplier();
    }

    public static <X, T> T applyProcessor(ProcessorPreferences<X> processorPreferences, ProcessExecutionConsumer<T> consumer, ProcessExecutionContext context) {
        block15: {
            IProcessSupplier<X> supplier = processorPreferences.getSupplier();
            try {
                try {
                    boolean mustSplit;
                    int numberOfCalls = 0;
                    boolean canDirectExecute = consumer.canExecute(processorPreferences);
                    ProcessExecutor supplierExecutionConsumer = null;
                    ExecutionResultTransformer transformer = null;
                    if (canDirectExecute) {
                        ++numberOfCalls;
                    }
                    if (supplier instanceof ProcessExecutor) {
                        supplierExecutionConsumer = (ProcessExecutor)((Object)supplier);
                        ++numberOfCalls;
                    }
                    if (supplier instanceof ExecutionResultTransformer) {
                        transformer = (ExecutionResultTransformer)supplier;
                        ++numberOfCalls;
                    }
                    boolean bl = mustSplit = numberOfCalls > 1;
                    if (mustSplit) {
                        context.setWorkRemaining(numberOfCalls);
                    }
                    context.setContextObject(IProcessSupplier.class, supplier);
                    context.setContextObject(ProcessorPreferences.class, processorPreferences);
                    if (transformer != null) {
                        consumer = transformer.transform(consumer, processorPreferences, mustSplit ? context.split() : context);
                    }
                    context.setContextObject(ProcessExecutionConsumer.class, consumer);
                    if (canDirectExecute) {
                        consumer.execute(processorPreferences, mustSplit ? context.split() : context);
                    }
                    if (supplierExecutionConsumer != null) {
                        supplierExecutionConsumer.execute(processorPreferences, mustSplit ? context.split() : context);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new OperationCanceledException("interrupted");
                }
                catch (Exception e) {
                    Throwable cause = e;
                    if (e instanceof ExecutionException) {
                        cause = e.getCause();
                    }
                    if (e instanceof OperationCanceledException || e instanceof CancellationException) {
                        throw new OperationCanceledException(e.getMessage());
                    }
                    context.addErrorMessage(supplier.getName(), "execution throws an error, processor is skipped", cause);
                    context.setContextObject(IProcessSupplier.class, null);
                    context.setContextObject(ProcessorPreferences.class, null);
                    context.setContextObject(ProcessExecutionConsumer.class, null);
                    break block15;
                }
            }
            catch (Throwable throwable) {
                context.setContextObject(IProcessSupplier.class, null);
                context.setContextObject(ProcessorPreferences.class, null);
                context.setContextObject(ProcessExecutionConsumer.class, null);
                throw throwable;
            }
            context.setContextObject(IProcessSupplier.class, null);
            context.setContextObject(ProcessorPreferences.class, null);
            context.setContextObject(ProcessExecutionConsumer.class, null);
        }
        return consumer.getResult();
    }

    default public SupplierType getType() {
        return SupplierType.DEFAULT;
    }

    default public IStatus validate() {
        return Status.OK_STATUS;
    }

    default public IStatus validate(SettingType settings) {
        return this.validate();
    }

    public static enum SupplierType {
        DEFAULT,
        INTERACTIVE,
        STRUCTURAL;

    }
}

