/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.processing.supplier;

import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.eclipse.chemclipse.processing.DataCategory;
import org.eclipse.chemclipse.processing.supplier.IProcessSupplier;

public interface ProcessSupplierContext {
    public <T> IProcessSupplier<T> getSupplier(String var1);

    public void visitSupplier(Consumer<? super IProcessSupplier<?>> var1);

    default public Set<IProcessSupplier<?>> getSupplier(Predicate<IProcessSupplier<?>> predicate) {
        TreeSet supplier = new TreeSet((o1, o2) -> o1.getId().compareTo(o2.getId()));
        this.visitSupplier(processSupplier -> {
            if (predicate.test((IProcessSupplier<?>)processSupplier)) {
                supplier.add((IProcessSupplier<?>)processSupplier);
            }
        });
        return supplier;
    }

    public static Predicate<IProcessSupplier<?>> forDataTypes(final Iterable<DataCategory> dataTypes) {
        if (dataTypes == null) {
            return test -> true;
        }
        return new Predicate<IProcessSupplier<?>>(){

            @Override
            public boolean test(IProcessSupplier<?> processSupplier) {
                for (DataCategory category : dataTypes) {
                    if (!processSupplier.getSupportedDataTypes().contains((Object)category)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Predicate<IProcessSupplier<?>> createDataCategoryPredicate(DataCategory ... categories) {
        return supplier -> {
            if (supplier == null) {
                return false;
            }
            Set<DataCategory> supportedDataTypes = supplier.getSupportedDataTypes();
            DataCategory[] dataCategoryArray2 = categories;
            int n = categories.length;
            int n2 = 0;
            while (n2 < n) {
                DataCategory dataCategory = dataCategoryArray2[n2];
                if (supportedDataTypes.contains((Object)dataCategory)) {
                    return true;
                }
                ++n2;
            }
            return false;
        };
    }
}

