/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.support.ui.preferences;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import org.eclipse.chemclipse.processing.supplier.IProcessSupplier;
import org.eclipse.chemclipse.processing.supplier.ProcessSupplierContext;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.ui.swt.ControlBuilder;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class ProcessorToolbarPreferencePage
extends PreferencePage {
    public static final String ID_SEPARATOR = "\t";
    private static final Comparator<IProcessSupplier<?>> COMPARATOR = (o1, o2) -> o1.getName().compareTo(o2.getName());
    private final ProcessSupplierContext context;
    private ListViewer avaiableList;
    private final Set<IProcessSupplier<?>> unusedSupplier = new TreeSet(COMPARATOR);
    private final Set<IProcessSupplier<?>> usedSupplier = new TreeSet(COMPARATOR);
    private ListViewer usedList;
    private final String key;
    private final Set<String> addedIds;
    private final Set<String> removedIds;
    private final String keyExclude;
    private final Predicate<IProcessSupplier<?>> filter;

    public ProcessorToolbarPreferencePage(ProcessSupplierContext context, Predicate<IProcessSupplier<?>> filter, IPreferenceStore preferenceStore, String key) {
        this.context = context;
        this.filter = filter;
        this.key = key;
        this.keyExclude = String.valueOf(key) + ".excluded";
        preferenceStore.setDefault(this.keyExclude, "");
        this.addedIds = new HashSet<String>(Arrays.asList(preferenceStore.getString(key).split(ID_SEPARATOR)));
        this.removedIds = new HashSet<String>(Arrays.asList(preferenceStore.getString(this.keyExclude).split(ID_SEPARATOR)));
        this.noDefaultAndApplyButton();
        this.setDescription("Here you can configure the processors that should appear in the Toolbar as a Quick-Access item");
        this.setSize(new Point(400, 600));
        this.setPreferenceStore(preferenceStore);
        this.setTitle("Processor Quick-Access");
    }

    protected Control createContents(Composite parent) {
        Composite container = ControlBuilder.createContainer(parent, 2, true);
        Composite left = ControlBuilder.createContainer(container, 2);
        this.avaiableList = this.createList(left);
        this.createToolbar(left);
        for (IProcessSupplier supplier : this.context.getSupplier(this.filter)) {
            if (this.addedIds.contains(supplier.getId())) {
                this.usedSupplier.add(supplier);
                continue;
            }
            this.unusedSupplier.add(supplier);
        }
        this.avaiableList.setInput(this.unusedSupplier);
        this.usedList = this.createList(container);
        this.usedList.setInput(this.usedSupplier);
        return container;
    }

    public boolean performOk() {
        this.getPreferenceStore().setValue(this.key, ProcessorToolbarPreferencePage.toString(this.addedIds));
        this.getPreferenceStore().setValue(this.keyExclude, ProcessorToolbarPreferencePage.toString(this.removedIds));
        return true;
    }

    private static String toString(Set<String> set) {
        StringBuilder sb = new StringBuilder();
        for (String id : set) {
            if (sb.length() > 0) {
                sb.append(ID_SEPARATOR);
            }
            sb.append(id);
        }
        return sb.toString();
    }

    private void createToolbar(Composite left) {
        ToolBar toolBar = new ToolBar(left, 0x800200);
        ToolItem addItem = new ToolItem(toolBar, 8);
        addItem.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/arrowForward.gif", "16x16"));
        ToolItem removeItem = new ToolItem(toolBar, 8);
        removeItem.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/arrowBackward.gif", "16x16"));
        addItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Object[] objectArray = ProcessorToolbarPreferencePage.this.avaiableList.getStructuredSelection().toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object selected = objectArray[n2];
                    if (selected instanceof IProcessSupplier) {
                        IProcessSupplier supplier = (IProcessSupplier)selected;
                        if (ProcessorToolbarPreferencePage.this.unusedSupplier.remove(supplier)) {
                            ProcessorToolbarPreferencePage.this.usedSupplier.add(supplier);
                            ProcessorToolbarPreferencePage.this.addedIds.add(supplier.getId());
                            ProcessorToolbarPreferencePage.this.removedIds.remove(supplier.getId());
                        }
                    }
                    ProcessorToolbarPreferencePage.this.avaiableList.refresh();
                    ProcessorToolbarPreferencePage.this.usedList.refresh();
                    ++n2;
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        removeItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Object[] objectArray = ProcessorToolbarPreferencePage.this.usedList.getStructuredSelection().toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object selected = objectArray[n2];
                    if (selected instanceof IProcessSupplier) {
                        IProcessSupplier supplier = (IProcessSupplier)selected;
                        if (ProcessorToolbarPreferencePage.this.usedSupplier.remove(supplier)) {
                            ProcessorToolbarPreferencePage.this.unusedSupplier.add(supplier);
                            ProcessorToolbarPreferencePage.this.removedIds.add(supplier.getId());
                            ProcessorToolbarPreferencePage.this.addedIds.remove(supplier.getId());
                        }
                    }
                    ++n2;
                }
                ProcessorToolbarPreferencePage.this.avaiableList.refresh();
                ProcessorToolbarPreferencePage.this.usedList.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private ListViewer createList(Composite parent) {
        ListViewer viewer = new ListViewer(parent);
        viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IProcessSupplier) {
                    return ((IProcessSupplier)element).getName();
                }
                return super.getText(element);
            }
        });
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 350;
        viewer.getControl().setLayoutData((Object)data);
        return viewer;
    }
}

