/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.support.ui.swt;

import java.util.Collections;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.eclipse.chemclipse.processing.supplier.IProcessSupplier;
import org.eclipse.chemclipse.processing.supplier.ProcessSupplierContext;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.ui.preferences.ProcessorToolbarPreferencePage;
import org.eclipse.chemclipse.support.ui.swt.EditorToolBar;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;

public class ProcessorToolbar {
    private static final int MAX_TEXT_LENGTH = 10;
    private final ProcessSupplierContext context;
    private final BiConsumer<IProcessSupplier<?>, ProcessSupplierContext> executionListener;
    private final EditorToolBar editorToolBar;
    private EditorToolBar toolBar;
    private final Predicate<IProcessSupplier<?>> isVisible;
    private String[] ids;

    public ProcessorToolbar(EditorToolBar editorToolBar, ProcessSupplierContext context, Predicate<IProcessSupplier<?>> isVisible, BiConsumer<IProcessSupplier<?>, ProcessSupplierContext> executionListener) {
        this.editorToolBar = editorToolBar;
        this.context = context;
        this.isVisible = isVisible;
        this.executionListener = executionListener;
    }

    private static String shortenName(String name) {
        if (name.length() > 10) {
            return String.valueOf(name.substring(0, 9)) + '\u2026';
        }
        return name;
    }

    public void enablePreferencePage(IPreferenceStore preferenceStore, String key) {
        if (preferenceStore != null) {
            preferenceStore.setDefault(key, "");
            this.editorToolBar.addPreferencePages(() -> Collections.singleton(new ProcessorToolbarPreferencePage(this.context, this.isVisible, preferenceStore, key)), () -> this.setProcessorIds(preferenceStore.getString(key).split("\t")));
            this.setProcessorIds(preferenceStore.getString(key).split("\t"));
        }
    }

    public void setProcessorIds(String ... ids) {
        this.ids = ids;
        this.update();
    }

    public void update() {
        if (this.toolBar != null) {
            this.toolBar.clear();
            this.toolBar = null;
        }
        this.toolBar = this.editorToolBar.createChild(true);
        if (this.ids != null && this.ids.length > 0) {
            String[] stringArray = this.ids;
            int n = this.ids.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                IProcessSupplier supplier = this.context.getSupplier(id);
                if (supplier != null && this.isVisible.test(supplier)) {
                    this.toolBar.addAction((IAction)new EditorToolbarAction(supplier));
                }
                ++n2;
            }
            this.toolBar.setVisible(true);
            this.toolBar.addSeparator();
        }
        this.editorToolBar.update();
    }

    private final class EditorToolbarAction
    extends Action {
        private final IProcessSupplier<?> supplier;

        private EditorToolbarAction(IProcessSupplier<?> supplier) {
            super(ProcessorToolbar.shortenName(supplier.getName()));
            this.supplier = supplier;
            StringBuilder sb = new StringBuilder(supplier.getName());
            String description = supplier.getDescription();
            if (description != null && !description.isEmpty()) {
                sb.append(": ");
                sb.append(description);
            }
            this.setToolTipText(sb.toString());
            this.setId(supplier.getId());
        }

        public ImageDescriptor getImageDescriptor() {
            return ApplicationImageFactory.getInstance().getIcon("org.eclipse.chemclipse.rcp.ui.icons/execute-extension.png");
        }

        public void run() {
            ProcessorToolbar.this.executionListener.accept(this.supplier, ProcessorToolbar.this.context);
        }
    }
}

