/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.wsd.model.core;

import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.exceptions.PeakException;
import org.eclipse.chemclipse.wsd.model.core.AbstractPeakWSD;
import org.eclipse.chemclipse.wsd.model.core.IChromatogramPeakWSD;
import org.eclipse.chemclipse.wsd.model.core.IChromatogramWSD;
import org.eclipse.chemclipse.wsd.model.core.IPeakModelWSD;
import org.eclipse.chemclipse.wsd.model.core.IScanWSD;

public abstract class AbstractChromatogramPeakWSD
extends AbstractPeakWSD
implements IChromatogramPeakWSD {
    private IChromatogramWSD chromatogram;
    private static final float INITIAL_SN_VALUE = -1.0f;
    private float signalToNoiseRatio = -1.0f;

    public AbstractChromatogramPeakWSD(IPeakModelWSD peakModel, IChromatogramWSD chromatogram) throws IllegalArgumentException, PeakException {
        super(peakModel);
        this.validateChromatogram(chromatogram);
        this.validateRetentionTimes(chromatogram, peakModel);
        this.chromatogram = chromatogram;
    }

    public AbstractChromatogramPeakWSD(IPeakModelWSD peakModel, IChromatogramWSD chromatogram, String modelDescription) throws IllegalArgumentException, PeakException {
        this(peakModel, chromatogram);
        this.setModelDescription(modelDescription);
    }

    public int getScanMax() {
        int retentionTime = this.getPeakModel().getRetentionTimeAtPeakMaximum();
        return this.chromatogram.getScanNumber(retentionTime);
    }

    public float getSignalToNoiseRatio() {
        if (this.signalToNoiseRatio == -1.0f) {
            float totalSignal = this.getPeakModel().getPeakAbundance();
            this.signalToNoiseRatio = this.chromatogram.getSignalToNoiseRatio(totalSignal);
        }
        return this.signalToNoiseRatio;
    }

    @Override
    public int getWidthBaselineTotalInScans() {
        int start = this.chromatogram.getScanNumber(this.getPeakModel().getStartRetentionTime());
        if (start == 0) {
            return 0;
        }
        int stop = this.chromatogram.getScanNumber(this.getPeakModel().getStopRetentionTime());
        if (stop == 0) {
            return 0;
        }
        return stop - start + 1;
    }

    public float getPurity() {
        float purity = 0.0f;
        IScan peakScan = this.getPeakModel().getPeakMaximum();
        if (peakScan instanceof IScanWSD) {
            int numberOfSignals;
            IScanWSD peakScanWSD = (IScanWSD)peakScan;
            IScanWSD genuineScanWSD = this.chromatogram.getSupplierScan(this.getScanMax());
            if (peakScanWSD != null && genuineScanWSD != null && (numberOfSignals = genuineScanWSD.getNumberOfScanSignals()) != 0) {
                purity = (float)peakScanWSD.getNumberOfScanSignals() / (float)numberOfSignals;
            }
        }
        return purity;
    }

    @Override
    public IChromatogramWSD getChromatogram() {
        return this.chromatogram;
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (this.getClass() != otherObject.getClass()) {
            return false;
        }
        AbstractChromatogramPeakWSD other = (AbstractChromatogramPeakWSD)otherObject;
        return this.getPeakModel().equals(other.getPeakModel()) && this.chromatogram == other.getChromatogram();
    }

    public int hashCode() {
        return 7 * this.getPeakModel().hashCode() + 11 * this.chromatogram.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName());
        builder.append("[");
        builder.append("peakModel=" + this.getPeakModel());
        builder.append(",");
        builder.append("chromatogram=" + this.chromatogram);
        builder.append("]");
        return builder.toString();
    }
}

