/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.wsd.model.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.eclipse.chemclipse.model.core.AbstractScan;
import org.eclipse.chemclipse.wsd.model.comparator.WavelengthCombinedComparator;
import org.eclipse.chemclipse.wsd.model.comparator.WavelengthComparatorMode;
import org.eclipse.chemclipse.wsd.model.core.IScanSignalWSD;
import org.eclipse.chemclipse.wsd.model.core.IScanWSD;
import org.eclipse.chemclipse.wsd.model.core.IWavelengthBounds;
import org.eclipse.chemclipse.wsd.model.core.WavelengthBounds;
import org.eclipse.chemclipse.wsd.model.core.implementation.ScanSignalWSD;
import org.eclipse.chemclipse.wsd.model.xwc.ExtractedSingleWavelengthSignal;
import org.eclipse.chemclipse.wsd.model.xwc.ExtractedWavelengthSignal;
import org.eclipse.chemclipse.wsd.model.xwc.IExtractedSingleWavelengthSignal;
import org.eclipse.chemclipse.wsd.model.xwc.IExtractedWavelengthSignal;

public abstract class AbstractScanWSD
extends AbstractScan
implements IScanWSD {
    private static final long serialVersionUID = -8298107894544692691L;
    private List<IScanSignalWSD> scanSignals = new ArrayList<IScanSignalWSD>();

    public AbstractScanWSD() {
    }

    public AbstractScanWSD(IScanWSD scanWSD, float actualPercentageIntensity) throws IllegalArgumentException {
        if (scanWSD == null) {
            throw new IllegalArgumentException("The scanWSD must not be null");
        }
        if (actualPercentageIntensity <= 0.0f) {
            throw new IllegalArgumentException("The percentageIntensity must not be > 0.");
        }
        for (IScanSignalWSD scanSignal : scanWSD.getScanSignals()) {
            float abundance = scanSignal.getAbundance() / actualPercentageIntensity * 100.0f;
            this.scanSignals.add(new ScanSignalWSD(scanSignal.getWavelength(), abundance));
        }
    }

    @Override
    public IScanSignalWSD getScanSignal(int scan) {
        return this.scanSignals.get(scan);
    }

    @Override
    public Optional<IScanSignalWSD> getScanSignal(double wavelengt) {
        for (IScanSignalWSD scanSignal : this.scanSignals) {
            if (scanSignal.getWavelength() != wavelengt) continue;
            return Optional.of(scanSignal);
        }
        return Optional.empty();
    }

    @Override
    public void addScanSignal(IScanSignalWSD scanSignalWSD) {
        this.scanSignals.add(scanSignalWSD);
    }

    @Override
    public void removeScanSignal(IScanSignalWSD scanSignalWSD) {
        this.scanSignals.remove(scanSignalWSD);
    }

    @Override
    public void removeScanSignal(int scan) {
        this.scanSignals.remove(scan);
    }

    @Override
    public int getNumberOfScanSignals() {
        return this.scanSignals.size();
    }

    @Override
    public List<IScanSignalWSD> getScanSignals() {
        return Collections.unmodifiableList(this.scanSignals);
    }

    public float getTotalSignal() {
        float totalSignal = 0.0f;
        for (IScanSignalWSD scan : this.scanSignals) {
            totalSignal += scan.getAbundance();
        }
        return totalSignal;
    }

    public void adjustTotalSignal(float totalSignal) {
        if (totalSignal < 0.0f || Float.isNaN(totalSignal) || Float.isInfinite(totalSignal)) {
            return;
        }
        if (this.getTotalSignal() == 0.0f) {
            return;
        }
        float base = 100.0f;
        float correctionFactor = base / this.getTotalSignal() * totalSignal / base;
        for (IScanSignalWSD scanSignal : this.scanSignals) {
            float abundance = scanSignal.getAbundance();
            scanSignal.setAbundance(abundance *= correctionFactor);
        }
    }

    @Override
    @Deprecated
    public IExtractedWavelengthSignal getExtractedWavelengthSignal() {
        if (this.hasScanSignals()) {
            IWavelengthBounds bounds = this.getWavelengthBounds();
            double startWavelength = bounds.getLowestWavelength().getWavelength();
            double stopWavelength = bounds.getHighestWavelength().getWavelength();
            return this.getExtractedWavelengthSignal(startWavelength, stopWavelength);
        }
        return new ExtractedWavelengthSignal(0.0, 0.0);
    }

    @Override
    @Deprecated
    public IExtractedWavelengthSignal getExtractedWavelengthSignal(double startWavelength, double stopWavelength) {
        if (this.hasScanSignals()) {
            ExtractedWavelengthSignal extractedWavelengthSignal = new ExtractedWavelengthSignal(startWavelength, stopWavelength);
            extractedWavelengthSignal.setRetentionTime(this.getRetentionTime());
            for (IScanSignalWSD scanSignal : this.getScanSignals()) {
                extractedWavelengthSignal.setAbundance(scanSignal);
            }
            return extractedWavelengthSignal;
        }
        ExtractedWavelengthSignal extractedWavelengthSignal = new ExtractedWavelengthSignal(0.0, 0.0);
        extractedWavelengthSignal.setRetentionTime(this.getRetentionTime());
        return extractedWavelengthSignal;
    }

    @Override
    public Optional<IExtractedSingleWavelengthSignal> getExtractedSingleWavelengthSignal(double wavelength) {
        Optional<IScanSignalWSD> signal = this.getScanSignal(wavelength);
        if (signal.isPresent()) {
            ExtractedSingleWavelengthSignal extractedSingleWavelengthSignal = new ExtractedSingleWavelengthSignal(signal.get(), this.getRetentionTime(), this.getRetentionIndex());
            return Optional.of(extractedSingleWavelengthSignal);
        }
        return Optional.empty();
    }

    @Override
    public boolean hasScanSignals() {
        return this.scanSignals.size() != 0;
    }

    @Override
    public IWavelengthBounds getWavelengthBounds() {
        IScanSignalWSD lowest = null;
        IScanSignalWSD highest = null;
        if (this.hasScanSignals()) {
            WavelengthCombinedComparator comparator = new WavelengthCombinedComparator(WavelengthComparatorMode.WAVELENGTH_FIRST);
            lowest = Collections.min(this.scanSignals, comparator);
            highest = Collections.max(this.scanSignals, comparator);
            return new WavelengthBounds(lowest, highest);
        }
        return null;
    }
}

