/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.workingset;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.help.internal.criteria.CriterionResource;
import org.eclipse.help.internal.workingset.AdaptableHelpResource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WorkingSet {
    private String name;
    private List<AdaptableHelpResource> elements;
    private List<CriterionResource> criteria;

    public WorkingSet(String name) {
        this(name, (List<AdaptableHelpResource>)null, (List<CriterionResource>)null);
    }

    public WorkingSet(String name, List<AdaptableHelpResource> elements) {
        this(name, elements, null);
    }

    public WorkingSet(String name, List<AdaptableHelpResource> elements, List<CriterionResource> criteria) {
        this.name = name;
        if (elements == null) {
            elements = new ArrayList<AdaptableHelpResource>();
        }
        this.elements = elements;
        this.criteria = criteria != null ? criteria : new ArrayList<CriterionResource>();
    }

    public WorkingSet(String name, AdaptableHelpResource[] elements) {
        this(name, elements, null);
    }

    public WorkingSet(String name, AdaptableHelpResource[] elements, CriterionResource[] criteria) {
        this.name = name;
        if (elements == null) {
            elements = new AdaptableHelpResource[]{};
        }
        this.elements = new ArrayList<AdaptableHelpResource>(elements.length);
        int i = 0;
        while (i < elements.length) {
            this.elements.add(elements[i]);
            ++i;
        }
        if (criteria == null) {
            criteria = new CriterionResource[]{};
        }
        this.criteria = new ArrayList<CriterionResource>(criteria.length);
        int j = 0;
        while (j < criteria.length) {
            this.criteria.add(criteria[j]);
            ++j;
        }
    }

    public void removeElement(AdaptableHelpResource element) {
        this.elements.remove(element);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        if (newName == null) {
            return;
        }
        this.name = newName;
    }

    public AdaptableHelpResource[] getElements() {
        AdaptableHelpResource[] array = new AdaptableHelpResource[this.elements.size()];
        this.elements.toArray(array);
        return array;
    }

    public void setElements(AdaptableHelpResource[] elements) {
        this.elements = new ArrayList<AdaptableHelpResource>(elements.length);
        int i = 0;
        while (i < elements.length) {
            this.elements.add(elements[i]);
            ++i;
        }
    }

    public void setCriteria(CriterionResource[] criteria) {
        this.criteria = new ArrayList<CriterionResource>(criteria.length);
        int i = 0;
        while (i < criteria.length) {
            this.criteria.add(criteria[i]);
            ++i;
        }
    }

    public CriterionResource[] getCriteria() {
        CriterionResource[] array = new CriterionResource[this.criteria.size()];
        this.criteria.toArray(array);
        return array;
    }

    public void saveState(Element parent) {
        Document doc = parent.getOwnerDocument();
        Element ws = doc.createElement("workingSet");
        ws.setAttribute("name", this.name);
        parent.appendChild(ws);
        Element contents = doc.createElement("contents");
        ws.appendChild(contents);
        Iterator<AdaptableHelpResource> it = this.elements.iterator();
        while (it.hasNext()) {
            Element child = doc.createElement("item");
            AdaptableHelpResource helpResource = it.next();
            helpResource.saveState(child);
            contents.appendChild(child);
        }
        if (!this.criteria.isEmpty()) {
            Element criteriaElement = doc.createElement("criteria");
            ws.appendChild(criteriaElement);
            Iterator<CriterionResource> iterator = this.criteria.iterator();
            while (iterator.hasNext()) {
                Element criterionItem = doc.createElement("criterion");
                criteriaElement.appendChild(criterionItem);
                CriterionResource criterion = iterator.next();
                String criterionName = criterion.getCriterionName();
                criterionItem.setAttribute("name", criterionName);
                List criterionValues = criterion.getCriterionValues();
                if (criterionValues.isEmpty()) continue;
                for (String value : criterionValues) {
                    if (value == null) continue;
                    Element item = doc.createElement("item");
                    criterionItem.appendChild(item);
                    item.setAttribute("value", value.trim());
                }
            }
        }
    }
}

