/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.widgets.datadefinition;

import java.util.Arrays;
import java.util.LinkedHashMap;
import org.eclipse.nebula.visualization.widgets.datadefinition.ColorTuple;
import org.eclipse.nebula.visualization.widgets.datadefinition.DoubleArrayWrapper;
import org.eclipse.nebula.visualization.widgets.datadefinition.IPrimaryArrayWrapper;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;

public class ColorMap {
    private LinkedHashMap<Double, RGB> colorMap;
    private PredefinedColorMap predefinedColorMap;
    private boolean autoScale;
    private boolean interpolate;
    private RGB[] colorsLookupTable;
    private int[] pixelLookupTable;
    private PaletteData palette = new PaletteData(255, 65280, 0xFF0000);
    private double colorMapMin;
    private double colorMapMax;

    public ColorMap() {
        this.colorMap = new LinkedHashMap();
        this.setAutoScale(true);
        this.setInterpolate(true);
        this.predefinedColorMap = PredefinedColorMap.None;
    }

    public ColorMap(PredefinedColorMap predefinedColorMap, boolean autoScale, boolean interpolate) {
        this.setAutoScale(autoScale);
        this.setInterpolate(interpolate);
        this.setPredefinedColorMap(predefinedColorMap);
    }

    public LinkedHashMap<Double, RGB> getMap() {
        return this.colorMap;
    }

    public void setColorMap(LinkedHashMap<Double, RGB> colorMap) {
        this.colorMap = colorMap;
        this.predefinedColorMap = PredefinedColorMap.None;
        this.colorsLookupTable = null;
    }

    public void setAutoScale(boolean autoScale) {
        this.autoScale = autoScale;
        this.colorsLookupTable = null;
    }

    public boolean isAutoScale() {
        return this.autoScale;
    }

    public void setInterpolate(boolean interpolate) {
        this.interpolate = interpolate;
    }

    public boolean isInterpolate() {
        return this.interpolate;
    }

    public void setPredefinedColorMap(PredefinedColorMap predefinedColorMap) {
        this.predefinedColorMap = predefinedColorMap;
        if (predefinedColorMap != PredefinedColorMap.None) {
            this.colorMap = predefinedColorMap.getMap();
        }
        this.colorsLookupTable = null;
    }

    public PredefinedColorMap getPredefinedColorMap() {
        return this.predefinedColorMap;
    }

    public String toString() {
        if (this.predefinedColorMap != null && this.predefinedColorMap != PredefinedColorMap.None) {
            return this.predefinedColorMap.toString();
        }
        return "Customized";
    }

    public ImageData drawImage(IPrimaryArrayWrapper dataArray, int dataWidth, int dataHeight, double max, double min, ImageData imageData, boolean shrink) {
        if (dataWidth < 1 || dataHeight < 1 || dataWidth * dataHeight > dataArray.getSize() || dataWidth * dataHeight < 0) {
            return null;
        }
        if (imageData == null) {
            imageData = new ImageData(dataWidth, dataHeight, 24, this.palette);
        }
        if (this.colorsLookupTable == null) {
            this.getColorsLookupTable();
        }
        if (!this.autoScale) {
            min = this.colorMapMin;
            max = this.colorMapMax;
        }
        if (shrink) {
            int height = imageData.height;
            int width = imageData.width;
            int x_ratio = (dataWidth << 16) / width + 1;
            int y_ratio = (dataHeight << 16) / height + 1;
            int i = 0;
            while (i < height) {
                int j = 0;
                while (j < width) {
                    int y2 = i * y_ratio >> 16;
                    int x2 = j * x_ratio >> 16;
                    int index = (int)((dataArray.get(y2 * dataWidth + x2) - min) / (max - min) * 255.0);
                    if (index < 0) {
                        index = 0;
                    } else if (index > 255) {
                        index = 255;
                    }
                    int pixel = this.pixelLookupTable[index];
                    imageData.setPixel(j, i, pixel);
                    ++j;
                }
                ++i;
            }
        } else {
            int y = 0;
            while (y < dataHeight) {
                int x = 0;
                while (x < dataWidth) {
                    int index = (int)((dataArray.get(y * dataWidth + x) - min) / (max - min) * 255.0);
                    if (index < 0) {
                        index = 0;
                    } else if (index > 255) {
                        index = 255;
                    }
                    int pixel = this.pixelLookupTable[index];
                    imageData.setPixel(x, y, pixel);
                    ++x;
                }
                ++y;
            }
        }
        return imageData;
    }

    public ImageData drawImage(double[] dataArray, int dataWidth, int dataHeight, double max, double min) {
        return this.drawImage(new DoubleArrayWrapper(dataArray), dataWidth, dataHeight, max, min, null, false);
    }

    public RGB getValueRGB(ColorTuple[] colorTupleArray, double[] keyArray, double value) {
        int insertPoint = Arrays.binarySearch(keyArray, value);
        if (insertPoint >= 0) {
            return colorTupleArray[insertPoint].rgb;
        }
        if ((insertPoint = -insertPoint - 1) == 0) {
            return colorTupleArray[0].rgb;
        }
        if (insertPoint == colorTupleArray.length) {
            return colorTupleArray[colorTupleArray.length - 1].rgb;
        }
        return this.getInterpolateRGB(colorTupleArray[insertPoint - 1], colorTupleArray[insertPoint], value);
    }

    private RGB getInterpolateRGB(ColorTuple start, ColorTuple end, double value) {
        if (this.interpolate) {
            double f = (value - start.value) / (end.value - start.value);
            int r = (int)((double)(end.rgb.red - start.rgb.red) * f + (double)start.rgb.red);
            int g = (int)((double)(end.rgb.green - start.rgb.green) * f + (double)start.rgb.green);
            int b = (int)((double)(end.rgb.blue - start.rgb.blue) * f + (double)start.rgb.blue);
            return new RGB(r, g, b);
        }
        return start.rgb;
    }

    public RGB[] getColorsLookupTable() {
        if (this.colorsLookupTable == null) {
            Object[] colorTupleArray = new ColorTuple[this.colorMap.size()];
            int i = 0;
            for (Double k : this.colorMap.keySet()) {
                colorTupleArray[i++] = new ColorTuple(k, this.colorMap.get(k));
            }
            Arrays.sort(colorTupleArray);
            this.colorMapMin = ((ColorTuple)colorTupleArray[0]).value;
            this.colorMapMax = ((ColorTuple)colorTupleArray[colorTupleArray.length - 1]).value;
            if (this.autoScale) {
                Object[] objectArray = colorTupleArray;
                int n = colorTupleArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object t = objectArray[n2];
                    ((ColorTuple)t).value = (((ColorTuple)t).value - this.colorMapMin) / (this.colorMapMax - this.colorMapMin);
                    ++n2;
                }
            }
            double[] keyArray = new double[colorTupleArray.length];
            int j = 0;
            while (j < colorTupleArray.length) {
                keyArray[j] = ((ColorTuple)colorTupleArray[j]).value;
                ++j;
            }
            this.colorsLookupTable = new RGB[256];
            this.pixelLookupTable = new int[256];
            int k = 0;
            while (k < 256) {
                this.colorsLookupTable[k] = this.getValueRGB((ColorTuple[])colorTupleArray, keyArray, this.autoScale ? (double)k / 255.0 : this.colorMapMin + (double)k * (this.colorMapMax - this.colorMapMin) / 255.0);
                this.pixelLookupTable[k] = this.palette.getPixel(this.colorsLookupTable[k]);
                ++k;
            }
        }
        return this.colorsLookupTable;
    }

    public PaletteData getPalette() {
        return this.palette;
    }

    public static enum PredefinedColorMap {
        None("None", new double[0], new RGB[0]),
        GrayScale("GrayScale", new double[]{0.0, 1.0}, new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255)}),
        JET("JET", new double[]{0.0, 0.111, 0.365, 0.619, 0.873, 1.0}, new RGB[]{new RGB(0, 0, 143), new RGB(0, 0, 255), new RGB(0, 255, 255), new RGB(255, 255, 0), new RGB(255, 0, 0), new RGB(128, 0, 0)}),
        ColorSpectrum("ColorSpectrum", new double[]{0.0, 0.126, 0.251, 0.375, 0.5, 0.625, 0.749, 0.874, 1.0}, new RGB[]{new RGB(0, 0, 0), new RGB(255, 0, 255), new RGB(0, 0, 255), new RGB(0, 255, 255), new RGB(0, 255, 0), new RGB(255, 255, 0), new RGB(255, 128, 0), new RGB(255, 0, 0), new RGB(255, 255, 255)}),
        Hot("Hot", new double[]{0.0, 0.365, 0.746, 1.0}, new RGB[]{new RGB(11, 0, 0), new RGB(255, 0, 0), new RGB(255, 255, 0), new RGB(255, 255, 255)}),
        Cool("Cool", new double[]{0.0, 1.0}, new RGB[]{new RGB(0, 255, 255), new RGB(255, 0, 255)}),
        Shaded("Shaded", new double[]{0.0, 0.5, 1.0}, new RGB[]{new RGB(0, 0, 0), new RGB(255, 0, 0), new RGB(255, 255, 255)});

        String name;
        double[] values;
        RGB[] colors;

        private PredefinedColorMap(String name, double[] values, RGB[] colors) {
            this.name = name;
            this.values = values;
            this.colors = colors;
        }

        public LinkedHashMap<Double, RGB> getMap() {
            LinkedHashMap<Double, RGB> map = new LinkedHashMap<Double, RGB>();
            int i = 0;
            while (i < this.values.length) {
                map.put(this.values[i], this.colors[i]);
                ++i;
            }
            return map;
        }

        public static String[] getStringValues() {
            String[] result = new String[PredefinedColorMap.values().length];
            int i = 0;
            PredefinedColorMap[] predefinedColorMapArray = PredefinedColorMap.values();
            int n = predefinedColorMapArray.length;
            int n2 = 0;
            while (n2 < n) {
                PredefinedColorMap m = predefinedColorMapArray[n2];
                result[i++] = m.name;
                ++n2;
            }
            return result;
        }

        public static int toIndex(PredefinedColorMap p) {
            return Arrays.asList(PredefinedColorMap.values()).indexOf((Object)p);
        }

        public static PredefinedColorMap fromIndex(int index) {
            return Arrays.asList(PredefinedColorMap.values()).get(index);
        }

        public String toString() {
            return this.name;
        }
    }
}

