/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.xygraph.figures;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.nebula.visualization.xygraph.figures.Axis;
import org.eclipse.nebula.visualization.xygraph.figures.IAxisListener;
import org.eclipse.nebula.visualization.xygraph.linearscale.Range;
import org.eclipse.swt.graphics.Color;

public class Grid
extends Figure
implements IAxisListener {
    private Axis axis;

    public Grid(Axis axis) {
        axis.addListener(this);
        this.axis = axis;
        axis.setGrid(this);
    }

    protected void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
        graphics.pushState();
        if (this.axis.isShowMajorGrid()) {
            graphics.setLineStyle(this.axis.isDashGridLine() ? 2 : 1);
            graphics.setForegroundColor(this.axis.getMajorGridColor());
            graphics.setLineWidth(1);
            for (int pos : this.axis.getScaleTickLabels().getTickLabelPositions()) {
                if (this.axis.isHorizontal()) {
                    graphics.drawLine(this.axis.getBounds().x + pos, this.bounds.y + this.bounds.height, this.axis.getBounds().x + pos, this.bounds.y);
                    continue;
                }
                graphics.drawLine(this.bounds.x, this.axis.getBounds().y + this.axis.getBounds().height - pos, this.bounds.x + this.bounds.width, this.axis.getBounds().y + this.axis.getBounds().height - pos);
            }
        }
        graphics.popState();
    }

    @Override
    public void axisRevalidated(Axis axis) {
        if (axis.isShowMajorGrid()) {
            this.repaint();
        }
    }

    @Override
    public void axisRangeChanged(Axis axis, Range old_range, Range new_range) {
    }

    @Override
    public void axisForegroundColorChanged(Axis axis, Color oldColor, Color newColor) {
    }

    @Override
    public void axisTitleChanged(Axis axis, String oldTitle, String newTitle) {
    }

    @Override
    public void axisAutoScaleChanged(Axis axis, boolean oldAutoScale, boolean newAutoScale) {
    }

    @Override
    public void axisLogScaleChanged(Axis axis, boolean old, boolean logScale) {
    }
}

