/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.xygraph.styleprovider;

import java.util.Map;
import java.util.TreeMap;
import org.eclipse.nebula.visualization.xygraph.dataprovider.IMetaData;
import org.eclipse.nebula.visualization.xygraph.dataprovider.ISample;
import org.eclipse.nebula.visualization.xygraph.figures.Trace;
import org.eclipse.nebula.visualization.xygraph.styleprovider.BasePointStyleProvider;
import org.eclipse.nebula.visualization.xygraph.util.XYGraphMediaFactory;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class DoubleStyleProvider
extends BasePointStyleProvider {
    static TreeMap<Double, RGB> COLOR_MAP_DEFAULT = new TreeMap();
    private TreeMap<Double, RGB> fColorMap;

    static {
        COLOR_MAP_DEFAULT.put(0.5, XYGraphMediaFactory.COLOR_RED);
        COLOR_MAP_DEFAULT.put(0.75, XYGraphMediaFactory.COLOR_ORANGE);
        COLOR_MAP_DEFAULT.put(0.5, XYGraphMediaFactory.COLOR_YELLOW);
        COLOR_MAP_DEFAULT.put(1.0, XYGraphMediaFactory.COLOR_GREEN);
    }

    public DoubleStyleProvider(Map<Double, RGB> colorMap) {
        this.fColorMap = new TreeMap<Double, RGB>(colorMap);
    }

    public DoubleStyleProvider() {
        this.fColorMap = COLOR_MAP_DEFAULT;
    }

    @Override
    public Color getPointColor(ISample sample, Trace trace) {
        if (sample == null || !(sample instanceof IMetaData) || this.fColorMap == null) {
            return trace.getTraceColor();
        }
        Object object = ((IMetaData)((Object)sample)).getData();
        if (object == null || !(object instanceof Double)) {
            return trace.getTraceColor();
        }
        double value = (Double)object;
        for (Map.Entry<Double, RGB> upperLimit : this.fColorMap.entrySet()) {
            if (!(value < upperLimit.getKey())) continue;
            return XYGraphMediaFactory.getInstance().getColor(upperLimit.getValue());
        }
        return XYGraphMediaFactory.getInstance().getColor(this.fColorMap.lastEntry().getValue());
    }
}

