/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.chessmlprofile.Predictability.DeploymentConfiguration.HardwareBaseline;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum BasicDataType implements Enumerator
{
    SIGNED(0, "Signed", "Signed"),
    INTEGER(1, "Integer", "Integer"),
    FIXED_POINT(2, "Fixed_Point", "Fixed_Point"),
    FLOAT(3, "Float", "Float");

    public static final int SIGNED_VALUE = 0;
    public static final int INTEGER_VALUE = 1;
    public static final int FIXED_POINT_VALUE = 2;
    public static final int FLOAT_VALUE = 3;
    private static final BasicDataType[] VALUES_ARRAY;
    public static final List<BasicDataType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new BasicDataType[]{SIGNED, INTEGER, FIXED_POINT, FLOAT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static BasicDataType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BasicDataType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BasicDataType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BasicDataType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BasicDataType get(int value) {
        switch (value) {
            case 0: {
                return SIGNED;
            }
            case 1: {
                return INTEGER;
            }
            case 2: {
                return FIXED_POINT;
            }
            case 3: {
                return FLOAT;
            }
        }
        return null;
    }

    private BasicDataType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

