/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.LazyCharIterable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableCharBag;
import org.eclipse.collections.api.block.function.primitive.CharToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.CharPredicate;
import org.eclipse.collections.api.block.procedure.primitive.CharIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.CharProcedure;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.factory.Sets;
import org.eclipse.collections.api.factory.primitive.CharBags;
import org.eclipse.collections.api.factory.primitive.CharLists;
import org.eclipse.collections.api.iterator.CharIterator;
import org.eclipse.collections.api.list.primitive.MutableCharList;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.api.set.primitive.CharSet;
import org.eclipse.collections.api.set.primitive.ImmutableCharSet;
import org.eclipse.collections.api.set.primitive.MutableCharSet;
import org.eclipse.collections.api.tuple.primitive.CharCharPair;
import org.eclipse.collections.impl.factory.primitive.CharSets;
import org.eclipse.collections.impl.iterator.SingletonCharIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyCharIterableAdapter;
import org.eclipse.collections.impl.set.mutable.primitive.CharHashSet;

final class ImmutableCharSingletonSet
implements ImmutableCharSet,
Serializable {
    private static final long serialVersionUID = 1L;
    private final char element;

    ImmutableCharSingletonSet(char element) {
        this.element = element;
    }

    public ImmutableCharSet newWith(char element) {
        return CharSets.immutable.with(new char[]{this.element, element});
    }

    public ImmutableCharSet newWithout(char element) {
        return this.element == element ? CharSets.immutable.with() : this;
    }

    public ImmutableCharSet newWithAll(CharIterable elements) {
        return CharHashSet.newSet(elements).with(this.element).toImmutable();
    }

    public ImmutableCharSet newWithoutAll(CharIterable elements) {
        return elements.contains(this.element) ? CharSets.immutable.with() : this;
    }

    public int size() {
        return 1;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean notEmpty() {
        return true;
    }

    public boolean contains(char value) {
        return this.element == value;
    }

    public boolean containsAll(CharIterable source) {
        CharIterator iterator = source.charIterator();
        while (iterator.hasNext()) {
            if (this.element == iterator.next()) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(char ... source) {
        for (char value : source) {
            if (this.element == value) continue;
            return false;
        }
        return true;
    }

    public void each(CharProcedure procedure) {
        procedure.value(this.element);
    }

    public ImmutableCharSet select(CharPredicate predicate) {
        return predicate.accept(this.element) ? CharHashSet.newSetWith(this.element).toImmutable() : new CharHashSet().toImmutable();
    }

    public ImmutableCharSet reject(CharPredicate predicate) {
        return predicate.accept(this.element) ? new CharHashSet().toImmutable() : CharHashSet.newSetWith(this.element).toImmutable();
    }

    public <V> ImmutableSet<V> collect(CharToObjectFunction<? extends V> function) {
        return Sets.immutable.with(function.valueOf(this.element));
    }

    public MutableCharList toList() {
        return CharLists.mutable.with(new char[]{this.element});
    }

    public int sizeDistinct() {
        return 1;
    }

    public int occurrencesOf(char item) {
        return this.element == item ? 1 : 0;
    }

    public void forEachWithOccurrences(CharIntProcedure charIntProcedure) {
        charIntProcedure.value(this.element, 1);
    }

    public char detectIfNone(CharPredicate predicate, char ifNone) {
        return predicate.accept(this.element) ? this.element : ifNone;
    }

    public int count(CharPredicate predicate) {
        return predicate.accept(this.element) ? 1 : 0;
    }

    public boolean anySatisfy(CharPredicate predicate) {
        return predicate.accept(this.element);
    }

    public long sum() {
        return this.element;
    }

    public char min() {
        return this.element;
    }

    public char max() {
        return this.element;
    }

    public char maxIfEmpty(char defaultValue) {
        return this.element;
    }

    public char minIfEmpty(char defaultValue) {
        return this.element;
    }

    public double average() {
        return this.element;
    }

    public double median() {
        return this.element;
    }

    public LazyIterable<CharCharPair> cartesianProduct(CharSet set) {
        return CharSets.cartesianProduct((CharSet)this, set);
    }

    public char[] toSortedArray() {
        return new char[]{this.element};
    }

    public MutableCharList toSortedList() {
        return CharLists.mutable.with(new char[]{this.element});
    }

    public boolean noneSatisfy(CharPredicate predicate) {
        return !predicate.accept(this.element);
    }

    public boolean allSatisfy(CharPredicate predicate) {
        return predicate.accept(this.element);
    }

    public <T> T injectInto(T injectedValue, ObjectCharToObjectFunction<? super T, ? extends T> function) {
        return (T)function.valueOf(injectedValue, this.element);
    }

    public RichIterable<CharIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        return Lists.immutable.with((Object)this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CharSet)) {
            return false;
        }
        CharSet set = (CharSet)obj;
        if (set.size() != 1) {
            return false;
        }
        return set.contains(this.element);
    }

    public int hashCode() {
        return this.element;
    }

    public MutableCharSet toSet() {
        return CharSets.mutable.with(new char[]{this.element});
    }

    public MutableCharBag toBag() {
        return CharBags.mutable.with(new char[]{this.element});
    }

    public CharSet freeze() {
        return this;
    }

    public ImmutableCharSet toImmutable() {
        return this;
    }

    public LazyCharIterable asLazy() {
        return new LazyCharIterableAdapter((CharIterable)this);
    }

    public char[] toArray() {
        return new char[]{this.element};
    }

    public char[] toArray(char[] target) {
        if (target.length < 1) {
            target = new char[]{this.element};
        } else {
            target[0] = this.element;
        }
        return target;
    }

    public String toString() {
        return "[" + this.makeString() + "]";
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.element));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public CharIterator charIterator() {
        return new SingletonCharIterator(this.element);
    }
}

