/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring2.rename;

import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.xtext.ide.refactoring.IRenameStrategy2;
import org.eclipse.xtext.ide.refactoring.RefactoringIssueAcceptor;
import org.eclipse.xtext.ide.refactoring.RenameChange;
import org.eclipse.xtext.ide.refactoring.RenameContext;
import org.eclipse.xtext.ide.serializer.IChangeSerializer;
import org.eclipse.xtext.ide.serializer.ITextDocumentChange;
import org.eclipse.xtext.resource.IGlobalServiceProvider;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.refactoring.ILinkedPositionGroupCalculator;
import org.eclipse.xtext.ui.refactoring.impl.CachingResourceSetProvider;
import org.eclipse.xtext.ui.refactoring.impl.ProjectUtil;
import org.eclipse.xtext.ui.refactoring.impl.RefactoringResourceSetProvider;
import org.eclipse.xtext.ui.refactoring.ui.IRenameElementContext;
import org.eclipse.xtext.ui.refactoring2.LtkIssueAcceptor;
import org.eclipse.xtext.ui.refactoring2.rename.ISimpleNameProvider;

public class DefaultLinkedPositionGroupCalculator2
implements ILinkedPositionGroupCalculator {
    private static final Logger LOG = Logger.getLogger(DefaultLinkedPositionGroupCalculator2.class);
    @Inject
    private ProjectUtil projectUtil;
    @Inject
    private RefactoringResourceSetProvider resourceSetProvider;
    @Inject
    private ISimpleNameProvider simpleNameProvider;
    @Inject
    private IGlobalServiceProvider globalServiceProvider;
    @Inject
    private IResourceServiceProvider.Registry resourceServiceProviderRegistry;

    @Override
    public Provider<LinkedPositionGroup> getLinkedPositionGroup(IRenameElementContext renameElementContext, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        XtextEditor editor = (XtextEditor)renameElementContext.getTriggeringEditor();
        IProject project = this.projectUtil.getProject(renameElementContext.getContextResourceURI());
        if (project == null) {
            throw new IllegalStateException("Could not determine the project for context resource " + renameElementContext.getContextResourceURI());
        }
        CachingResourceSetProvider cachingResourceSetProvider = new CachingResourceSetProvider(this.resourceSetProvider);
        ResourceSet resourceSet = cachingResourceSetProvider.get(project);
        EObject targetElement = resourceSet.getEObject(renameElementContext.getTargetElementURI(), true);
        if (targetElement == null) {
            throw new IllegalStateException("Target element could not be loaded");
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        IRenameStrategy2 renameStrategy = (IRenameStrategy2)this.globalServiceProvider.findService(targetElement, IRenameStrategy2.class);
        if (renameStrategy == null) {
            throw new IllegalArgumentException("Cannot find a rename strategy for " + renameElementContext.getTargetElementURI());
        }
        String oldName = this.simpleNameProvider.getSimpleName(targetElement);
        String newName = this.getNewDummyName(oldName);
        IResourceServiceProvider resourceServiceProvider = this.resourceServiceProviderRegistry.getResourceServiceProvider(renameElementContext.getTargetElementURI());
        LtkIssueAcceptor issues = (LtkIssueAcceptor)resourceServiceProvider.get(LtkIssueAcceptor.class);
        IChangeSerializer changeSerializer = (IChangeSerializer)resourceServiceProvider.get(IChangeSerializer.class);
        changeSerializer.setUpdateRelatedFiles(false);
        RenameChange change = new RenameChange(newName, renameElementContext.getTargetElementURI());
        RenameContext renameContext = new RenameContext((List)Lists.newArrayList((Object[])new RenameChange[]{change}), resourceSet, changeSerializer, (RefactoringIssueAcceptor)issues);
        renameStrategy.applyRename(renameContext);
        ArrayList replaceEdits = new ArrayList();
        changeSerializer.applyModifications(c -> {
            if (c instanceof ITextDocumentChange) {
                ITextDocumentChange textDocumentChange = (ITextDocumentChange)c;
                textDocumentChange.getReplacements().forEach(replacement -> replaceEdits.add(new ReplaceEdit(replacement.getOffset(), replacement.getLength(), replacement.getReplacementText())));
            }
        });
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        return () -> this.createLinkedGroupFromReplaceEdits(replaceEdits, editor, oldName, progress.newChild(10));
    }

    protected String getNewDummyName(String oldName) {
        return String.valueOf(oldName) + oldName;
    }

    protected LinkedPositionGroup createLinkedGroupFromReplaceEdits(List<ReplaceEdit> edits, XtextEditor xtextEditor, String originalName, SubMonitor progress) {
        if (edits == null) {
            return null;
        }
        IXtextDocument document = xtextEditor.getDocument();
        LinkedPositionGroup group = new LinkedPositionGroup();
        ArrayList<LinkedPosition> linkedPositions = new ArrayList<LinkedPosition>();
        edits.forEach(replaceEdit -> {
            try {
                String textToReplace = document.get(replaceEdit.getOffset(), replaceEdit.getLength());
                int indexOf = textToReplace.indexOf(originalName);
                if (indexOf != -1) {
                    int calculatedOffset = replaceEdit.getOffset() + indexOf;
                    linkedPositions.add(new LinkedPosition((IDocument)document, calculatedOffset, originalName.length()));
                }
            }
            catch (BadLocationException exc) {
                LOG.error((Object)("Skipping invalid text edit " + replaceEdit), (Throwable)exc);
            }
        });
        progress.worked(10);
        int invocationOffset = xtextEditor.getInternalSourceViewer().getSelectedRange().x;
        int i = 0;
        for (LinkedPosition position : this.sortPositions(linkedPositions, invocationOffset)) {
            try {
                position.setSequenceNumber(i);
                ++i;
                group.addPosition(position);
            }
            catch (BadLocationException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                return null;
            }
        }
        return group;
    }

    protected Iterable<LinkedPosition> sortPositions(Iterable<LinkedPosition> linkedPositions, final int invocationOffset) {
        Comparator<LinkedPosition> comparator = new Comparator<LinkedPosition>(){

            @Override
            public int compare(LinkedPosition left, LinkedPosition right) {
                return this.rank(left) - this.rank(right);
            }

            private int rank(LinkedPosition o1) {
                int relativeRank = o1.offset + o1.length - invocationOffset;
                if (relativeRank < 0) {
                    return Integer.MAX_VALUE + relativeRank;
                }
                return relativeRank;
            }
        };
        return ImmutableSortedSet.copyOf((Comparator)comparator, linkedPositions);
    }
}

