/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench;

import java.util.Comparator;
import org.eclipse.e4.ui.internal.workbench.ModelFragmentWrapper;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.fragment.MStringModelFragment;
import org.eclipse.e4.ui.model.internal.ModelUtils;
import org.eclipse.e4.ui.model.internal.PositionInfo;

public class ModelFragmentComparator
implements Comparator<ModelFragmentWrapper> {
    private final MApplication application;

    public ModelFragmentComparator(MApplication application) {
        this.application = application;
    }

    @Override
    public int compare(ModelFragmentWrapper o1, ModelFragmentWrapper o2) {
        if (o1 == o2) {
            return 0;
        }
        PositionDescription posInfo1 = this.getPositionDescription(o1);
        PositionDescription posInfo2 = this.getPositionDescription(o2);
        switch (posInfo1.getPlace()) {
            case NONE: {
                switch (posInfo2.getPlace()) {
                    case NONE: 
                    case INDEX: {
                        return 1;
                    }
                }
                return -1;
            }
            case ABSOLUTE: {
                switch (posInfo2.getPlace()) {
                    case RELATIVE: {
                        return -1;
                    }
                }
                return 1;
            }
            case INDEX: {
                switch (posInfo2.getPlace()) {
                    case INDEX: {
                        int result = posInfo1.getPositionReferenceAsInteger() - posInfo2.getPositionReferenceAsInteger();
                        if (result == 0) {
                            return 1;
                        }
                        return result;
                    }
                }
                return -1;
            }
            case RELATIVE: {
                switch (posInfo2.getPlace()) {
                    case RELATIVE: {
                        boolean hasElement = false;
                        for (MApplicationElement element : o2.getModelFragment().getElements()) {
                            if (hasElement |= ModelUtils.findElementById((MApplicationElement)element, (String)posInfo1.getReference()) != null) break;
                        }
                        if (hasElement) {
                            return 1;
                        }
                        hasElement = false;
                        for (MApplicationElement element : o1.getModelFragment().getElements()) {
                            if (hasElement |= ModelUtils.findElementById((MApplicationElement)element, (String)posInfo2.getReference()) != null) break;
                        }
                        if (hasElement) {
                            return -1;
                        }
                        boolean bl = hasElement = ModelUtils.findElementById((MApplicationElement)this.application, (String)posInfo1.getReference()) != null;
                        if (hasElement) {
                            return -1;
                        }
                        return 1;
                    }
                }
                return 1;
            }
        }
        return 1;
    }

    private PositionDescription getPositionDescription(ModelFragmentWrapper wrapper) {
        if (!MStringModelFragment.class.isInstance(wrapper.getModelFragment())) {
            return new PositionDescription(PositionPlace.NONE, null);
        }
        MStringModelFragment stringFragment = (MStringModelFragment)wrapper.getModelFragment();
        if (stringFragment.getPositionInList() == null) {
            return new PositionDescription(PositionPlace.NONE, null);
        }
        String posInList = stringFragment.getPositionInList().trim();
        PositionInfo posInfo = PositionInfo.parse((String)posInList);
        if (posInfo == null) {
            return new PositionDescription(PositionPlace.NONE, null);
        }
        switch (posInfo.getPosition()) {
            case BEFORE: 
            case AFTER: {
                return new PositionDescription(PositionPlace.RELATIVE, posInfo.getPositionReference());
            }
            case LAST: 
            case FIRST: {
                return new PositionDescription(PositionPlace.ABSOLUTE, posInfo.getPositionReference());
            }
            case INDEX: {
                return new PositionDescription(PositionPlace.INDEX, posInfo.getPositionReference());
            }
        }
        return new PositionDescription(PositionPlace.NONE, null);
    }

    private static class PositionDescription {
        private final PositionPlace place;
        private final String reference;

        PositionDescription(PositionPlace place, String reference) {
            this.place = place;
            this.reference = reference;
        }

        public PositionPlace getPlace() {
            return this.place;
        }

        public String getReference() {
            return this.reference;
        }

        public int getPositionReferenceAsInteger() {
            return Integer.parseInt(this.reference);
        }
    }

    private static enum PositionPlace {
        NONE,
        ABSOLUTE,
        INDEX,
        RELATIVE;

    }
}

