/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.internal.SshPreferencesMirror;
import org.eclipse.egit.core.securestorage.EGitSecureStore;
import org.eclipse.egit.core.securestorage.UserPasswordCredentials;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.sshd.IdentityPasswordProvider;
import org.eclipse.jgit.transport.sshd.KeyPasswordProvider;
import org.eclipse.jgit.transport.sshd.ProxyData;
import org.eclipse.jgit.transport.sshd.ProxyDataFactory;
import org.eclipse.jgit.transport.sshd.SshdSessionFactory;
import org.eclipse.jgit.util.StringUtils;
import org.osgi.service.prefs.BackingStoreException;

public class EGitSshdSessionFactory
extends SshdSessionFactory {
    public EGitSshdSessionFactory(IProxyService service) {
        super(null, (ProxyDataFactory)new EGitProxyDataFactory(service));
        SshPreferencesMirror.INSTANCE.start();
    }

    public void close() {
        SshPreferencesMirror.INSTANCE.stop();
        super.close();
    }

    public File getSshDirectory() {
        File file = super.getSshDirectory();
        if (file != null) {
            return file;
        }
        return SshPreferencesMirror.INSTANCE.getSshDirectory();
    }

    @NonNull
    protected List<Path> getDefaultIdentities(@NonNull File sshDir) {
        List<Path> defaultKeys = SshPreferencesMirror.INSTANCE.getDefaultIdentities(sshDir);
        if (defaultKeys == null || defaultKeys.isEmpty()) {
            return super.getDefaultIdentities(sshDir);
        }
        return defaultKeys;
    }

    protected String getDefaultPreferredAuthentications() {
        return SshPreferencesMirror.INSTANCE.getPreferredAuthentications();
    }

    protected KeyPasswordProvider createKeyPasswordProvider(CredentialsProvider provider) {
        return new EGitFilePasswordProvider(provider, EGitSecureStore.getInstance());
    }

    private static class EGitFilePasswordProvider
    extends IdentityPasswordProvider {
        private final EGitSecureStore store;
        private boolean useSecureStore;

        public EGitFilePasswordProvider(CredentialsProvider provider, EGitSecureStore store) {
            super(provider);
            this.store = store;
        }

        protected char[] getPassword(URIish uri, int attempt, @NonNull IdentityPasswordProvider.State state) throws IOException {
            if (attempt == 0) {
                this.useSecureStore = Platform.getPreferencesService().getBoolean("org.eclipse.egit.core", "core_save_credentials_in_secure_store", true, null);
                if (this.useSecureStore) {
                    try {
                        String password;
                        UserPasswordCredentials credentials = this.store.getCredentials(uri);
                        if (credentials != null && (password = credentials.getPassword()) != null) {
                            char[] pass = password.toCharArray();
                            state.setPassword(pass);
                            return pass;
                        }
                    }
                    catch (StorageException e) {
                        if (e.getErrorCode() == 4) {
                            this.useSecureStore = false;
                            this.savePrefs();
                        } else {
                            Activator.logError(e.getMessage(), e);
                        }
                    }
                    catch (RuntimeException e) {
                        Activator.logError(e.getMessage(), e);
                    }
                }
            }
            return super.getPassword(uri, attempt, state);
        }

        protected char[] getPassword(URIish uri, String message) {
            if (this.store == null) {
                return super.getPassword(uri, message);
            }
            CredentialsProvider provider = this.getCredentialsProvider();
            if (provider == null) {
                return null;
            }
            boolean haveMessage = !StringUtils.isEmptyOrNull((String)message);
            ArrayList<Object> items = new ArrayList<Object>(haveMessage ? 3 : 2);
            if (haveMessage) {
                items.add(new CredentialItem.InformationalMessage(message));
            }
            CredentialItem.Password password = new CredentialItem.Password(CoreText.EGitSshdSessionFactory_sshKeyEncryptedPrompt);
            items.add(password);
            CredentialItem.YesNoType storeValue = new CredentialItem.YesNoType(CoreText.EGitSshdSessionFactory_sshKeyPassphraseStorePrompt);
            storeValue.setValue(this.useSecureStore);
            items.add(storeValue);
            try {
                char[] pass;
                boolean shouldStore;
                if (!provider.get(uri, items)) {
                    this.cancelAuthentication();
                }
                if (this.useSecureStore != (shouldStore = storeValue.getValue())) {
                    this.useSecureStore = shouldStore;
                    this.savePrefs();
                }
                char[] cArray = (pass = password.getValue()) == null ? null : (char[])pass.clone();
                return cArray;
            }
            finally {
                password.clear();
            }
        }

        protected boolean keyLoaded(URIish uri, IdentityPasswordProvider.State state, char[] password, Exception err) throws IOException, GeneralSecurityException {
            if (state != null && password != null) {
                if (state.getCount() == 0) {
                    if (err != null) {
                        try {
                            this.store.clearCredentials(uri);
                        }
                        catch (IOException | RuntimeException e) {
                            Activator.logError(e.getMessage(), e);
                        }
                        return true;
                    }
                } else if (err == null && this.useSecureStore) {
                    UserPasswordCredentials credentials = new UserPasswordCredentials("egit:ssh:resource", new String(password));
                    try {
                        this.store.putCredentials(uri, credentials);
                    }
                    catch (StorageException e) {
                        if (e.getErrorCode() == 4) {
                            this.useSecureStore = false;
                            this.savePrefs();
                        } else {
                            Activator.logError(e.getMessage(), e);
                        }
                    }
                    catch (RuntimeException e) {
                        Activator.logError(e.getMessage(), e);
                    }
                }
            }
            return super.keyLoaded(uri, state, password, err);
        }

        private void savePrefs() {
            IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.egit.core");
            prefs.putBoolean("core_save_credentials_in_secure_store", this.useSecureStore);
            try {
                prefs.flush();
            }
            catch (BackingStoreException e) {
                Activator.logError(CoreText.EGitSshdSessionFactory_savingPreferencesFailed, e);
            }
        }
    }

    private static class EGitProxyDataFactory
    implements ProxyDataFactory {
        private final IProxyService proxyService;

        public EGitProxyDataFactory(IProxyService service) {
            this.proxyService = service;
        }

        public ProxyData get(InetSocketAddress remoteAddress) {
            IProxyData[] data;
            block3: {
                try {
                    data = this.proxyService.select(new URI("SOCKS", "//" + remoteAddress.getHostString(), null));
                    if (data != null && data.length != 0 || (data = this.proxyService.select(new URI("HTTP", "//" + remoteAddress.getHostString(), null))) != null && data.length != 0) break block3;
                    return null;
                }
                catch (URISyntaxException e) {
                    return null;
                }
            }
            return this.newData(data[0]);
        }

        private ProxyData newData(IProxyData data) {
            if (data == null) {
                return null;
            }
            InetSocketAddress proxyAddress = new InetSocketAddress(data.getHost(), data.getPort());
            char[] password = null;
            try {
                password = data.getPassword() == null ? null : data.getPassword().toCharArray();
                switch (data.getType()) {
                    case "HTTP": {
                        Proxy proxy = new Proxy(Proxy.Type.HTTP, proxyAddress);
                        ProxyData proxyData = new ProxyData(proxy, data.getUserId(), password);
                        return proxyData;
                    }
                    case "SOCKS": {
                        Proxy proxy = new Proxy(Proxy.Type.SOCKS, proxyAddress);
                        ProxyData proxyData = new ProxyData(proxy, data.getUserId(), password);
                        return proxyData;
                    }
                }
                return null;
            }
            finally {
                if (password != null) {
                    Arrays.fill(password, '\u0000');
                }
            }
        }
    }
}

