/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e;

import java.io.File;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.server.StreamConnectionProvider;
import org.eclipse.lsp4j.jsonrpc.messages.Message;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class LoggingStreamConnectionProviderProxy
implements StreamConnectionProvider {
    private static final String FILE_KEY = "file.logging.enabled";
    private static final String STDERR_KEY = "stderr.logging.enabled";
    private StreamConnectionProvider provider;
    private InputStream inputStream;
    private OutputStream outputStream;
    private InputStream errorStream;
    private String id;
    private final File logFile;
    private boolean logToFile;
    private boolean logToConsole;
    private MessageConsoleStream consoleStream;

    public static File getLogDirectory() {
        IPath root = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        if (root == null) {
            return null;
        }
        File logFolder = new File(root.addTrailingSeparator().toPortableString(), "languageServers-log");
        if (!logFolder.exists() && !logFolder.mkdirs() || !logFolder.isDirectory() || !logFolder.canWrite()) {
            return null;
        }
        return logFolder;
    }

    public static String lsToFileLoggingId(String serverId) {
        return String.valueOf(serverId) + "." + FILE_KEY;
    }

    public static String lsToConsoleLoggingId(String serverId) {
        return String.valueOf(serverId) + "." + STDERR_KEY;
    }

    public static boolean shouldLog(String serverId) {
        IPreferenceStore store = LanguageServerPlugin.getDefault().getPreferenceStore();
        return store.getBoolean(LoggingStreamConnectionProviderProxy.lsToFileLoggingId(serverId)) || store.getBoolean(LoggingStreamConnectionProviderProxy.lsToConsoleLoggingId(serverId));
    }

    public LoggingStreamConnectionProviderProxy(StreamConnectionProvider provider, String serverId) {
        this.id = serverId;
        this.provider = provider;
        IPreferenceStore store = LanguageServerPlugin.getDefault().getPreferenceStore();
        this.logToFile = store.getBoolean(LoggingStreamConnectionProviderProxy.lsToFileLoggingId(serverId));
        this.logToConsole = store.getBoolean(LoggingStreamConnectionProviderProxy.lsToConsoleLoggingId(serverId));
        store.addPropertyChangeListener(event -> {
            if (event.getProperty().equals(FILE_KEY)) {
                this.logToFile = (Boolean)event.getNewValue();
            } else if (event.getProperty().equals(STDERR_KEY)) {
                this.logToConsole = (Boolean)event.getNewValue();
            }
        });
        this.logFile = this.getLogFile();
    }

    @Override
    public InputStream getInputStream() {
        if (this.inputStream != null) {
            return this.inputStream;
        }
        if (this.provider.getInputStream() != null) {
            this.inputStream = new FilterInputStream(this.provider.getInputStream()){

                @Override
                public int read(byte[] b, int off, int len) throws IOException {
                    int bytes = super.read(b, off, len);
                    byte[] payload = new byte[bytes];
                    System.arraycopy(b, off, payload, 0, bytes);
                    if (LoggingStreamConnectionProviderProxy.this.logToConsole || LoggingStreamConnectionProviderProxy.this.logToFile) {
                        String s = "\n[t=" + System.currentTimeMillis() + "] " + LoggingStreamConnectionProviderProxy.this.id + " to LSP4E:\n" + new String(payload);
                        if (LoggingStreamConnectionProviderProxy.this.logToConsole) {
                            LoggingStreamConnectionProviderProxy.this.logToConsole(s);
                        }
                        if (LoggingStreamConnectionProviderProxy.this.logToFile) {
                            LoggingStreamConnectionProviderProxy.this.logToFile(s);
                        }
                    }
                    return bytes;
                }
            };
        }
        return this.inputStream;
    }

    @Override
    public InputStream getErrorStream() {
        if (this.errorStream != null) {
            return this.errorStream;
        }
        if (this.provider.getErrorStream() != null) {
            this.errorStream = new FilterInputStream(this.provider.getErrorStream()){

                @Override
                public int read(byte[] b, int off, int len) throws IOException {
                    int bytes = super.read(b, off, len);
                    byte[] payload = new byte[bytes];
                    System.arraycopy(b, off, payload, 0, bytes);
                    if (LoggingStreamConnectionProviderProxy.this.logToConsole || LoggingStreamConnectionProviderProxy.this.logToFile) {
                        String s = "\n[t=" + System.currentTimeMillis() + "] Error from " + LoggingStreamConnectionProviderProxy.this.id + ":\n" + new String(payload);
                        if (LoggingStreamConnectionProviderProxy.this.logToConsole) {
                            LoggingStreamConnectionProviderProxy.this.logToConsole(s);
                        }
                        if (LoggingStreamConnectionProviderProxy.this.logToFile) {
                            LoggingStreamConnectionProviderProxy.this.logToFile(s);
                        }
                    }
                    return bytes;
                }
            };
        }
        return this.errorStream;
    }

    @Override
    public OutputStream getOutputStream() {
        if (this.outputStream != null) {
            return this.outputStream;
        }
        if (this.provider.getOutputStream() != null) {
            this.outputStream = new FilterOutputStream(this.provider.getOutputStream()){

                @Override
                public void write(byte[] b) throws IOException {
                    if (LoggingStreamConnectionProviderProxy.this.logToConsole || LoggingStreamConnectionProviderProxy.this.logToFile) {
                        String s = "\n[t=" + System.currentTimeMillis() + "] LSP4E to " + LoggingStreamConnectionProviderProxy.this.id + ":\n" + new String(b);
                        if (LoggingStreamConnectionProviderProxy.this.logToConsole) {
                            LoggingStreamConnectionProviderProxy.this.logToConsole(s);
                        }
                        if (LoggingStreamConnectionProviderProxy.this.logToFile) {
                            LoggingStreamConnectionProviderProxy.this.logToFile(s);
                        }
                    }
                    super.write(b);
                }
            };
        }
        return this.outputStream;
    }

    @Override
    public void start() throws IOException {
        this.provider.start();
    }

    @Override
    public InputStream forwardCopyTo(InputStream input, OutputStream output) {
        return this.provider.forwardCopyTo(input, output);
    }

    @Override
    public Object getInitializationOptions(URI rootUri) {
        return this.provider.getInitializationOptions(rootUri);
    }

    @Override
    public String getTrace(URI rootUri) {
        return this.provider.getTrace(rootUri);
    }

    @Override
    public void handleMessage(Message message, LanguageServer languageServer, URI rootURI) {
        this.provider.handleMessage(message, languageServer, rootURI);
    }

    @Override
    public void stop() {
        this.provider.stop();
        try {
            if (this.outputStream != null) {
                this.outputStream.close();
                this.outputStream = null;
            }
            if (this.inputStream != null) {
                this.inputStream.close();
                this.inputStream = null;
            }
            if (this.errorStream != null) {
                this.errorStream.close();
                this.errorStream = null;
            }
        }
        catch (IOException e) {
            LanguageServerPlugin.logError(e);
        }
    }

    private void logToConsole(String string) {
        if (this.consoleStream == null || this.consoleStream.isClosed()) {
            this.consoleStream = this.findConsole().newMessageStream();
        }
        this.consoleStream.println(string);
    }

    private MessageConsole findConsole() {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager conMan = plugin.getConsoleManager();
        IConsole[] existing = conMan.getConsoles();
        int i = 0;
        while (i < existing.length) {
            if ("org.eclipse.lsp4e".equals(existing[i].getName())) {
                return (MessageConsole)existing[i];
            }
            ++i;
        }
        MessageConsole myConsole = new MessageConsole("org.eclipse.lsp4e", null);
        conMan.addConsoles(new IConsole[]{myConsole});
        return myConsole;
    }

    private void logToFile(String string) {
        if (this.logFile == null) {
            return;
        }
        if (!this.logFile.exists()) {
            try {
                if (!this.logFile.createNewFile()) {
                    throw new IOException(String.format("Failed to create file %s", this.logFile.toString()));
                }
            }
            catch (IOException e) {
                LanguageServerPlugin.logError(e);
            }
        }
        try {
            Files.write(this.logFile.toPath(), string.getBytes(), StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            LanguageServerPlugin.logError(e);
        }
    }

    private File getLogFile() {
        if (this.logFile != null) {
            return this.logFile;
        }
        File logFolder = LoggingStreamConnectionProviderProxy.getLogDirectory();
        if (logFolder == null) {
            return null;
        }
        File file = new File(logFolder, String.valueOf(this.id) + ".log");
        if (!(!file.exists() || file.isFile() && file.canWrite())) {
            return null;
        }
        return file;
    }
}

