/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.core.transport.httpclient.win32;

import java.util.Map;
import org.apache.http.auth.AuthSchemeProvider;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.impl.auth.BasicSchemeFactory;
import org.apache.http.impl.auth.DigestSchemeFactory;
import org.apache.http.impl.auth.KerberosSchemeFactory;
import org.apache.http.impl.auth.win.WindowsCredentialsProvider;
import org.apache.http.impl.auth.win.WindowsNTLMSchemeFactory;
import org.apache.http.impl.auth.win.WindowsNegotiateSchemeFactory;
import org.apache.http.impl.client.HttpClientBuilder;
import org.eclipse.epp.internal.mpc.core.transport.httpclient.HttpClientCustomizer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class WinClientBuilderCustomizer
implements HttpClientCustomizer {
    public static final String ID = "org.eclipse.epp.mpc.core.transport.http.win32";
    public static final String SERVICE_PRINCIPAL_NAME_ATTRIBUTE = "servicePrincipal";
    public static final String SERVICE_PRINCIPAL_NAME_PROPERTY = "org.eclipse.epp.mpc.core.transport.http.win32.servicePrincipal";
    private static Boolean winAuthAvailable;
    private String servicePrincipalName;

    public static boolean isWinAuthAvailable() {
        if (winAuthAvailable == null) {
            try {
                winAuthAvailable = true;
            }
            catch (Exception ignore) {
                winAuthAvailable = false;
            }
        }
        return winAuthAvailable;
    }

    public void setServicePrincipalName(String servicePrincipalName) {
        this.servicePrincipalName = servicePrincipalName;
    }

    public String getServicePrincipalName() {
        return this.servicePrincipalName;
    }

    public HttpClientBuilder customizeBuilder(HttpClientBuilder builder) {
        if (!WinClientBuilderCustomizer.isWinAuthAvailable()) {
            return builder;
        }
        HttpClientBuilder winBuilder = builder == null ? HttpClientBuilder.create() : builder;
        Registry<AuthSchemeProvider> authSchemeRegistry = this.createAuthSchemeRegistry();
        return winBuilder.setDefaultAuthSchemeRegistry(authSchemeRegistry);
    }

    private Registry<AuthSchemeProvider> createAuthSchemeRegistry() {
        Registry authSchemeRegistry = RegistryBuilder.create().register("Basic", (Object)new BasicSchemeFactory()).register("Digest", (Object)new DigestSchemeFactory()).register("NTLM", (Object)new WindowsNTLMSchemeFactory(this.servicePrincipalName)).register("Negotiate", (Object)new WindowsNegotiateSchemeFactory(this.servicePrincipalName)).register("Kerberos", (Object)new KerberosSchemeFactory()).build();
        return authSchemeRegistry;
    }

    public CredentialsProvider customizeCredentialsProvider(CredentialsProvider credentialsProvider) {
        if (credentialsProvider == null || !WinClientBuilderCustomizer.isWinAuthAvailable()) {
            return credentialsProvider;
        }
        WindowsCredentialsProvider winCredentialsProvider = new WindowsCredentialsProvider(credentialsProvider);
        return winCredentialsProvider;
    }

    public synchronized void activate(BundleContext context, Map<?, ?> properties) {
        this.servicePrincipalName = this.getServicePrincipalName(properties);
    }

    private String getServicePrincipalName(Map<?, ?> properties) {
        Object servicePrincipalValue = properties.get(SERVICE_PRINCIPAL_NAME_ATTRIBUTE);
        if (servicePrincipalValue != null) {
            return servicePrincipalValue.toString();
        }
        Bundle bundle = FrameworkUtil.getBundle(this.getClass());
        if (bundle != null) {
            return bundle.getBundleContext().getProperty(SERVICE_PRINCIPAL_NAME_PROPERTY);
        }
        return System.getProperty(SERVICE_PRINCIPAL_NAME_PROPERTY);
    }
}

