/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corrosion.test;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.corrosion.CorrosionPlugin;
import org.eclipse.corrosion.Messages;
import org.eclipse.corrosion.RustManager;
import org.eclipse.corrosion.cargo.core.CargoTools;
import org.eclipse.corrosion.launch.RustLaunchDelegateTools;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.unittest.ui.ConfigureViewerSupport;

public class CargoTestDelegate
extends LaunchConfigurationDelegate
implements ILaunchShortcut {
    public static final String CARGO_TEST_LAUNCH_CONFIG_TYPE_ID = "org.eclipse.corrosion.test.CargoTestDelegate";
    public static final String TEST_NAME_ATTRIBUTE = "TEST_NAME";
    public static final String CARGO_UNITTEST_VIEW_SUPPORT_ID = "org.eclipse.corrosion.unitTestSupport";

    public ILaunch getLaunch(ILaunchConfiguration configuration, String mode) throws CoreException {
        CorrosionPlugin.activateUnitTestCoreBundle();
        CargoTestDelegate.updatedLaunchConfiguration(configuration);
        return super.getLaunch(configuration, mode);
    }

    public void launch(ISelection selection, String mode) {
        try {
            ILaunchConfiguration launchConfig = CargoTestDelegate.getLaunchConfiguration(RustLaunchDelegateTools.firstResourceFromSelection(selection));
            RustLaunchDelegateTools.launch(launchConfig, mode);
        }
        catch (CoreException e) {
            CorrosionPlugin.logError(e);
        }
    }

    public void launch(IEditorPart editor, String mode) {
        try {
            ILaunchConfiguration launchConfig = CargoTestDelegate.getLaunchConfiguration(RustLaunchDelegateTools.resourceFromEditor(editor));
            RustLaunchDelegateTools.launch(launchConfig, mode);
        }
        catch (CoreException e) {
            CorrosionPlugin.logError(e);
        }
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IFile cargoManifest;
        CargoTestDelegate.updatedLaunchConfiguration(configuration);
        String projectName = configuration.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "");
        String options = configuration.getAttribute("OPTIONS", "").trim();
        String testName = configuration.getAttribute(TEST_NAME_ATTRIBUTE, "");
        String arguments = configuration.getAttribute("ARGUMENTS", "").trim();
        String workingDirectoryString = RustLaunchDelegateTools.performVariableSubstitution(configuration.getAttribute("org.eclipse.debug.core.ATTR_WORKING_DIRECTORY", "").trim());
        File workingDirectory = RustLaunchDelegateTools.convertToAbsolutePath(workingDirectoryString);
        ILaunchConfigurationWorkingCopy wc = configuration.isWorkingCopy() ? (ILaunchConfigurationWorkingCopy)configuration : configuration.getWorkingCopy();
        IProject project = null;
        if (!projectName.isEmpty()) {
            project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        }
        if (project == null || !project.exists()) {
            RustLaunchDelegateTools.openError(Messages.CargoRunDelegate_unableToLaunch, Messages.CargoRunDelegate_unableToFindProject);
            return;
        }
        if (workingDirectoryString.isEmpty() || !workingDirectory.exists() || !workingDirectory.isDirectory()) {
            wc.setAttribute("org.eclipse.debug.core.ATTR_WORKING_DIRECTORY", project.getLocation().toString());
        }
        if (!(cargoManifest = project.getFile("Cargo.toml")).exists()) {
            RustLaunchDelegateTools.openError(Messages.CargoRunDelegate_unableToLaunch, Messages.CargoRunDelegate_unableToFindToml);
            return;
        }
        ArrayList<String> cargoTestCommand = new ArrayList<String>();
        cargoTestCommand.add(CargoTools.getCargoCommand());
        cargoTestCommand.add("test");
        if (!options.isEmpty()) {
            cargoTestCommand.addAll(Arrays.asList(RustLaunchDelegateTools.performVariableSubstitution(options).split("\\s+")));
        }
        String cargoPathString = cargoManifest.getLocation().toPortableString();
        cargoTestCommand.add("--manifest-path");
        cargoTestCommand.add(cargoPathString);
        if (testName != null && !testName.isEmpty()) {
            cargoTestCommand.add(testName);
        }
        if (!arguments.isEmpty()) {
            cargoTestCommand.add("--");
            cargoTestCommand.addAll(Arrays.asList(RustLaunchDelegateTools.performVariableSubstitution(arguments).split("\\s+")));
        }
        ArrayList<String> finalTestCommand = cargoTestCommand;
        File finalWorkingDirectory = workingDirectory;
        String[] envArgs = DebugPlugin.getDefault().getLaunchManager().getEnvironment(configuration);
        if (envArgs == null) {
            envArgs = new String[]{};
        }
        String[] env = envArgs;
        CompletableFuture.runAsync(() -> {
            try {
                CharSequence[] cmdLine = finalTestCommand.toArray(new String[finalTestCommand.size()]);
                Process p = DebugPlugin.exec((String[])cmdLine, (File)finalWorkingDirectory, (String[])env);
                IProcess process = DebugPlugin.newProcess((ILaunch)launch, (Process)p, (String)"cargo test");
                if ("debug".equals(mode)) {
                    ProcessHandle cargoHandle = p.toHandle();
                    HashSet captured = new HashSet();
                    Job pollChildren = Job.createSystem((String)"Capture children processes", progressMonitor -> {
                        while (!process.isTerminated() && !monitor.isCanceled()) {
                            try {
                                Thread.sleep(50L);
                            }
                            catch (InterruptedException e) {
                                CorrosionPlugin.logError(e);
                                Thread.currentThread().interrupt();
                            }
                            cargoHandle.descendants().filter(Predicate.not(captured::contains)).filter(handle -> handle.info().commandLine().map(line -> line.contains("target/debug")).orElse(Boolean.FALSE)).map(handle -> {
                                captured.add(handle);
                                return CargoTestDelegate.debug(handle, configuration);
                            }).filter(Objects::nonNull).forEach(config -> {
                                try {
                                    config.launch("debug", (IProgressMonitor)new NullProgressMonitor());
                                }
                                catch (CoreException e) {
                                    CorrosionPlugin.logError(e);
                                }
                            });
                        }
                    });
                    pollChildren.schedule();
                    cargoHandle.onExit().thenAccept(h -> {
                        boolean bl = pollChildren.cancel();
                    });
                }
                process.setAttribute(IProcess.ATTR_CMDLINE, String.join((CharSequence)" ", cmdLine));
            }
            catch (CoreException e) {
                e.printStackTrace();
                RustLaunchDelegateTools.openError(Messages.CargoRunDelegate_unableToLaunch, e.getLocalizedMessage());
            }
        });
        if (wc != null) {
            wc.doSave();
        }
    }

    private static void updatedLaunchConfiguration(ILaunchConfiguration config) throws CoreException {
        ILaunchConfigurationWorkingCopy configWC = config.getWorkingCopy();
        new ConfigureViewerSupport(CARGO_UNITTEST_VIEW_SUPPORT_ID).apply(configWC);
        if (configWC.getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, null) == null) {
            configWC.setAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, Collections.emptyMap());
        }
        configWC.doSave();
    }

    private static ILaunchConfiguration debug(ProcessHandle process, ILaunchConfiguration initialLaunchConfiguration) {
        ILaunchConfigurationWorkingCopy configWC;
        try {
            ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
            configWC = launchManager.getLaunchConfigurationType("org.eclipse.cdt.launch.attachLaunchType").newInstance(null, process.info().commandLine().map(line -> line.split(File.separator)).map(segments -> segments[((String[])segments).length - 1]).map(arg_0 -> ((ILaunchManager)launchManager).generateLaunchConfigurationName(arg_0)).orElse("unset"));
            configWC.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", initialLaunchConfiguration.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", null));
        }
        catch (CoreException e) {
            CorrosionPlugin.logError(e);
            return null;
        }
        configWC.setAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "attach");
        configWC.setAttribute("defaultNonStop", true);
        configWC.setAttribute("org.eclipse.cdt.launch.ATTACH_PROCESS_ID", (int)process.pid());
        configWC.setAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN", false);
        configWC.setAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME", RustManager.getDefaultDebugger());
        configWC.setAttribute("org.eclipse.debug.core.ATTR_ENVIRONMENT", Collections.emptyMap());
        return configWC;
    }

    private static ILaunchConfiguration getLaunchConfiguration(IResource resource) throws CoreException {
        ILaunchConfigurationWorkingCopy launchConfiguration = RustLaunchDelegateTools.getLaunchConfiguration(resource, CARGO_TEST_LAUNCH_CONFIG_TYPE_ID).getWorkingCopy();
        if (launchConfiguration instanceof ILaunchConfigurationWorkingCopy) {
            ILaunchConfigurationWorkingCopy wc = launchConfiguration;
            wc.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", resource.getProject().getName());
            new ConfigureViewerSupport(CARGO_UNITTEST_VIEW_SUPPORT_ID).apply(wc);
        }
        return launchConfiguration;
    }
}

