/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.template.ui.common;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.graphics.Image;

public class TemplateType {
    private static final String DOT = ".";
    private String text;
    private String location;
    private Image image;
    private Set<String> validParameters = new HashSet<String>();
    private static final ResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());

    public static TemplateType createTemplateType(String type, String location, String imageLocation, Class<?> loader, String ... parameters) throws MalformedURLException {
        Image image = TemplateType.createImage(loader.getResource(imageLocation));
        TemplateType templateType = new TemplateType(type, location, image);
        int i = 0;
        while (i < parameters.length) {
            templateType.getValidParameters().add(parameters[i]);
            ++i;
        }
        return templateType;
    }

    private TemplateType(String text, String location, Image image) {
        this.text = text;
        this.location = location;
        this.image = image;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getLocation() {
        return this.location;
    }

    public String getExtension() {
        int dotIndex = this.location.lastIndexOf(DOT);
        if (dotIndex != -1) {
            return this.location.substring(dotIndex + 1);
        }
        return null;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    private static Image createImage(URL imageURL) {
        ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)imageURL);
        return resourceManager.createImage(imageDescriptor);
    }

    public Set<String> getValidParameters() {
        return this.validParameters;
    }
}

