/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.db.dao;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.GregorianCalendar;
import org.eclipse.dirigible.repository.api.RepositoryPath;
import org.eclipse.dirigible.repository.db.DBBaseException;
import org.eclipse.dirigible.repository.db.dao.DBFile;
import org.eclipse.dirigible.repository.db.dao.DBFolder;
import org.eclipse.dirigible.repository.db.dao.DBMapper;
import org.eclipse.dirigible.repository.db.dao.DBObject;
import org.eclipse.dirigible.repository.db.dao.DBObjectDAO;
import org.eclipse.dirigible.repository.db.dao.DBRepositoryDAO;
import org.eclipse.dirigible.repository.db.dao.Messages;
import org.eclipse.dirigible.repository.logging.Logger;

public class DBFileDAO
extends DBObjectDAO {
    private static final String MAX_SIZE_OF_BINARY_RESOURCE_IS = Messages.getString("DBFileDAO.MAX_SIZE_OF_BINARY_RESOURCE_IS");
    private static final String SINGLE_RESOURCES_BIGGER_THAN_4K_NOT_SUPPORTED = Messages.getString("DBFileDAO.SINGLE_RESOURCES_BIGGER_THAN_4K_NOT_SUPPORTED");
    private static final String BIN_CONTENT = "BIN_CONTENT";
    private static Logger logger = Logger.getLogger(DBFileDAO.class);
    private static int DOC_CHUNK_SIZE = 2000;
    private static int BIN_MAX_SIZE = 0x200000;

    DBFileDAO(DBRepositoryDAO dbRepositoryDAO) {
        super(dbRepositoryDAO);
    }

    public DBFile getFileByPath(String path) throws DBBaseException {
        logger.debug("entering getFileByPath");
        this.checkInitialized();
        DBFile dbFile = null;
        DBObject dbObject = this.getObjectByPath(path);
        if (dbObject instanceof DBFile) {
            dbFile = (DBFile)dbObject;
        }
        logger.debug("exiting getFileByPath");
        return dbFile;
    }

    void insertFile(String name, String path, String contentType, String createdBy, String modifiedBy, int type) throws DBBaseException {
        this.insertFile(name, path, contentType, createdBy, modifiedBy, type, false);
    }

    void insertFile(String name, String path, String contentType, String createdBy, String modifiedBy, int type, boolean override) throws DBBaseException {
        block7: {
            logger.debug("entering insertFile");
            this.checkInitialized();
            Connection connection = null;
            PreparedStatement preparedStatement = null;
            try {
                connection = this.getRepository().getDbUtils().getConnection();
                String script = this.getRepository().getDbUtils().readScript(connection, "/org/eclipse/dirigible/repository/db/sql/insert_file.sql", this.getClass());
                preparedStatement = this.getRepository().getDbUtils().getPreparedStatement(connection, script);
                preparedStatement.setString(1, name);
                preparedStatement.setString(2, path);
                preparedStatement.setInt(3, type);
                preparedStatement.setString(4, contentType);
                preparedStatement.setString(5, createdBy);
                preparedStatement.setTimestamp(6, new Timestamp(GregorianCalendar.getInstance().getTime().getTime()));
                preparedStatement.setString(7, modifiedBy);
                preparedStatement.setTimestamp(8, new Timestamp(GregorianCalendar.getInstance().getTime().getTime()));
                preparedStatement.executeUpdate();
            }
            catch (SQLException e) {
                if (!override) {
                    throw new DBBaseException(e);
                }
                this.getRepository().getDbUtils().closeStatement(preparedStatement);
                this.getRepository().getDbUtils().closeConnection(connection);
                this.updateFile(name, path, contentType, createdBy, modifiedBy, type);
                this.getRepository().getDbUtils().closeStatement((Statement)preparedStatement);
                this.getRepository().getDbUtils().closeConnection(connection);
                break block7;
            }
            catch (IOException e) {
                try {
                    throw new DBBaseException(e);
                }
                catch (Throwable throwable) {
                    this.getRepository().getDbUtils().closeStatement(preparedStatement);
                    this.getRepository().getDbUtils().closeConnection(connection);
                    throw throwable;
                }
            }
            this.getRepository().getDbUtils().closeStatement((Statement)preparedStatement);
            this.getRepository().getDbUtils().closeConnection(connection);
        }
        logger.debug("exiting insertFile");
    }

    void updateFile(String name, String path, String contentType, String createdBy, String modifiedBy, int type) throws DBBaseException {
        logger.debug("entering updateFile");
        this.checkInitialized();
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            try {
                connection = this.getRepository().getDbUtils().getConnection();
                String script = this.getRepository().getDbUtils().readScript(connection, "/org/eclipse/dirigible/repository/db/sql/update_file.sql", this.getClass());
                preparedStatement = this.getRepository().getDbUtils().getPreparedStatement(connection, script);
                preparedStatement.setInt(1, type);
                preparedStatement.setString(2, contentType);
                preparedStatement.setString(3, createdBy);
                preparedStatement.setTimestamp(4, new Timestamp(GregorianCalendar.getInstance().getTime().getTime()));
                preparedStatement.setString(5, modifiedBy);
                preparedStatement.setTimestamp(6, new Timestamp(GregorianCalendar.getInstance().getTime().getTime()));
                preparedStatement.setString(7, name);
                preparedStatement.setString(8, path);
                preparedStatement.executeUpdate();
            }
            catch (SQLException e) {
                throw new DBBaseException(e);
            }
            catch (IOException e) {
                throw new DBBaseException(e);
            }
        }
        catch (Throwable throwable) {
            this.getRepository().getDbUtils().closeStatement(preparedStatement);
            this.getRepository().getDbUtils().closeConnection(connection);
            throw throwable;
        }
        this.getRepository().getDbUtils().closeStatement((Statement)preparedStatement);
        this.getRepository().getDbUtils().closeConnection(connection);
        logger.debug("exiting updateFile");
    }

    void removeDocsCascade(String path) throws DBBaseException {
        this.checkInitialized();
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            try {
                connection = this.getRepository().getDbUtils().getConnection();
                String script = this.getRepository().getDbUtils().readScript(connection, "/org/eclipse/dirigible/repository/db/sql/remove_docs_cascade.sql", this.getClass());
                preparedStatement = this.getRepository().getDbUtils().getPreparedStatement(connection, script);
                preparedStatement.setString(1, String.valueOf(path) + "/" + "%");
                preparedStatement.executeUpdate();
            }
            catch (SQLException e) {
                throw new DBBaseException(e);
            }
            catch (IOException e) {
                throw new DBBaseException(e);
            }
        }
        catch (Throwable throwable) {
            this.getRepository().getDbUtils().closeStatement(preparedStatement);
            this.getRepository().getDbUtils().closeConnection(connection);
            throw throwable;
        }
        this.getRepository().getDbUtils().closeStatement((Statement)preparedStatement);
        this.getRepository().getDbUtils().closeConnection(connection);
    }

    public DBFile createFile(String path, byte[] bytes, boolean isBinary, String contentType) throws DBBaseException {
        return this.createFile(path, bytes, isBinary, contentType, false);
    }

    public DBFile createFile(String path, byte[] bytes, boolean isBinary, String contentType, boolean override) throws DBBaseException {
        this.checkInitialized();
        if (path == null || "".equals(path.trim())) {
            return null;
        }
        String createdBy = this.getRepository().getUser();
        String modifiedBy = this.getRepository().getUser();
        DBFile resource = this.getFileByPath(path);
        if (override || resource == null) {
            String name = path.substring(path.lastIndexOf("/") + 1);
            String collectionPath = path.substring(0, path.lastIndexOf("/"));
            DBFolder parent = this.getDbRepositoryDAO().getDbFolderDAO().createFolder(collectionPath);
            if (parent != null) {
                this.insertFile(name, path, contentType, createdBy, modifiedBy, isBinary ? 2 : 1, override);
                resource = this.getFileByPath(path);
                this.removeDocument(resource);
                this.removeBinary(resource);
                if (isBinary) {
                    this.insertBinary(resource, bytes);
                } else {
                    this.insertDocument(resource, bytes);
                }
            }
        }
        return resource;
    }

    private void insertDocument(DBFile resource, byte[] bytes) throws DBBaseException {
        this.checkInitialized();
        if (bytes == null) {
            bytes = new byte[]{};
        }
        if (bytes.length > DOC_CHUNK_SIZE) {
            byte[][] chunks = this.divideArray(bytes, DOC_CHUNK_SIZE);
            int i = 0;
            while (i < chunks.length - 1) {
                this.insertDocumentSingle(resource, chunks[i], i);
                ++i;
            }
            this.insertDocumentSingle(resource, chunks[chunks.length - 1], chunks.length - 1);
        } else {
            this.insertDocumentSingle(resource, bytes, 0);
        }
    }

    private byte[][] divideArray(byte[] source, int chuncksize) {
        int chunksCount = (int)Math.ceil((double)source.length / (double)chuncksize);
        byte[][] ret = new byte[chunksCount][chuncksize];
        int start = 0;
        int i = 0;
        while (i < ret.length - 1) {
            ret[i] = Arrays.copyOfRange(source, start, start + chuncksize);
            start += chuncksize;
            ++i;
        }
        int lastChunkLength = source.length - (ret.length - 1) * chuncksize;
        byte[] lastChunk = new byte[lastChunkLength];
        lastChunk = Arrays.copyOfRange(source, start, start + lastChunkLength);
        ret[ret.length - 1] = lastChunk;
        return ret;
    }

    private void insertDocumentSingle(DBFile resource, byte[] bytes, int order) throws DBBaseException {
        this.checkInitialized();
        if (bytes.length > DOC_CHUNK_SIZE) {
            throw new RuntimeException(SINGLE_RESOURCES_BIGGER_THAN_4K_NOT_SUPPORTED);
        }
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            try {
                connection = this.getRepository().getDbUtils().getConnection();
                String script = this.getRepository().getDbUtils().readScript(connection, "/org/eclipse/dirigible/repository/db/sql/insert_document.sql", this.getClass());
                preparedStatement = this.getRepository().getDbUtils().getPreparedStatement(connection, script);
                preparedStatement.setString(1, resource.getPath());
                preparedStatement.setString(2, new String(bytes, Charset.defaultCharset()));
                preparedStatement.setInt(3, order);
                preparedStatement.executeUpdate();
            }
            catch (SQLException e) {
                throw new DBBaseException(e);
            }
            catch (IOException e) {
                throw new DBBaseException(e);
            }
        }
        catch (Throwable throwable) {
            this.getRepository().getDbUtils().closeStatement(preparedStatement);
            this.getRepository().getDbUtils().closeConnection(connection);
            throw throwable;
        }
        this.getRepository().getDbUtils().closeStatement((Statement)preparedStatement);
        this.getRepository().getDbUtils().closeConnection(connection);
    }

    void setDocument(DBFile resource, byte[] bytes) throws DBBaseException {
        this.checkInitialized();
        this.removeDocument(resource);
        this.insertDocument(resource, bytes);
        this.setModified(resource);
    }

    void setModified(DBFile resource) {
        this.checkInitialized();
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            try {
                connection = this.getRepository().getDbUtils().getConnection();
                String script = this.getRepository().getDbUtils().readScript(connection, "/org/eclipse/dirigible/repository/db/sql/set_modified.sql", this.getClass());
                preparedStatement = this.getRepository().getDbUtils().getPreparedStatement(connection, script);
                preparedStatement.setString(1, this.getRepository().getUser());
                preparedStatement.setTimestamp(2, new Timestamp(GregorianCalendar.getInstance().getTime().getTime()));
                preparedStatement.setString(3, resource.getPath());
                preparedStatement.executeUpdate();
            }
            catch (SQLException e) {
                throw new DBBaseException(e);
            }
            catch (IOException e) {
                throw new DBBaseException(e);
            }
        }
        catch (Throwable throwable) {
            this.getRepository().getDbUtils().closeStatement(preparedStatement);
            this.getRepository().getDbUtils().closeConnection(connection);
            throw throwable;
        }
        this.getRepository().getDbUtils().closeStatement((Statement)preparedStatement);
        this.getRepository().getDbUtils().closeConnection(connection);
        this.getRepository().getCacheManager().clear(resource.getPath());
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    byte[] getDocument(DBFile resource) throws DBBaseException {
        byte[] byArray;
        this.checkInitialized();
        if (resource == null) {
            return null;
        }
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            connection = this.getRepository().getDbUtils().getConnection();
            String script = this.getRepository().getDbUtils().readScript(connection, "/org/eclipse/dirigible/repository/db/sql/get_document.sql", this.getClass());
            preparedStatement = this.getRepository().getDbUtils().getPreparedStatement(connection, script);
            preparedStatement.setString(1, resource.getPath());
            ResultSet resultSet = preparedStatement.executeQuery();
            byte[] bytes = null;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while (true) {
                if (!resultSet.next()) {
                    byArray = baos.toByteArray();
                    break;
                }
                bytes = DBMapper.dbToData(resultSet);
                baos.write(bytes);
            }
        }
        catch (SQLException e) {
            try {
                throw new DBBaseException(e);
                catch (IOException e2) {
                    throw new DBBaseException(e2);
                }
            }
            catch (Throwable throwable) {
                this.getRepository().getDbUtils().closeStatement(preparedStatement);
                this.getRepository().getDbUtils().closeConnection(connection);
                throw throwable;
            }
        }
        this.getRepository().getDbUtils().closeStatement((Statement)preparedStatement);
        this.getRepository().getDbUtils().closeConnection(connection);
        return byArray;
    }

    void removeFileByPath(String path) throws DBBaseException {
        this.checkInitialized();
        this.removeDocument(this.getFileByPath(path));
        this.removeBinary(this.getFileByPath(path));
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            try {
                connection = this.getRepository().getDbUtils().getConnection();
                String script = this.getRepository().getDbUtils().readScript(connection, "/org/eclipse/dirigible/repository/db/sql/remove_file_by_path.sql", this.getClass());
                preparedStatement = this.getRepository().getDbUtils().getPreparedStatement(connection, script);
                preparedStatement.setString(1, path);
                preparedStatement.executeUpdate();
            }
            catch (SQLException e) {
                throw new DBBaseException(e);
            }
            catch (IOException e) {
                throw new DBBaseException(e);
            }
        }
        catch (Throwable throwable) {
            this.getRepository().getDbUtils().closeStatement(preparedStatement);
            this.getRepository().getDbUtils().closeConnection(connection);
            throw throwable;
        }
        this.getRepository().getDbUtils().closeStatement((Statement)preparedStatement);
        this.getRepository().getDbUtils().closeConnection(connection);
        this.getRepository().getCacheManager().clear(path);
    }

    private void removeDocument(DBFile resource) throws DBBaseException {
        this.checkInitialized();
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            try {
                connection = this.getRepository().getDbUtils().getConnection();
                String script = this.getRepository().getDbUtils().readScript(connection, "/org/eclipse/dirigible/repository/db/sql/remove_document.sql", this.getClass());
                preparedStatement = this.getRepository().getDbUtils().getPreparedStatement(connection, script);
                preparedStatement.setString(1, resource.getPath());
                preparedStatement.executeUpdate();
            }
            catch (SQLException e) {
                throw new DBBaseException(e);
            }
            catch (IOException e) {
                throw new DBBaseException(e);
            }
        }
        catch (Throwable throwable) {
            this.getRepository().getDbUtils().closeStatement(preparedStatement);
            this.getRepository().getDbUtils().closeConnection(connection);
            throw throwable;
        }
        this.getRepository().getDbUtils().closeStatement((Statement)preparedStatement);
        this.getRepository().getDbUtils().closeConnection(connection);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getBinary(DBFile resource) throws DBBaseException {
        byte[] byArray;
        this.checkInitialized();
        if (resource == null) {
            return null;
        }
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            connection = this.getRepository().getDbUtils().getConnection();
            String script = this.getRepository().getDbUtils().readScript(connection, "/org/eclipse/dirigible/repository/db/sql/get_binary.sql", this.getClass());
            preparedStatement = this.getRepository().getDbUtils().getPreparedStatement(connection, script);
            preparedStatement.setString(1, resource.getPath());
            ResultSet resultSet = preparedStatement.executeQuery();
            byte[] bytes = null;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            if (resultSet.next()) {
                bytes = DBMapper.dbToDataBinary(connection, resultSet, BIN_CONTENT);
                baos.write(bytes);
            }
            byArray = baos.toByteArray();
        }
        catch (SQLException e) {
            try {
                throw new DBBaseException(e);
                catch (IOException e2) {
                    throw new DBBaseException(e2);
                }
            }
            catch (Throwable throwable) {
                this.getRepository().getDbUtils().closeStatement(preparedStatement);
                this.getRepository().getDbUtils().closeConnection(connection);
                throw throwable;
            }
        }
        this.getRepository().getDbUtils().closeStatement((Statement)preparedStatement);
        this.getRepository().getDbUtils().closeConnection(connection);
        return byArray;
    }

    public void setBinary(DBFile resource, byte[] bytes, String contentType) throws DBBaseException {
        this.checkInitialized();
        this.removeBinary(resource);
        this.insertBinary(resource, bytes);
        this.setModified(resource);
    }

    private void insertBinary(DBFile resource, byte[] bytes) throws DBBaseException {
        this.checkInitialized();
        if (bytes == null) {
            bytes = new byte[]{};
        }
        if (bytes.length > BIN_MAX_SIZE) {
            throw new DBBaseException(String.valueOf(MAX_SIZE_OF_BINARY_RESOURCE_IS) + BIN_MAX_SIZE);
        }
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            try {
                connection = this.getRepository().getDbUtils().getConnection();
                String script = this.getRepository().getDbUtils().readScript(connection, "/org/eclipse/dirigible/repository/db/sql/insert_binary.sql", this.getClass());
                preparedStatement = this.getRepository().getDbUtils().getPreparedStatement(connection, script);
                preparedStatement.setString(1, resource.getPath());
                preparedStatement.setBinaryStream(2, (InputStream)new ByteArrayInputStream(bytes), bytes.length);
                preparedStatement.executeUpdate();
            }
            catch (SQLException e) {
                throw new DBBaseException(e);
            }
            catch (IOException e) {
                throw new DBBaseException(e);
            }
        }
        catch (Throwable throwable) {
            this.getRepository().getDbUtils().closeStatement(preparedStatement);
            this.getRepository().getDbUtils().closeConnection(connection);
            throw throwable;
        }
        this.getRepository().getDbUtils().closeStatement((Statement)preparedStatement);
        this.getRepository().getDbUtils().closeConnection(connection);
    }

    private void removeBinary(DBFile resource) throws DBBaseException {
        this.checkInitialized();
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            try {
                connection = this.getRepository().getDbUtils().getConnection();
                String script = this.getRepository().getDbUtils().readScript(connection, "/org/eclipse/dirigible/repository/db/sql/remove_binary.sql", this.getClass());
                preparedStatement = this.getRepository().getDbUtils().getPreparedStatement(connection, script);
                preparedStatement.setString(1, resource.getPath());
                preparedStatement.executeUpdate();
            }
            catch (SQLException e) {
                throw new DBBaseException(e);
            }
            catch (IOException e) {
                throw new DBBaseException(e);
            }
        }
        catch (Throwable throwable) {
            this.getRepository().getDbUtils().closeStatement(preparedStatement);
            this.getRepository().getDbUtils().closeConnection(connection);
            throw throwable;
        }
        this.getRepository().getDbUtils().closeStatement((Statement)preparedStatement);
        this.getRepository().getDbUtils().closeConnection(connection);
    }

    public void renameFileByPath(String path, String newPath) throws DBBaseException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            try {
                connection = this.getRepository().getDbUtils().getConnection();
                this.renameDocuments(connection, path, newPath);
                this.renameBinaries(connection, path, newPath);
                String script = this.getRepository().getDbUtils().readScript(connection, "/org/eclipse/dirigible/repository/db/sql/get_files_by_path_cascade.sql", this.getClass());
                preparedStatement = this.getRepository().getDbUtils().getPreparedStatement(connection, script);
                preparedStatement.setString(1, String.valueOf(path) + "%");
                ResultSet resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    String oldFilePath = resultSet.getString("FILE_PATH");
                    String newFilePath = oldFilePath.replace(path, newPath);
                    String newName = new RepositoryPath(newFilePath).getLastSegment();
                    try {
                        try {
                            script = this.getRepository().getDbUtils().readScript(connection, "/org/eclipse/dirigible/repository/db/sql/rename_file.sql", this.getClass());
                            preparedStatement = this.getRepository().getDbUtils().getPreparedStatement(connection, script);
                            preparedStatement.setString(1, newFilePath);
                            preparedStatement.setString(2, newName);
                            preparedStatement.setString(3, oldFilePath);
                            preparedStatement.executeUpdate();
                        }
                        catch (SQLException e) {
                            throw new DBBaseException(e);
                        }
                    }
                    finally {
                        this.getRepository().getDbUtils().closeStatement((Statement)preparedStatement);
                    }
                }
            }
            catch (Exception e) {
                throw new DBBaseException(e);
            }
        }
        catch (Throwable throwable) {
            this.getRepository().getDbUtils().closeStatement(preparedStatement);
            this.getRepository().getDbUtils().closeConnection(connection);
            throw throwable;
        }
        this.getRepository().getDbUtils().closeStatement((Statement)preparedStatement);
        this.getRepository().getDbUtils().closeConnection(connection);
        this.getRepository().getCacheManager().clear();
    }

    private void renameDocuments(Connection connection, String path, String newPath) throws DBBaseException {
        PreparedStatement preparedStatement = null;
        try {
            try {
                String script = this.getRepository().getDbUtils().readScript(connection, "/org/eclipse/dirigible/repository/db/sql/get_documents_by_path_cascade.sql", this.getClass());
                preparedStatement = this.getRepository().getDbUtils().getPreparedStatement(connection, script);
                preparedStatement.setString(1, String.valueOf(path) + "%");
                ResultSet resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    String oldFilePath = resultSet.getString("DOC_FILE_PATH");
                    String newFilePath = oldFilePath.replace(path, newPath);
                    try {
                        try {
                            script = this.getRepository().getDbUtils().readScript(connection, "/org/eclipse/dirigible/repository/db/sql/rename_document.sql", this.getClass());
                            preparedStatement = this.getRepository().getDbUtils().getPreparedStatement(connection, script);
                            preparedStatement.setString(1, newFilePath);
                            preparedStatement.setString(2, oldFilePath);
                            preparedStatement.executeUpdate();
                        }
                        catch (SQLException e) {
                            throw new DBBaseException(e);
                        }
                    }
                    finally {
                        this.getRepository().getDbUtils().closeStatement((Statement)preparedStatement);
                    }
                }
            }
            catch (Exception e) {
                throw new DBBaseException(e);
            }
        }
        catch (Throwable throwable) {
            this.getRepository().getDbUtils().closeStatement(preparedStatement);
            throw throwable;
        }
        this.getRepository().getDbUtils().closeStatement((Statement)preparedStatement);
        this.getRepository().getCacheManager().clear();
    }

    private void renameBinaries(Connection connection, String path, String newPath) throws DBBaseException {
        PreparedStatement preparedStatement = null;
        try {
            try {
                String script = this.getRepository().getDbUtils().readScript(connection, "/org/eclipse/dirigible/repository/db/sql/get_binaries_by_path_cascade.sql", this.getClass());
                preparedStatement = this.getRepository().getDbUtils().getPreparedStatement(connection, script);
                preparedStatement.setString(1, String.valueOf(path) + "%");
                ResultSet resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    String oldFilePath = resultSet.getString("BIN_FILE_PATH");
                    String newFilePath = oldFilePath.replace(path, newPath);
                    try {
                        try {
                            script = this.getRepository().getDbUtils().readScript(connection, "/org/eclipse/dirigible/repository/db/sql/rename_binary.sql", this.getClass());
                            preparedStatement = this.getRepository().getDbUtils().getPreparedStatement(connection, script);
                            preparedStatement.setString(1, newFilePath);
                            preparedStatement.setString(2, oldFilePath);
                            preparedStatement.executeUpdate();
                        }
                        catch (SQLException e) {
                            throw new DBBaseException(e);
                        }
                    }
                    finally {
                        this.getRepository().getDbUtils().closeStatement((Statement)preparedStatement);
                    }
                }
            }
            catch (Exception e) {
                throw new DBBaseException(e);
            }
        }
        catch (Throwable throwable) {
            this.getRepository().getDbUtils().closeStatement(preparedStatement);
            throw throwable;
        }
        this.getRepository().getDbUtils().closeStatement((Statement)preparedStatement);
        this.getRepository().getCacheManager().clear();
    }
}

