/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.db.dao;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import org.eclipse.dirigible.repository.api.IEntity;
import org.eclipse.dirigible.repository.api.IResourceVersion;
import org.eclipse.dirigible.repository.api.RepositoryPath;
import org.eclipse.dirigible.repository.db.DBBaseException;
import org.eclipse.dirigible.repository.db.DBRepository;
import org.eclipse.dirigible.repository.db.DBResourceVersion;
import org.eclipse.dirigible.repository.db.dao.DBFile;
import org.eclipse.dirigible.repository.db.dao.DBFileDAO;
import org.eclipse.dirigible.repository.db.dao.DBFileVersion;
import org.eclipse.dirigible.repository.db.dao.DBFileVersionDAO;
import org.eclipse.dirigible.repository.db.dao.DBFolder;
import org.eclipse.dirigible.repository.db.dao.DBFolderDAO;
import org.eclipse.dirigible.repository.db.dao.DBObject;
import org.eclipse.dirigible.repository.db.dao.DBObjectDAO;
import org.eclipse.dirigible.repository.db.dao.DBSearchDAO;
import org.eclipse.dirigible.repository.db.dao.Messages;
import org.eclipse.dirigible.repository.db.init.DBRepositoryInitializer;
import org.eclipse.dirigible.repository.logging.Logger;

public class DBRepositoryDAO {
    private static final String DATA_ACCESS_OBJECT_FOR_REPOSITORY_NOT_INITIALIZED = Messages.getString("DBRepositoryDAO.DATA_ACCESS_OBJECT_FOR_REPOSITORY_NOT_INITIALIZED");
    private static Logger logger = Logger.getLogger(DBRepositoryDAO.class);
    private DBRepository repository;
    private boolean initialized = false;
    private DBObjectDAO dbObjectDAO;
    private DBFolderDAO dbFolderDAO;
    private DBFileDAO dbFileDAO;
    private DBSearchDAO dbSearchDAO;
    private DBFileVersionDAO dbFileVersionDAO;

    public DBRepositoryDAO(DBRepository repository) {
        logger.debug("entering constructor");
        this.repository = repository;
        this.dbObjectDAO = new DBObjectDAO(this);
        this.dbFolderDAO = new DBFolderDAO(this);
        this.dbFileDAO = new DBFileDAO(this);
        this.dbSearchDAO = new DBSearchDAO(this);
        this.dbFileVersionDAO = new DBFileVersionDAO(this);
        logger.debug("exiting constructor");
    }

    DBRepository getRepository() {
        logger.debug("entering getRepository");
        DBRepository dbRepository = this.repository;
        logger.debug("exiting getRepository");
        return dbRepository;
    }

    public DBObjectDAO getDbObjectDAO() {
        return this.dbObjectDAO;
    }

    public DBFolderDAO getDbFolderDAO() {
        return this.dbFolderDAO;
    }

    public DBFileDAO getDbFileDAO() {
        return this.dbFileDAO;
    }

    public DBSearchDAO getDbSearchDAO() {
        return this.dbSearchDAO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean initialize(boolean forceRecreate) throws SQLException {
        logger.debug("entering initialize");
        Class<DBRepositoryDAO> clazz = DBRepositoryDAO.class;
        synchronized (DBRepositoryDAO.class) {
            Connection connection = null;
            try {
                connection = this.getRepository().getDbUtils().getConnection();
                this.initialized = this.initialize(connection, forceRecreate);
            }
            finally {
                this.getRepository().getDbUtils().closeConnection(connection);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            logger.debug("exiting initialize");
            return this.initialized;
        }
    }

    private boolean initialize(Connection connection, boolean forceRecreate) {
        logger.debug("entering initialize with connection");
        DBRepositoryInitializer dbRepositoryInitializer = new DBRepositoryInitializer(this.repository.getDataSource(), connection, forceRecreate);
        boolean result = dbRepositoryInitializer.initialize();
        logger.debug("exiting initialize with connection");
        return result;
    }

    void checkInitialized() throws DBBaseException {
        if (!this.initialized) {
            throw new DBBaseException(DATA_ACCESS_OBJECT_FOR_REPOSITORY_NOT_INITIALIZED);
        }
    }

    public DBObject getObjectByPath(String path) throws DBBaseException {
        return this.dbObjectDAO.getObjectByPath(path);
    }

    public DBFolder getFolderByPath(String path) throws DBBaseException {
        return this.dbFolderDAO.getFolderByPath(path);
    }

    public DBFile getFileByPath(String path) throws DBBaseException {
        return this.dbFileDAO.getFileByPath(path);
    }

    public DBFolder createFolder(String path) throws DBBaseException {
        return this.dbFolderDAO.createFolder(path);
    }

    public void removeFolderByPath(String path) throws DBBaseException {
        this.dbFolderDAO.removeFolderByPath(path);
    }

    public DBFile createFile(String path, byte[] bytes, boolean isBinary, String contentType) throws DBBaseException {
        return this.createFile(path, bytes, isBinary, contentType, false);
    }

    public DBFile createFile(String path, byte[] bytes, boolean isBinary, String contentType, boolean override) throws DBBaseException {
        DBFile dbFile = this.dbFileDAO.createFile(path, bytes, isBinary, contentType, override);
        this.dbFileVersionDAO.createFileVersion(path, bytes, isBinary, contentType);
        return dbFile;
    }

    public void setDocument(DBFile resource, byte[] bytes) throws DBBaseException {
        this.dbFileDAO.setDocument(resource, bytes);
        this.dbFileVersionDAO.createFileVersion(resource.getPath(), bytes, resource.isBinary(), resource.getContentType());
    }

    public byte[] getDocument(DBFile resource) throws DBBaseException {
        return this.dbFileDAO.getDocument(resource);
    }

    public void removeFileByPath(String path) throws DBBaseException {
        this.dbFileDAO.removeFileByPath(path);
        this.dbFileVersionDAO.removeAllFileVersions(path);
    }

    public void cleanupOldVersions() throws DBBaseException {
        GregorianCalendar calendar = new GregorianCalendar();
        ((Calendar)calendar).roll(2, false);
        this.dbFileVersionDAO.removeAllFileVersionsBeforeDate(calendar.getTime());
    }

    public void dispose() {
    }

    public List<DBObject> getChildrenByFolder(String path) throws DBBaseException {
        return this.dbFolderDAO.getChildrenByFolder(path);
    }

    public byte[] getBinary(DBFile resource) throws DBBaseException {
        return this.dbFileDAO.getBinary(resource);
    }

    public void setBinary(DBFile resource, byte[] bytes, String contentType) throws DBBaseException {
        this.dbFileDAO.setBinary(resource, bytes, contentType);
    }

    public List<IEntity> searchName(String parameter, boolean caseInsensitive) {
        return this.dbSearchDAO.searchName(parameter, caseInsensitive);
    }

    public List<IEntity> searchName(String root, String parameter, boolean caseInsensitive) {
        return this.dbSearchDAO.searchName(root, parameter, caseInsensitive);
    }

    public List<IEntity> searchPath(String parameter, boolean caseInsensitive) {
        return this.dbSearchDAO.searchPath(parameter, caseInsensitive);
    }

    public List<IEntity> searchText(String parameter, boolean caseInsensitive) {
        return this.dbSearchDAO.searchInPathAndText(parameter, caseInsensitive);
    }

    public DBFileVersion getFileVersionByPath(String path, int version) {
        return this.dbFileVersionDAO.getFileVersionByPath(path, version);
    }

    public List<DBFileVersion> getFileVersionsByPath(String path) {
        return this.dbFileVersionDAO.getFileVersionsByPath(path);
    }

    public List<IResourceVersion> getResourceVersionsByPath(String path) {
        ArrayList<IResourceVersion> resultList = new ArrayList<IResourceVersion>();
        List<DBFileVersion> fileVersions = this.getFileVersionsByPath(path);
        for (DBFileVersion dbFileVersion : fileVersions) {
            resultList.add(new DBResourceVersion(this.getRepository(), new RepositoryPath(path), dbFileVersion.getVersion()));
        }
        return resultList;
    }

    public void renameFolder(String path, String newPath) {
        this.dbFolderDAO.renameFolderByPath(path, newPath);
    }

    public void renameFile(String path, String newPath) {
        this.dbFileDAO.renameFileByPath(path, newPath);
    }
}

