/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.rcp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.eclipse.dirigible.repository.api.ICollection;
import org.eclipse.dirigible.repository.api.IEntity;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.api.IResource;
import org.eclipse.dirigible.repository.api.IResourceVersion;
import org.eclipse.dirigible.repository.api.RepositoryPath;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.repository.rcp.Messages;
import org.eclipse.dirigible.repository.rcp.RCPBaseException;
import org.eclipse.dirigible.repository.rcp.RCPCollection;
import org.eclipse.dirigible.repository.rcp.RCPRepositoryDAO;
import org.eclipse.dirigible.repository.rcp.RCPResource;
import org.eclipse.dirigible.repository.rcp.RCPWorkspaceMapper;
import org.eclipse.dirigible.repository.rcp.RCPZipExporter;
import org.eclipse.dirigible.repository.rcp.RCPZipImporter;

public class RCPRepository
implements IRepository {
    private static final String PROVIDED_ZIP_DATA_CANNOT_BE_NULL = Messages.getString("DBRepository.PROVIDED_ZIP_DATA_CANNOT_BE_NULL");
    private static final String PROVIDED_ZIP_INPUT_STREAM_CANNOT_BE_NULL = Messages.getString("DBRepository.PROVIDED_ZIP_INPUT_STREAM_CANNOT_BE_NULL");
    private static Logger logger = Logger.getLogger(RCPRepository.class);
    public static final String PATH_DELIMITER = "/";
    private static final String WORKSPACE_PATH = "/";
    private RCPRepositoryDAO repositoryDAO;
    private static RCPRepository instance;
    private RCPZipImporter importer = new RCPZipImporter();
    private RCPZipExporter exporter = new RCPZipExporter();

    public static RCPRepository getInstance() {
        if (instance == null) {
            instance = new RCPRepository();
        }
        return instance;
    }

    private RCPRepository() throws RCPBaseException {
        this.repositoryDAO = new RCPRepositoryDAO(this);
    }

    public ICollection getRoot() {
        logger.debug("entering getRoot");
        RepositoryPath wrapperPath = new RepositoryPath("/");
        RCPCollection dbCollection = new RCPCollection(this, wrapperPath);
        logger.debug("exiting getRoot");
        return dbCollection;
    }

    public ICollection createCollection(String path) throws IOException {
        logger.debug("entering createCollection");
        RepositoryPath wrapperPath = new RepositoryPath(path);
        RCPCollection collection = new RCPCollection(this, wrapperPath);
        collection.create();
        logger.debug("exiting createCollection");
        return collection;
    }

    public ICollection getCollection(String path) {
        logger.debug("entering getCollection");
        RepositoryPath wrapperPath = new RepositoryPath(path);
        RCPCollection dbCollection = new RCPCollection(this, wrapperPath);
        logger.debug("exiting getCollection");
        return dbCollection;
    }

    public void removeCollection(String path) throws IOException {
        logger.debug("entering removeCollection");
        RepositoryPath wrapperPath = new RepositoryPath(path);
        RCPCollection collection = new RCPCollection(this, wrapperPath);
        collection.delete();
        logger.debug("exiting removeCollection");
    }

    public boolean hasCollection(String path) throws IOException {
        logger.debug("entering hasCollection");
        RepositoryPath wrapperPath = new RepositoryPath(path);
        RCPCollection collection = new RCPCollection(this, wrapperPath);
        boolean result = collection.exists();
        logger.debug("exiting hasCollection");
        return result;
    }

    public IResource createResource(String path) throws IOException {
        logger.debug("entering createResource");
        RepositoryPath wrapperPath = new RepositoryPath(path);
        RCPResource resource = new RCPResource(this, wrapperPath);
        resource.create();
        logger.debug("exiting createResource");
        return resource;
    }

    public IResource createResource(String path, byte[] content) throws IOException {
        logger.debug("entering createResource with Content");
        RepositoryPath wrapperPath = new RepositoryPath(path);
        RCPResource resource = new RCPResource(this, wrapperPath);
        resource.setContent(content);
        logger.debug("exiting createResource with Content");
        return resource;
    }

    public IResource createResource(String path, byte[] content, boolean isBinary, String contentType) throws IOException {
        return this.createResource(path, content, isBinary, contentType, false);
    }

    public IResource createResource(String path, byte[] content, boolean isBinary, String contentType, boolean override) throws IOException {
        logger.debug("entering createResource with Content");
        try {
            this.getRepositoryDAO().createFile(path, content, isBinary, contentType);
        }
        catch (RCPBaseException e) {
            throw new IOException((Throwable)((Object)e));
        }
        IResource resource = this.getResource(path);
        logger.debug("exiting createResource with Content");
        return resource;
    }

    public IResource getResource(String path) {
        logger.debug("entering getResource");
        RepositoryPath wrapperPath = new RepositoryPath(path);
        RCPResource resource = new RCPResource(this, wrapperPath);
        logger.debug("exiting getResource");
        return resource;
    }

    public void removeResource(String path) throws IOException {
        logger.debug("entering removeResource");
        RepositoryPath wrapperPath = new RepositoryPath(path);
        RCPResource resource = new RCPResource(this, wrapperPath);
        resource.delete();
        logger.debug("exiting removeResource");
    }

    public boolean hasResource(String path) throws IOException {
        logger.debug("entering hasResource");
        RepositoryPath wrapperPath = new RepositoryPath(path);
        RCPResource resource = new RCPResource(this, wrapperPath);
        boolean result = resource.exists();
        logger.debug("exiting hasResource");
        return result;
    }

    public void dispose() {
    }

    public RCPRepositoryDAO getRepositoryDAO() {
        return this.repositoryDAO;
    }

    public void importZip(ZipInputStream zipInputStream, String path) throws IOException {
        this.importZip(zipInputStream, path, false);
    }

    public void importZip(ZipInputStream zipInputStream, String path, boolean override) throws IOException {
        this.importZip(zipInputStream, path, override, false);
    }

    public void importZip(ZipInputStream zipInputStream, String path, boolean override, boolean excludeRootFolderName) throws IOException {
        if (zipInputStream == null) {
            logger.error(PROVIDED_ZIP_INPUT_STREAM_CANNOT_BE_NULL);
            throw new IOException(PROVIDED_ZIP_INPUT_STREAM_CANNOT_BE_NULL);
        }
        this.importer.unzip(path, zipInputStream, null);
    }

    public void importZip(byte[] data, String path) throws IOException {
        this.importZip(data, path, false);
    }

    public void importZip(byte[] data, String path, boolean override) throws IOException {
        this.importZip(data, path, override, false, null);
    }

    public void importZip(byte[] data, String path, boolean override, boolean excludeRootFolderName, Map<String, String> filter) throws IOException {
        if (data == null) {
            logger.error(PROVIDED_ZIP_DATA_CANNOT_BE_NULL);
            throw new IOException(PROVIDED_ZIP_DATA_CANNOT_BE_NULL);
        }
        this.importer.unzip(path, new ZipInputStream(new ByteArrayInputStream(data)), filter);
    }

    public byte[] exportZip(List<String> relativeRoots) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ZipOutputStream zipOutputStream = new ZipOutputStream(baos);
        this.exporter.zip(relativeRoots, zipOutputStream);
        return baos.toByteArray();
    }

    public byte[] exportZip(String path, boolean inclusive) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ZipOutputStream zipOutputStream = new ZipOutputStream(baos);
        try {
            this.exporter.zip(path, zipOutputStream, inclusive);
        }
        finally {
            zipOutputStream.flush();
            zipOutputStream.close();
        }
        return baos.toByteArray();
    }

    public List<IEntity> searchName(String parameter, boolean caseInsensitive) throws IOException {
        return null;
    }

    public List<IEntity> searchName(String root, String parameter, boolean caseInsensitive) throws IOException {
        String workspacePath = RCPWorkspaceMapper.getMappedName(root);
        ArrayList<IEntity> entities = new ArrayList<IEntity>();
        if (parameter == null || "".equals(parameter)) {
            return entities;
        }
        if (parameter.startsWith("%")) {
            parameter = parameter.substring(1);
        }
        File dir = new File(workspacePath);
        this.findInDirectory(dir, parameter, entities);
        return entities;
    }

    private void findInDirectory(File dir, String parameter, List<IEntity> entities) throws IOException {
        File[] all;
        File[] found;
        final String search = parameter;
        File[] fileArray = found = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(search);
            }
        });
        int n = found.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            String repositoryName = RCPWorkspaceMapper.getReverseMappedName(f.getCanonicalPath());
            RepositoryPath repositoryPath = new RepositoryPath(repositoryName);
            entities.add(new RCPResource(this, repositoryPath));
            ++n2;
        }
        File[] fileArray2 = all = dir.listFiles();
        int n3 = all.length;
        n = 0;
        while (n < n3) {
            File f = fileArray2[n];
            if (f.isDirectory()) {
                this.findInDirectory(f, parameter, entities);
            }
            ++n;
        }
    }

    public List<IEntity> searchPath(String parameter, boolean caseInsensitive) throws IOException {
        return null;
    }

    public List<IEntity> searchText(String parameter, boolean caseInsensitive) throws IOException {
        return null;
    }

    public List<IResourceVersion> getResourceVersions(String path) throws IOException {
        return null;
    }

    public IResourceVersion getResourceVersion(String path, int version) throws IOException {
        return null;
    }

    public void cleanupOldVersions() throws IOException {
    }

    public String getUser() {
        return "local";
    }
}

