/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.jgit.command.ui;

import org.eclipse.dirigible.ide.jgit.command.ui.Messages;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public abstract class BaseCommandDialog
extends TitleAreaDialog {
    private static final long serialVersionUID = -5124345102495879231L;
    private static final String USERNAME = Messages.BaseCommandDialog_USERNAME;
    private static final String PASSWORD = Messages.BaseCommandDialog_PASSWORD;
    private static final String USERNAME_IS_EMPTY = Messages.BaseCommandDialog_USERNAME_IS_EMPTY;
    private static final String PASSWORD_IS_EMPTY = Messages.BaseCommandDialog_PASSWORD_IS_EMPTY;
    private Text textUsername;
    private Text textPassword;
    private String username;
    private String password;
    protected String errorMessage;

    public BaseCommandDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(2, false);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        container.setLayout((Layout)layout);
        this.addWidgets(container);
        return area;
    }

    protected void addWidgets(Composite container) {
        this.createUsernameField(container);
        this.createPasswordField(container);
    }

    private void createUsernameField(Composite container) {
        Label labelUsername = new Label(container, 0);
        labelUsername.setText(USERNAME);
        GridData dataUsername = new GridData();
        dataUsername.grabExcessHorizontalSpace = true;
        dataUsername.horizontalAlignment = 4;
        this.textUsername = new Text(container, 2048);
        this.textUsername.setLayoutData((Object)dataUsername);
    }

    private void createPasswordField(Composite container) {
        Label labelPassword = new Label(container, 0);
        labelPassword.setText(PASSWORD);
        GridData dataPassword = new GridData();
        dataPassword.grabExcessHorizontalSpace = true;
        dataPassword.horizontalAlignment = 4;
        this.textPassword = new Text(container, 0x400800);
        this.textPassword.setLayoutData((Object)dataPassword);
    }

    protected boolean validateInput() {
        boolean valid = false;
        if (StringUtils.isEmptyOrNull((String)this.textUsername.getText())) {
            this.errorMessage = USERNAME_IS_EMPTY;
        } else if (StringUtils.isEmptyOrNull((String)this.textPassword.getText())) {
            this.errorMessage = PASSWORD_IS_EMPTY;
        } else {
            valid = true;
        }
        return valid;
    }

    protected void saveInput() {
        this.username = this.textUsername.getText();
        this.password = this.textPassword.getText();
    }

    protected boolean isResizable() {
        return true;
    }

    protected void okPressed() {
        if (this.validateInput()) {
            this.errorMessage = null;
            this.saveInput();
            super.okPressed();
        }
        this.setErrorMessage(this.errorMessage);
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }
}

