/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.platform;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import org.eclipse.ease.modules.platform.IFileHandle;

public class FilesystemHandle
implements IFileHandle {
    private final File fFile;
    private int fMode;
    protected BufferedReader fReader = null;
    private PrintWriter fWriter = null;

    public FilesystemHandle(File file, int mode) {
        this.fFile = file;
        this.fMode = mode;
    }

    protected BufferedReader createReader() throws Exception {
        return new BufferedReader(new InputStreamReader(new FileInputStream(this.fFile)));
    }

    private BufferedReader getReader() {
        try {
            if (this.fReader == null) {
                this.fReader = this.createReader();
            }
        }
        catch (Exception exception) {}
        return this.fReader;
    }

    @Override
    public String read(int characters) throws IOException {
        BufferedReader reader = this.getReader();
        if (reader != null) {
            StringBuilder result = new StringBuilder();
            char[] buffer = new char[4096];
            while (characters != 0) {
                int length = reader.read(buffer, 0, characters < 0 ? buffer.length : Math.min(buffer.length, characters));
                if (length == -1) {
                    reader.close();
                    break;
                }
                result.append(new String(buffer, 0, length));
            }
            return result.toString();
        }
        return null;
    }

    @Override
    public String readLine() throws IOException {
        BufferedReader reader = this.getReader();
        if (reader != null) {
            return reader.readLine();
        }
        return null;
    }

    protected Writer createWriter() throws Exception {
        return new FileWriter(this.fFile, (this.fMode & 4) == 4);
    }

    @Override
    public boolean write(String data) {
        try {
            if (this.fWriter == null) {
                this.fWriter = new PrintWriter(new BufferedWriter(this.createWriter()));
            }
            this.fWriter.print(data);
            this.fWriter.flush();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected static StringBuilder read(Reader reader) throws IOException {
        StringBuilder builder = new StringBuilder();
        char[] buffer = new char[4096];
        int bytes = 0;
        do {
            bytes = reader.read(buffer);
            builder.append(buffer, 0, Math.max(bytes, 0));
        } while (bytes != -1);
        if (builder.length() > 0) {
            return builder;
        }
        return null;
    }

    @Override
    public boolean exists() {
        return this.fFile.exists();
    }

    @Override
    public boolean createFile(boolean createHierarchy) throws Exception {
        File folder;
        if (createHierarchy && !(folder = this.fFile.getParentFile()).exists()) {
            folder.mkdirs();
        }
        return this.fFile.createNewFile();
    }

    public void setMode(int mode) {
        this.fMode = mode;
    }

    protected int getMode() {
        return this.fMode;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    @Override
    public void close() {
        try {
            if (this.fReader != null) {
                this.fReader.close();
            }
        }
        catch (IOException iOException) {}
        try {
            if (this.fWriter != null) {
                this.fWriter.close();
            }
        }
        catch (Exception exception) {}
    }

    @Override
    public Object getFile() {
        return this.fFile;
    }
}

