/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.dnd;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ease.ICodeFactory;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.Logger;
import org.eclipse.ease.modules.EnvironmentModule;
import org.eclipse.ease.service.IScriptService;
import org.eclipse.ease.service.ScriptService;
import org.eclipse.ease.service.ScriptType;
import org.eclipse.ease.tools.ResourceTools;
import org.eclipse.ease.ui.dnd.IShellDropHandler;
import org.eclipse.ui.PlatformUI;

public class ResourceDropHandler
implements IShellDropHandler {
    @Override
    public boolean accepts(IScriptEngine scriptEngine, Object element) {
        if (element instanceof IFile || element instanceof File || element instanceof URI) {
            return scriptEngine.getDescription().getSupportedScriptTypes().contains(ResourceDropHandler.getScriptType(element));
        }
        IFile adaptedFile = (IFile)Platform.getAdapterManager().getAdapter(element, IFile.class);
        if (adaptedFile != null) {
            return scriptEngine.getDescription().getSupportedScriptTypes().contains(ResourceDropHandler.getScriptType(adaptedFile));
        }
        return false;
    }

    @Override
    public void performDrop(IScriptEngine scriptEngine, Object element) {
        try {
            ICodeFactory codeFactory = ScriptService.getCodeFactory((IScriptEngine)scriptEngine);
            Method includeMethod = EnvironmentModule.class.getMethod("include", String.class);
            if (element instanceof IFile || element instanceof File) {
                String call = codeFactory.createFunctionCall(includeMethod, new Object[]{ResourceTools.toAbsoluteLocation((Object)element, null)});
                scriptEngine.executeAsync((Object)call);
            } else if (element instanceof URI) {
                String call = codeFactory.createFunctionCall(includeMethod, new Object[]{element.toString()});
                scriptEngine.executeAsync((Object)call);
            } else {
                IFile adaptedFile = (IFile)Platform.getAdapterManager().getAdapter(element, IFile.class);
                if (adaptedFile != null) {
                    this.performDrop(scriptEngine, adaptedFile);
                } else {
                    scriptEngine.executeAsync(element);
                }
            }
        }
        catch (Exception e) {
            Logger.error((String)"org.eclipse.ease.ui", (String)"include() method not found in Environment module", (Throwable)e);
            scriptEngine.executeAsync(element);
        }
    }

    private static ScriptType getScriptType(Object element) {
        IScriptService scriptService = (IScriptService)PlatformUI.getWorkbench().getService(IScriptService.class);
        return scriptService.getScriptType(ResourceTools.toAbsoluteLocation((Object)element, null));
    }
}

