/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.scripts.handler;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ease.IExecutionListener;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.IScriptEngineProvider;
import org.eclipse.ease.Logger;
import org.eclipse.ease.Script;
import org.eclipse.ease.service.EngineDescription;
import org.eclipse.ease.service.ScriptType;
import org.eclipse.ease.tools.StringTools;
import org.eclipse.ease.ui.Activator;
import org.eclipse.ease.ui.scripts.ScriptEditorInput;
import org.eclipse.ease.ui.scripts.ScriptStorage;
import org.eclipse.ease.ui.scripts.dialogs.SelectScriptStorageDialog;
import org.eclipse.ease.ui.scripts.preferences.PreferencesHelper;
import org.eclipse.ease.ui.scripts.repository.IRepositoryService;
import org.eclipse.ease.ui.tools.ToggleHandler;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.menus.UIElement;

public class ToggleScriptRecording
extends ToggleHandler
implements IHandler,
IElementUpdater,
IExecutionListener {
    private static final Map<IScriptEngine, StringBuffer> fRecordings = new HashMap<IScriptEngine, StringBuffer>();
    private boolean fChecked = false;

    private static StringBuffer addHeaderData(StringBuffer buffer, String scriptName, ScriptType scriptType) {
        HashMap<String, String> keywords = new HashMap<String, String>();
        keywords.put("name", new Path(scriptName).makeRelative().toString());
        keywords.put("description", "Script recorded by user.");
        keywords.put("script-type", scriptType.getName());
        keywords.put("author", System.getProperty("user.name"));
        keywords.put("date-recorded", new SimpleDateFormat("yyyy-MM-dd, HH:mm").format(new Date()));
        String keywordBlock = scriptType.getCodeFactory().createKeywordHeader(keywords, null);
        buffer.insert(0, StringTools.LINE_DELIMITER);
        buffer.insert(0, scriptType.getCodeFactory().createCommentedString(keywordBlock, true));
        return buffer;
    }

    private static String askForScriptName(ExecutionEvent event, ScriptStorage storage) {
        InputDialog dialog = new InputDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), "Save Script", "Enter a unique name for your script (use '/' as path delimiter)", "", name -> {
            if (storage != null && storage.exists(new Path(name).makeAbsolute().toString())) {
                return "Script name <" + name + "> is already in use. Choose a different one.";
            }
            return null;
        });
        if (dialog.open() == 0) {
            return dialog.getValue();
        }
        return null;
    }

    private static ScriptStorage createOrGetStorage() {
        if (PreferencesHelper.getUserScriptStorageLocation() == null) {
            SelectScriptStorageDialog dialog = new SelectScriptStorageDialog(Display.getDefault().getActiveShell());
            if (dialog.open() == 0) {
                IRepositoryService repositoryService = (IRepositoryService)PlatformUI.getWorkbench().getService(IRepositoryService.class);
                repositoryService.addLocation(dialog.getLocation(), true, true);
            } else {
                return null;
            }
        }
        return ScriptStorage.createStorage();
    }

    protected final void executeToggle(ExecutionEvent event, boolean checked) {
        IScriptEngine engine;
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (part instanceof IScriptEngineProvider && (engine = ((IScriptEngineProvider)part).getScriptEngine()) != null) {
            if (checked) {
                fRecordings.put(engine, new StringBuffer());
                engine.addExecutionListener((IExecutionListener)this);
            } else {
                StringBuffer buffer = fRecordings.remove(engine);
                if (buffer.length() > 0) {
                    ScriptStorage storage = ToggleScriptRecording.createOrGetStorage();
                    String scriptName = ToggleScriptRecording.askForScriptName(event, storage);
                    EngineDescription description = engine.getDescription();
                    ScriptType scriptType = (ScriptType)description.getSupportedScriptTypes().iterator().next();
                    buffer = ToggleScriptRecording.addHeaderData(buffer, scriptName, scriptType);
                    if (storage != null) {
                        String fileName = String.valueOf(scriptName) + "." + scriptType.getDefaultExtension();
                        if (!storage.store(fileName, buffer.toString())) {
                            MessageDialog.openError((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)"Save error", (String)"Could not store script data");
                        }
                    } else {
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        try {
                            IEditorDescriptor editor = IDE.getDefaultEditor((IFile)ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path("/sample/foo." + scriptType.getDefaultExtension())));
                            IEditorPart openEditor = IDE.openEditor((IWorkbenchPage)page, (IEditorInput)new ScriptEditorInput(scriptName, buffer.toString()), (String)editor.getId());
                            openEditor.doSaveAs();
                        }
                        catch (PartInitException e) {
                            Logger.error((String)"org.eclipse.ease.ui.scripts", (String)"Could not open editor for recorded script.", (Throwable)e);
                        }
                    }
                }
            }
        }
        this.fChecked = checked;
    }

    public final void updateElement(UIElement element, Map parameters) {
        super.updateElement(element, parameters);
        if (this.fChecked) {
            element.setIcon(Activator.getImageDescriptor((String)"org.eclipse.ease.ui.scripts", (String)"icons/elcl16/stop_script_recording.png"));
        } else {
            element.setIcon(Activator.getImageDescriptor((String)"org.eclipse.ease.ui.scripts", (String)"icons/elcl16/start_script_recording.png"));
        }
    }

    public void notify(IScriptEngine engine, Script script, int status) {
        if (4 == status) {
            try {
                StringBuffer buffer = fRecordings.get(engine);
                if (buffer != null) {
                    buffer.append(script.getCode());
                    if (!buffer.toString().endsWith(StringTools.LINE_DELIMITER)) {
                        buffer.append(StringTools.LINE_DELIMITER);
                    }
                } else {
                    engine.removeExecutionListener((IExecutionListener)this);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

