/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.scripts.keywordhandler;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.Parameterization;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.ease.Logger;
import org.eclipse.ease.ui.scripts.repository.IScript;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.keys.KeyBinding;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.internal.keys.BindingService;
import org.eclipse.ui.keys.IBindingService;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class KeyHandler
implements EventHandler {
    private final Map<IScript, Binding> fActiveBindings = new HashMap<IScript, Binding>();

    public void handleEvent(Event event) {
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getService(IBindingService.class);
        IScript script = (IScript)event.getProperty("script");
        String value = (String)event.getProperty("value");
        Binding oldBinding = this.fActiveBindings.get(script);
        if (oldBinding != null && bindingService instanceof BindingService) {
            ((BindingService)bindingService).removeBinding(this.fActiveBindings.get(script));
        }
        if (value != null) {
            try {
                ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                Command runScriptCommand = commandService.getCommand("org.eclipse.ease.commands.script.run");
                Parameterization parameter = new Parameterization(runScriptCommand.getParameters()[0], script.getPath().toString());
                ParameterizedCommand command = new ParameterizedCommand(runScriptCommand, new Parameterization[]{parameter});
                KeySequence instance = KeySequence.getInstance((String)value);
                KeyBinding binding = new KeyBinding(instance, command, bindingService.getDefaultSchemeId(), "org.eclipse.ui.contexts.window", null, null, null, 0);
                if (bindingService instanceof BindingService) {
                    ((BindingService)bindingService).addBinding((Binding)binding);
                    this.fActiveBindings.put(script, (Binding)binding);
                }
            }
            catch (ParseException e) {
                Logger.error((String)"org.eclipse.ease.ui.scripts", (String)("Invalid keyboard shortcut for script: " + script.getLocation()), (Throwable)e);
            }
            catch (NotDefinedException e) {
                Logger.error((String)"org.eclipse.ease.ui.scripts", (String)"Could not detect runScript command");
            }
        }
    }
}

