/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.debugging.events.model;

import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.ease.Script;
import org.eclipse.ease.debugging.events.AbstractEvent;
import org.eclipse.ease.debugging.events.model.IModelRequest;

public class BreakpointRequest
extends AbstractEvent
implements IModelRequest {
    private final Script fScript;
    private final IBreakpoint fBreakpoint;
    private final Mode fMode;

    public BreakpointRequest(Script script, IBreakpoint breakpoint, Mode mode) {
        this.fScript = script;
        this.fBreakpoint = breakpoint;
        this.fMode = mode;
    }

    public BreakpointRequest(Mode mode) {
        this(null, null, mode);
    }

    public Script getScript() {
        return this.fScript;
    }

    public IBreakpoint getBreakpoint() {
        return this.fBreakpoint;
    }

    public Mode getMode() {
        return this.fMode;
    }

    public boolean isRemoveAllBreakpointsRequest() {
        return this.fScript == null && this.fBreakpoint == null && Mode.REMOVE == this.fMode;
    }

    @Override
    public String toString() {
        if (this.isRemoveAllBreakpointsRequest()) {
            return String.valueOf(super.toString()) + " (remove all)";
        }
        int lineNumber = this.getBreakpoint().getMarker().getAttribute("lineNumber", -1);
        if (this.fMode == Mode.ADD) {
            return String.valueOf(super.toString()) + " (+ line " + lineNumber + ")";
        }
        if (this.fMode == Mode.REMOVE) {
            return String.valueOf(super.toString()) + " (- line " + lineNumber + ")";
        }
        return super.toString();
    }

    public static enum Mode {
        ADD,
        REMOVE;

    }
}

