/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.platform.debug;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.ease.ICompletionContext;
import org.eclipse.ease.Logger;
import org.eclipse.ease.ui.completion.AbstractCompletionProvider;
import org.eclipse.ease.ui.completion.IImageResolver;

public class LaunchModuleCompletionProvider
extends AbstractCompletionProvider {
    public boolean isActive(ICompletionContext context) {
        if (context.getType() == ICompletionContext.Type.STRING_LITERAL) {
            String caller = context.getCaller();
            int param = context.getParameterOffset();
            if (caller.endsWith("launch") || caller.endsWith("launchUI")) {
                return param == 0 || param == 1;
            }
            if (caller.endsWith("getLaunchConfiguration")) {
                return param == 0;
            }
        }
        return false;
    }

    protected void prepareProposals(ICompletionContext context) {
        if (context.getParameterOffset() == 0) {
            try {
                ILaunchConfiguration[] configurations;
                ILaunchConfiguration[] iLaunchConfigurationArray = configurations = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations();
                int n = configurations.length;
                int n2 = 0;
                while (n2 < n) {
                    ILaunchConfiguration configuration = iLaunchConfigurationArray[n2];
                    String name = configuration.getName();
                    ILaunchConfigurationType type = configuration.getType();
                    String typeName = type.getName();
                    String display = String.valueOf(name) + " - " + typeName;
                    this.addProposal(display, name, (IImageResolver)new AbstractCompletionProvider.DescriptorImageResolver(DebugUITools.getDefaultImageDescriptor((Object)configuration)), 0, null);
                    ++n2;
                }
            }
            catch (CoreException e) {
                Logger.warning((String)"org.eclipse.ease.modules.platform", (String)"Code Completion: could not read launch configurations", (Throwable)e);
            }
        } else {
            ArrayList proposals = new ArrayList();
            ILaunchGroup[] launchGroups = DebugUITools.getLaunchGroups();
            HashMap<String, ILaunchGroup> modes = new HashMap<String, ILaunchGroup>();
            ILaunchGroup[] type = launchGroups;
            int name = launchGroups.length;
            int n = 0;
            while (n < name) {
                ILaunchGroup launchGroup = type[n];
                modes.put(launchGroup.getMode(), launchGroup);
                ++n;
            }
            for (ILaunchGroup launchGroup : modes.values()) {
                String display = launchGroup.getLabel().replace("&", "");
                String name2 = launchGroup.getMode();
                this.addProposal(display, name2, (IImageResolver)new AbstractCompletionProvider.DescriptorImageResolver(launchGroup.getImageDescriptor()), 0, null);
            }
        }
    }
}

