/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.completions.java.provider;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.ease.ICompletionContext;
import org.eclipse.ease.Logger;
import org.eclipse.ease.ui.completion.AbstractCompletionProvider;
import org.eclipse.ease.ui.completion.IImageResolver;
import org.eclipse.ease.ui.completions.java.help.handlers.JavaPackageHelpResolver;
import org.eclipse.ease.ui.completions.java.provider.JavaMethodCompletionProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class JavaPackagesCompletionProvider
extends AbstractCompletionProvider {
    private static Map<String, Collection<String>> PACKAGES = null;
    private static final Pattern JAVA_VERSION_MATCHER = Pattern.compile("1\\.(\\d)\\..*");

    private static int getJavaMajorVersion() {
        int result = 0;
        String version = System.getProperty("java.runtime.version");
        Matcher matcher = JAVA_VERSION_MATCHER.matcher(version);
        result = matcher.matches() ? Integer.parseInt(matcher.group(1)) : Integer.parseInt(version.substring(0, version.indexOf(46)));
        return Math.min(result, 12);
    }

    public boolean isActive(ICompletionContext context) {
        return super.isActive(context) && (context.getType() == ICompletionContext.Type.NONE || context.getType() == ICompletionContext.Type.PACKAGE);
    }

    protected void prepareProposals(ICompletionContext context) {
        String parentPackage;
        String string = parentPackage = context.getType() == ICompletionContext.Type.NONE ? "" : context.getPackage();
        if (JavaPackagesCompletionProvider.getPackages().get(parentPackage) != null) {
            for (String packageName : JavaPackagesCompletionProvider.getPackages().get(parentPackage)) {
                if (!this.matchesFilter(packageName)) continue;
                JavaPackageHelpResolver helpResolver = new JavaPackageHelpResolver(String.valueOf(parentPackage) + "." + packageName);
                if (parentPackage.isEmpty()) {
                    this.addProposal(packageName, String.valueOf(packageName) + ".", (IImageResolver)new JavaMethodCompletionProvider.JDTImageResolver("org.eclipse.jdt.ui.package_obj.gif"), 60, helpResolver);
                    continue;
                }
                this.addProposal(String.valueOf(parentPackage) + "." + packageName, String.valueOf(packageName) + ".", (IImageResolver)new JavaMethodCompletionProvider.JDTImageResolver("org.eclipse.jdt.ui.package_obj.gif"), 60, helpResolver);
            }
        }
    }

    public static BufferedReader getJavaClassDefinitions() throws IOException {
        URL url = new URL("platform:/plugin/org.eclipse.ease.ui/resources/java" + JavaPackagesCompletionProvider.getJavaMajorVersion() + " classes.txt");
        return new BufferedReader(new InputStreamReader(url.openConnection().getInputStream()));
    }

    public static Map<String, Collection<String>> getPackages() {
        if (PACKAGES == null) {
            PACKAGES = new HashMap<String, Collection<String>>();
            try {
                Throwable throwable = null;
                Object var1_3 = null;
                try (BufferedReader reader = JavaPackagesCompletionProvider.getJavaClassDefinitions();){
                    String className;
                    while ((className = reader.readLine()) != null) {
                        String packageName = className.substring(0, className.lastIndexOf(46));
                        JavaPackagesCompletionProvider.registerPackage(packageName);
                    }
                    reader.close();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                Logger.error((String)"org.eclipse.ease.ui.completions.java", (String)"Cannot read package list for code completion", (Throwable)e);
            }
            BundleContext context = FrameworkUtil.getBundle(JavaPackagesCompletionProvider.class).getBundleContext();
            Bundle[] bundleArray = context.getBundles();
            int n = bundleArray.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle bundle = bundleArray[n2];
                for (String packageName : JavaPackagesCompletionProvider.getExportedPackages(bundle)) {
                    JavaPackagesCompletionProvider.registerPackage(packageName);
                }
                ++n2;
            }
        }
        return PACKAGES;
    }

    public static Collection<String> getExportedPackages(Bundle bundle) {
        HashSet<String> exportedPackages = new HashSet<String>();
        String exportPackage = (String)bundle.getHeaders().get("Export-Package");
        if (exportPackage != null) {
            String[] packages;
            String[] stringArray = packages = exportPackage.split(",");
            int n = packages.length;
            int n2 = 0;
            while (n2 < n) {
                String packageEntry = stringArray[n2];
                String candidate = packageEntry.trim().split(";")[0];
                if (candidate.endsWith("\"")) {
                    candidate = candidate.substring(0, candidate.length() - 1);
                }
                if (!(candidate.contains(".internal") || packageEntry.contains(";x-internal:=true") || candidate.startsWith("Lib") || candidate.startsWith("about_files") || candidate.startsWith("META"))) {
                    exportedPackages.add(candidate);
                }
                ++n2;
            }
        }
        return exportedPackages;
    }

    private static void registerPackage(String packageName) {
        String value;
        int lastIndex = packageName.lastIndexOf(46);
        String key = lastIndex == -1 ? "" : packageName.substring(0, lastIndex);
        String string = value = lastIndex == -1 ? packageName : packageName.substring(lastIndex + 1);
        if (!PACKAGES.containsKey(key)) {
            PACKAGES.put(key, new HashSet());
        }
        PACKAGES.get(key).add(value);
        if (!key.isEmpty()) {
            JavaPackagesCompletionProvider.registerPackage(key);
        }
    }

    public static boolean containsPackage(String candidate) {
        Collection<String> packageList;
        int lastDot = candidate.lastIndexOf(46);
        Collection<String> collection = packageList = lastDot > 0 ? JavaPackagesCompletionProvider.getPackages().get(candidate.substring(0, lastDot)) : JavaPackagesCompletionProvider.getPackages().get("");
        if (packageList != null) {
            return packageList.contains(candidate.substring(lastDot + 1));
        }
        return false;
    }
}

