/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.unittest;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ease.debugging.IScriptDebugFrame;
import org.eclipse.ease.debugging.ScriptStackTrace;
import org.eclipse.ease.lang.unittest.definition.IDefinitionPackage;
import org.eclipse.ease.lang.unittest.definition.ITestSuiteDefinition;
import org.eclipse.ease.lang.unittest.definition.util.DefinitionResourceFactory;
import org.eclipse.ease.lang.unittest.runtime.IRuntimeFactory;
import org.eclipse.ease.lang.unittest.runtime.IStackTraceContainer;
import org.eclipse.ease.lang.unittest.runtime.ITestContainer;
import org.eclipse.ease.lang.unittest.runtime.ITestEntity;
import org.eclipse.ease.lang.unittest.runtime.ITestFile;
import org.eclipse.ease.lang.unittest.runtime.ITestFolder;
import org.eclipse.ease.lang.unittest.runtime.ITestResult;
import org.eclipse.ease.lang.unittest.runtime.ITestSuite;
import org.eclipse.ease.lang.unittest.runtime.impl.TestEntity;
import org.eclipse.ease.tools.ResourceTools;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.ui.texteditor.MarkerUtilities;

public final class UnitTestHelper {
    @Deprecated
    private UnitTestHelper() {
        throw new IllegalStateException("Constructor not meant to be called");
    }

    public static void createWorkspaceMarker(ITestResult result, TestEntity testEntity) {
        if (result.getStatus().getValue() == 5 || result.getStatus().getValue() == 4) {
            ScriptStackTrace trace = result.getStackTrace();
            if (trace == null && testEntity instanceof IStackTraceContainer) {
                trace = ((IStackTraceContainer)((Object)testEntity)).getStackTrace();
            }
            if (trace != null) {
                for (IScriptDebugFrame element : trace) {
                    Object file;
                    if (element.getScript() == null || !((file = element.getScript().getFile()) instanceof IFile) || !((IFile)file).exists()) continue;
                    try {
                        HashMap<String, Object> attributes = new HashMap<String, Object>();
                        attributes.put("lineNumber", element.getLineNumber());
                        attributes.put("severity", 2);
                        attributes.put("message", result.getMessage());
                        MarkerUtilities.createMarker((IResource)((IFile)file), attributes, (String)"org.eclipse.ease.lang.unittest.scriptassertion");
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public static void removeErrorMarkers(IFile file) {
        try {
            file.deleteMarkers("org.eclipse.ease.lang.unittest.scriptassertion", false, 0);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public static Map<Object, String> getTestFilesFromFilter(String[] filters, Object suite) {
        LinkedHashMap<Object, String> testFiles = new LinkedHashMap<Object, String>();
        String[] stringArray = filters;
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            if (!token.isBlank()) {
                testFiles.putAll(UnitTestHelper.createTests(token, suite));
            }
            ++n2;
        }
        return testFiles;
    }

    private static Map<Object, String> createTests(String filter, Object suite) {
        HashMap<Object, String> testFiles = new HashMap<Object, String>();
        Pattern pattern = UnitTestHelper.buildPattern(filter);
        if (filter.contains("*")) {
            String fixedPart = filter.substring(0, filter.indexOf(42));
            if (fixedPart.contains("/")) {
                fixedPart = fixedPart.substring(0, fixedPart.lastIndexOf(47) + 1);
            }
            Object folder = ResourceTools.resolve((Object)fixedPart, (Object)suite);
            String folderLocation = ResourceTools.toAbsoluteLocation((Object)folder, null);
            ArrayList<Object> children = new ArrayList<Object>();
            children.addAll(Arrays.asList(UnitTestHelper.getChildren(folder)));
            while (!children.isEmpty()) {
                Object child = children.remove(0);
                if (ResourceTools.isFile(child)) {
                    String relevantPath;
                    String fileLocation = ResourceTools.toAbsoluteLocation(child, null);
                    String relativeLocation = fileLocation.substring(folderLocation.length());
                    if (relativeLocation.startsWith("/")) {
                        relativeLocation = relativeLocation.substring(1);
                    }
                    if (!pattern.matcher(relevantPath = String.valueOf(fixedPart) + relativeLocation).matches()) continue;
                    testFiles.put(child, filter);
                    continue;
                }
                if (!ResourceTools.isFolder(child)) continue;
                children.addAll(0, Arrays.asList(UnitTestHelper.getChildren(child)));
            }
        } else {
            Object candidate = ResourceTools.resolve((Object)filter, (Object)suite);
            if (ResourceTools.exists((Object)candidate)) {
                testFiles.put(candidate, filter);
            }
        }
        return testFiles;
    }

    private static Object[] getChildren(Object folder) {
        try {
            if (folder instanceof IContainer) {
                return ((IContainer)folder).members();
            }
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        if (folder instanceof File) {
            return ((File)folder).listFiles();
        }
        return new Object[0];
    }

    private static Pattern buildPattern(String filter) {
        if (filter.endsWith("/")) {
            filter = String.valueOf(filter) + "**";
        }
        filter = filter.replaceAll("[\\<\\(\\[\\{\\\\\\^\\-\\=\\$\\!\\|\\]\\}\\)\u200c\u200b\\?\\*\\+\\.\\>]", "\\\\$0");
        filter = filter.replaceAll("\\Q\\*\\*\\E", ".*");
        filter = filter.replaceAll("\\Q\\*\\E", "[^\\/]*");
        return Pattern.compile(filter);
    }

    public static List<ITestEntity> createTestStructure(Map<Object, String> acceptedFiles) {
        ArrayList<ITestEntity> testRoot = new ArrayList<ITestEntity>();
        int insertionIndex = 1;
        for (Map.Entry<Object, String> entry : acceptedFiles.entrySet()) {
            String testFileLocation = ResourceTools.toAbsoluteLocation((Object)entry.getKey(), null);
            testFileLocation = testFileLocation.replace("://", "/").replace(":/", "/");
            IPath testFilePath = new Path(testFileLocation).makeAbsolute();
            ITestFile testFile = IRuntimeFactory.eINSTANCE.createTestFile();
            testFile.setResource(entry.getKey());
            testFile.setName(testFilePath.lastSegment());
            testFile.setDescription(entry.getValue());
            testFile.setInsertionOrder(insertionIndex++);
            ITestFolder container = UnitTestHelper.createTestFolder(testFilePath.removeLastSegments(1), testRoot);
            container.getChildren().add((Object)testFile);
        }
        return testRoot;
    }

    private static ITestFolder createTestFolder(IPath path, List<ITestEntity> rootElements) {
        if (path.segmentCount() > 1) {
            ITestFolder targetFolder = UnitTestHelper.createTestFolder(path.removeLastSegments(1), rootElements);
            for (ITestEntity entity : targetFolder.getChildren()) {
                if (!(entity instanceof ITestFolder) || !path.lastSegment().equals(entity.getName())) continue;
                return (ITestFolder)entity;
            }
            ITestFolder newFolder = IRuntimeFactory.eINSTANCE.createTestFolder();
            newFolder.setName(path.lastSegment());
            targetFolder.getChildren().add((Object)newFolder);
            return newFolder;
        }
        for (ITestEntity entity : rootElements) {
            if (!(entity instanceof ITestFolder) || !path.lastSegment().equals(entity.getName())) continue;
            return (ITestFolder)entity;
        }
        ITestFolder newFolder = IRuntimeFactory.eINSTANCE.createTestFolder();
        newFolder.setName(path.lastSegment());
        rootElements.add(newFolder);
        return newFolder;
    }

    public static ITestSuiteDefinition loadTestSuite(InputStream stream) throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        resourceSet.getPackageRegistry().put((Object)"http://eclipse.org/ease/unittest/testsuite/1.0", (Object)IDefinitionPackage.eINSTANCE);
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("suite", new DefinitionResourceFactory());
        Resource resource = resourceSet.createResource(URI.createURI((String)"*.suite"));
        resource.load(stream, null);
        EObject content = (EObject)resource.getContents().get(0);
        if (content instanceof ITestSuiteDefinition) {
            return (ITestSuiteDefinition)content;
        }
        return null;
    }

    public static byte[] serializeTestSuite(ITestSuiteDefinition testSuiteDefinition) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        resourceSet.getPackageRegistry().put((Object)"http://eclipse.org/ease/unittest/testsuite/1.0", (Object)IDefinitionPackage.eINSTANCE);
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("suite", new DefinitionResourceFactory());
        Resource resource = resourceSet.createResource(URI.createURI((String)"*.suite"));
        resource.getContents().add((Object)testSuiteDefinition);
        resource.save((OutputStream)outputStream, Collections.EMPTY_MAP);
        return outputStream.toByteArray();
    }

    public static ITestSuite createRuntimeSuite(ITestSuiteDefinition definition) {
        String[] includeFilters = definition.getIncludeFilter() != null ? definition.getIncludeFilter().split("\r?\n") : new String[]{};
        String[] excludeFilters = definition.getExcludeFilter() != null ? definition.getExcludeFilter().split("\r?\n") : new String[]{};
        Map<Object, String> includedFiles = UnitTestHelper.getTestFilesFromFilter(includeFilters, definition.getResource());
        Map<Object, String> excludedFiles = UnitTestHelper.getTestFilesFromFilter(excludeFilters, definition.getResource());
        includedFiles.keySet().removeAll(excludedFiles.keySet());
        List<ITestEntity> testStructure = UnitTestHelper.createTestStructure(includedFiles);
        ITestSuite testSuite = IRuntimeFactory.eINSTANCE.createTestSuite();
        testSuite.getChildren().addAll(testStructure);
        testSuite.setName(definition.getName());
        testSuite.setDefinition(definition);
        return testSuite;
    }

    public static Collection<ITestFile> getTestFiles(ITestContainer testContainer) {
        if (testContainer instanceof ITestFile) {
            return Arrays.asList((ITestFile)testContainer);
        }
        HashSet<ITestFile> testFiles = new HashSet<ITestFile>();
        for (ITestContainer child : testContainer.getChildContainers()) {
            testFiles.addAll(UnitTestHelper.getTestFiles(child));
        }
        return testFiles;
    }
}

