/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.completions.java.provider;

import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.ease.ICompletionContext;
import org.eclipse.ease.ui.completion.IImageResolver;
import org.eclipse.ease.ui.completion.provider.AbstractCompletionProvider;
import org.eclipse.ease.ui.completion.tokenizer.InputTokenizer;
import org.eclipse.ease.ui.completion.tokenizer.TokenList;
import org.eclipse.ease.ui.completions.java.help.handlers.JavaClassHelpResolver;
import org.eclipse.ease.ui.completions.java.provider.JavaMethodCompletionProvider;
import org.eclipse.ease.ui.completions.java.provider.JavaResources;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.StyledString;

public class JavaClassCompletionProvider
extends AbstractCompletionProvider {
    public boolean isActive(ICompletionContext context) {
        return super.isActive(context) && this.isPackage(context) || this.isClass(context) || context.getFilter().length() >= 3 && Character.isUpperCase(context.getFilter().charAt(0));
    }

    private boolean isClass(ICompletionContext context) {
        TokenList tokens = new TokenList(context.getTokens()).getFromLast(Class.class);
        if (!tokens.isEmpty()) {
            tokens.remove(0);
            tokens.removeIfMatches(0, "()");
            tokens.removeIfMatches(0, ".");
            return tokens.isEmpty() || InputTokenizer.isTextFilter((Object)tokens.get(0));
        }
        return false;
    }

    private boolean isPackage(ICompletionContext context) {
        TokenList tokens = new TokenList(context.getTokens()).getFromLast(Package.class);
        if (!tokens.isEmpty()) {
            tokens.remove(0);
            tokens.removeIfMatches(0, ".");
            return tokens.isEmpty() || InputTokenizer.isTextFilter((Object)tokens.get(0));
        }
        return false;
    }

    protected void prepareProposals(ICompletionContext context) {
        String filter = context.getFilter();
        if (this.isPackage(context)) {
            Collection<String> candidates = JavaResources.getInstance().getClasses(this.getPackageName(context));
            for (String candidate : candidates) {
                if (!candidate.startsWith(filter)) continue;
                JavaClassHelpResolver helpResolver = new JavaClassHelpResolver(this.getPackageName(context), candidate);
                JavaClassImageResolver imageResolver = new JavaClassImageResolver(this.getPackageName(context), candidate);
                this.addProposal(candidate, candidate, (IImageResolver)imageResolver, 70, helpResolver);
            }
        } else if (this.isClass(context)) {
            Class baseClass = (Class)new TokenList(context.getTokens()).getFromLast(Class.class).get(0);
            String basePackage = baseClass.getPackage().getName();
            Pattern filterPattern = Pattern.compile(String.valueOf(baseClass.getSimpleName()) + "\\." + this.createFilterPattern(filter).pattern());
            for (String candidate : JavaResources.getInstance().getClasses().get(basePackage)) {
                if (!filterPattern.matcher(candidate).matches()) continue;
                String replacementString = (String.valueOf(basePackage) + "." + candidate).substring(baseClass.getName().length() + 1);
                JavaClassHelpResolver helpResolver = new JavaClassHelpResolver(basePackage, candidate);
                JavaClassImageResolver imageResolver = new JavaClassImageResolver(basePackage, candidate);
                StyledString styledString = new StyledString(candidate);
                styledString.append(" - " + basePackage, StyledString.QUALIFIER_STYLER);
                this.addProposal(styledString, replacementString, (IImageResolver)imageResolver, 70, helpResolver);
            }
        } else {
            Pattern filterPattern = this.createFilterPattern(filter);
            for (Map.Entry<String, Collection<String>> packageEntry : JavaResources.getInstance().getClasses().entrySet()) {
                for (String candidate : packageEntry.getValue()) {
                    if (!filterPattern.matcher(candidate).matches()) continue;
                    JavaClassHelpResolver helpResolver = new JavaClassHelpResolver(packageEntry.getKey(), candidate);
                    JavaClassImageResolver imageResolver = new JavaClassImageResolver(packageEntry.getKey(), candidate);
                    StyledString styledString = new StyledString(candidate);
                    styledString.append(" - " + packageEntry.getKey(), StyledString.QUALIFIER_STYLER);
                    this.addProposal(styledString, String.valueOf(packageEntry.getKey()) + "." + candidate, (IImageResolver)imageResolver, 70, helpResolver);
                }
            }
        }
    }

    private Pattern createFilterPattern(String filter) {
        StringBuffer filterPattern = new StringBuffer();
        byte[] byArray = filter.getBytes();
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            byte character = byArray[n2];
            if (Character.isUpperCase((char)character)) {
                filterPattern.append(".*");
            }
            filterPattern.append((char)character);
            ++n2;
        }
        if (filterPattern.toString().startsWith(".*")) {
            filterPattern.delete(0, 2);
        }
        return Pattern.compile(String.valueOf(filterPattern.toString()) + ".*");
    }

    private String getPackageName(ICompletionContext context) {
        return ((Package)new TokenList(context.getTokens()).getFromLast(Package.class).get(0)).getName();
    }

    private static final class JavaClassImageResolver
    extends AbstractCompletionProvider.DescriptorImageResolver {
        private final String fPackageName;
        private final String fClassName;

        private JavaClassImageResolver(String packageName, String className) {
            this.fPackageName = packageName;
            this.fClassName = className;
        }

        protected ImageDescriptor getDescriptor() {
            try {
                Class<?> clazz = JavaClassCompletionProvider.class.getClassLoader().loadClass(String.valueOf(this.fPackageName) + "." + this.fClassName.replace('.', '$'));
                if (clazz.isEnum()) {
                    return JavaMethodCompletionProvider.JDTImageResolver.getDescriptor("org.eclipse.jdt.ui.enum_obj.gif");
                }
                if (clazz.isInterface()) {
                    return JavaMethodCompletionProvider.JDTImageResolver.getDescriptor("org.eclipse.jdt.ui.int_obj.gif");
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            return JavaMethodCompletionProvider.JDTImageResolver.getDescriptor("org.eclipse.jdt.ui.class_obj.gif");
        }
    }
}

