/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.spi.swt.control.text.richtext.renderer;

import javax.inject.Inject;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.core.swt.renderer.TextControlSWTRenderer;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.editsupport.EMFFormsEditSupport;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.emfforms.spi.swt.core.layout.EMFFormsSWTLayoutUtil;
import org.eclipse.emfforms.spi.swt.core.util.PopupWindow;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class RichTextControlSWTRenderer
extends TextControlSWTRenderer {
    private GridData textGridData;
    private Text text;

    protected int getPreferrredPopupHeight() {
        return 450;
    }

    protected PopupWindow createPopupWindow() {
        return new PopupWindow((Control)this.text, this.getPreferrredPopupHeight(), 16, true);
    }

    @Inject
    public RichTextControlSWTRenderer(VControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabinding emfFormsDatabinding, EMFFormsLabelProvider emfFormsLabelProvider, VTViewTemplateProvider vtViewTemplateProvider, EMFFormsEditSupport emfFormsEditSupport) {
        super(vElement, viewContext, reportService, emfFormsDatabinding, emfFormsLabelProvider, vtViewTemplateProvider, emfFormsEditSupport);
    }

    protected Control createSWTControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).equalWidth(true).applyTo(composite);
        this.text = new Text(composite, this.getTextWidgetStyle());
        this.text.setData("org.eclipse.rap.rwt.customVariant", (Object)this.getTextVariantID());
        this.text.setEditable(false);
        this.text.setMessage(this.getTextMessage());
        GridDataFactory gdf = GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, true).span(1, 1);
        EMFFormsEditSupport editSupport = this.getEMFFormsEditSupport();
        if (editSupport.isMultiLine(((VControl)this.getVElement()).getDomainModelReference(), this.getViewModelContext().getDomainModel())) {
            gdf.hint(50, this.getTextHeightHint());
        }
        this.textGridData = gdf.create();
        this.text.setLayoutData((Object)this.textGridData);
        this.text.addMouseListener((MouseListener)new OpenPopupHandler(this.text));
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ((RichTextControlSWTRenderer)RichTextControlSWTRenderer.this).textGridData.heightHint = RichTextControlSWTRenderer.this.getTextHeightHint();
                RichTextControlSWTRenderer.this.text.setLayoutData((Object)RichTextControlSWTRenderer.this.textGridData);
                EMFFormsSWTLayoutUtil.adjustParentSize((Control)RichTextControlSWTRenderer.this.text);
            }
        });
        return composite;
    }

    protected void postInit() {
        super.postInit();
    }

    protected int getTextHeightHint() {
        if (this.text == null || this.text.isDisposed()) {
            return -1;
        }
        int lineCount = this.text.getLineCount();
        int height = lineCount * this.text.getLineHeight();
        int maxHeight = this.getMaxTextHeight();
        int minHeight = this.getMinTextHeight();
        if (height > maxHeight) {
            height = maxHeight;
        } else if (height < minHeight) {
            height = minHeight;
        }
        return height;
    }

    protected int getMaxTextHeight() {
        if (this.text == null || this.text.isDisposed()) {
            return -1;
        }
        return this.getMaxVisibleLines() * this.text.getLineHeight();
    }

    protected int getMinTextHeight() {
        if (this.text == null || this.text.isDisposed()) {
            return -1;
        }
        return this.getMinVisibleLines() * this.text.getLineHeight();
    }

    protected int getMinVisibleLines() {
        return 2;
    }

    protected int getMaxVisibleLines() {
        return 10;
    }

    private final class OpenPopupHandler
    implements MouseListener {
        private final Text text;

        private OpenPopupHandler(Text text) {
            this.text = text;
        }

        public void mouseUp(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
            final PopupWindow popupWindow = RichTextControlSWTRenderer.this.createPopupWindow();
            final Text innerText = new Text(popupWindow.getContent(), 834);
            GridData layoutData = new GridData(4, 4, true, true);
            layoutData.heightHint = RichTextControlSWTRenderer.this.getPreferrredPopupHeight();
            innerText.setLayoutData((Object)layoutData);
            innerText.setSize(300, RichTextControlSWTRenderer.this.getPreferrredPopupHeight());
            popupWindow.getContent().pack();
            innerText.setText(this.text.getText());
            innerText.setSelection(this.text.getCaretPosition());
            innerText.addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent e) {
                    popupWindow.close();
                }

                public void focusGained(FocusEvent e) {
                }
            });
            innerText.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    OpenPopupHandler.this.text.setText(innerText.getText());
                }
            });
            popupWindow.open();
        }

        public void mouseDoubleClick(MouseEvent e) {
        }
    }
}

